/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws;

import br.com.ingenieux.mojo.aws.Expose;
import br.com.ingenieux.mojo.aws.util.AWSClientFactory;
import br.com.ingenieux.mojo.aws.util.TypeUtil;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractAWSMojo<S extends AmazonWebServiceClient>
extends AbstractMojo
implements Contextualizable {
    protected final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    @Parameter(defaultValue="${session}", required=true)
    protected MavenSession session;
    private static final String SECURITY_DISPATCHER_CLASS_NAME = "org.sonatype.plexus.components.sec.dispatcher.SecDispatcher";
    @Parameter(property="settings", required=true, readonly=true)
    protected Settings settings;
    protected AWSCredentialsProvider awsCredentialsProvider;
    @Parameter(property="beanstalker.serverId", defaultValue="aws.amazon.com")
    protected String serverId;
    @Parameter(property="beanstalker.credentialId", defaultValue="default")
    protected String credentialId;
    @Parameter(property="beanstalker.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="beanstalker.ignoreExceptions", defaultValue="false")
    protected boolean ignoreExceptions;
    protected String version = "?";
    protected Context context;
    @Parameter(property="beanstalker.region")
    protected String regionName = "us-east-1";
    protected Region regionObj;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected AWSClientFactory clientFactory;
    private PlexusContainer container;
    private S service;

    public Region getRegion() {
        if (null != this.regionObj) {
            return this.regionObj;
        }
        this.regionObj = RegionUtils.getRegion((String)this.regionName);
        Validate.notNull((Object)this.regionObj, (String)("Invalid region: " + this.regionName));
        return this.regionObj;
    }

    protected AbstractAWSMojo() {
        this.setupVersion();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public AWSCredentialsProvider getAWSCredentials() throws MojoFailureException {
        if (null != this.awsCredentialsProvider) {
            return this.awsCredentialsProvider;
        }
        this.awsCredentialsProvider = new BeanstalkerAWSCredentialsProviderChain(this.serverId, this.credentialId);
        return this.awsCredentialsProvider;
    }

    public AWSClientFactory getClientFactory() {
        return this.clientFactory;
    }

    protected Expose exposeSettings(String serverId) throws MojoFailureException {
        Server server = this.settings.getServer(serverId);
        Expose expose = new Expose();
        if (null != server) {
            expose.setServerId(serverId);
            expose.setAccessKey(server.getUsername());
            expose.setSharedKey(this.getDecryptedAwsKey(server.getPassword().trim()));
        } else {
            this.getLog().warn((CharSequence)String.format("serverId['%s'] not found. Using runtime defaults", serverId));
            expose.setServerId("runtime");
            expose.setAccessKey(this.getAWSCredentials().getCredentials().getAWSAccessKeyId());
            expose.setSharedKey(this.getAWSCredentials().getCredentials().getAWSSecretKey());
        }
        return expose;
    }

    private String getDecryptedAwsKey(String awsSecretKey) {
        if (awsSecretKey.startsWith("{") && awsSecretKey.endsWith("}")) {
            return this.decryptPassword(awsSecretKey);
        }
        this.getLog().warn((CharSequence)"You should encrypt your passwords. See http://beanstalker.ingenieux.com.br/security.html for more information");
        return awsSecretKey;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private boolean hasServerSettings() {
        if (this.serverId == null) {
            return false;
        }
        Server srv = this.settings.getServer(this.serverId);
        return srv != null;
    }

    private String decryptPassword(String password) {
        if (password != null) {
            try {
                Class<?> securityDispatcherClass = this.container.getClass().getClassLoader().loadClass(SECURITY_DISPATCHER_CLASS_NAME);
                Object securityDispatcher = this.container.lookup(SECURITY_DISPATCHER_CLASS_NAME, "maven");
                Method decrypt = securityDispatcherClass.getMethod("decrypt", String.class);
                return (String)decrypt.invoke(securityDispatcher, password);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"security features are disabled. Cannot find plexus security dispatcher", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)"password could not be decrypted");
        return password;
    }

    protected ClientConfiguration getClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgent(this.getUserAgent());
        if (null != this.settings && null != this.settings.getActiveProxy()) {
            Proxy proxy = this.settings.getActiveProxy();
            clientConfiguration.setProxyHost(proxy.getHost());
            clientConfiguration.setProxyUsername(proxy.getUsername());
            clientConfiguration.setProxyPassword(proxy.getPassword());
            clientConfiguration.setProxyPort(proxy.getPort());
        }
        return clientConfiguration;
    }

    protected final String getUserAgent() {
        return String.format("Apache Maven/3.0 (ingenieux beanstalker/%s; http://beanstalker.ingenieux.com.br)", this.version);
    }

    protected void setupVersion() {
        InputStream is;
        block4: {
            is = null;
            try {
                Properties properties = new Properties();
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/beanstalker-core.properties");
                if (null == is) break block4;
                properties.load(is);
                this.version = properties.getProperty("beanstalker.version");
            }
            catch (Exception exc) {
                try {
                    this.getLog().warn((CharSequence)"Oops?", (Throwable)exc);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    protected void setupService() throws MojoExecutionException {
        Class<?> serviceClass = TypeUtil.getServiceClass(((Object)((Object)this)).getClass());
        this.service = (AmazonWebServiceClient)this.createServiceFor(serviceClass);
    }

    protected <T> T createServiceFor(Class<T> serviceClass) throws MojoExecutionException {
        try {
            this.clientFactory = new AWSClientFactory(this.getAWSCredentials(), this.getClientConfiguration(), this.regionName);
            return this.clientFactory.getService(serviceClass);
        }
        catch (Exception exc) {
            throw new MojoExecutionException("Unable to create service", exc);
        }
    }

    public S getService() {
        if (null == this.service) {
            try {
                this.setupService();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.service;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Object result;
        try {
            this.configure();
            result = this.executeInternal();
            this.getLog().info((CharSequence)"SUCCESS");
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"FAILURE", (Throwable)e);
            this.handleException(e);
            return;
        }
        this.displayResults(result);
    }

    protected void configure() {
    }

    public void handleException(Exception e) throws MojoExecutionException, MojoFailureException {
        if (!this.ignoreExceptions) {
            if (MojoExecutionException.class.isAssignableFrom(e.getClass())) {
                throw (MojoExecutionException)e;
            }
            if (MojoFailureException.class.isAssignableFrom(e.getClass())) {
                throw (MojoFailureException)e;
            }
            throw new MojoFailureException("Failed", (Throwable)e);
        }
        this.getLog().warn((CharSequence)"Ok. ignoreExceptions is set to true. No result for you!");
    }

    protected void displayResults(Object result) {
        try {
            String resultAsJsonString = this.objectMapper.writeValueAsString(result);
            if ("null".equals(resultAsJsonString)) {
                this.getLog().info((CharSequence)"null/void result");
                return;
            }
            List<String> lines = Arrays.asList(resultAsJsonString.split("\n"));
            for (String line : lines) {
                this.getLog().info((CharSequence)line);
            }
        }
        catch (Exception exc) {
            this.getLog().warn((CharSequence)"Oops", (Throwable)exc);
        }
    }

    protected abstract Object executeInternal() throws Exception;

    public boolean isVerbose() {
        return this.verbose;
    }

    class ExposeCredentialsProvider
    implements AWSCredentialsProvider {
        private final String serverId;

        public ExposeCredentialsProvider(String serverId) {
            this.serverId = serverId;
        }

        public AWSCredentials getCredentials() {
            if (!AbstractAWSMojo.this.hasServerSettings()) {
                return null;
            }
            try {
                Expose expose = AbstractAWSMojo.this.exposeSettings(this.serverId);
                String awsAccessKey = expose.getAccessKey();
                String awsSecretKey = expose.getSharedKey();
                return new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey)).getCredentials();
            }
            catch (Exception exc) {
                throw new RuntimeException("Oops", exc);
            }
        }

        public void refresh() {
        }
    }

    class BeanstalkerAWSCredentialsProviderChain
    extends AWSCredentialsProviderChain {
        public BeanstalkerAWSCredentialsProviderChain(String serverId, String profileName) {
            super(new AWSCredentialsProvider[]{new ExposeCredentialsProvider(serverId), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new ProfileCredentialsProvider(profileName), new InstanceProfileCredentialsProvider()});
        }
    }
}

