/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class BeanstalkerS3Client
extends AmazonS3Client {
    private static final String BLANK_LINE = StringUtils.repeat((String)" ", (int)24);
    private boolean multipartUpload = true;
    private boolean silentUpload = false;
    private TransferManager transferManager;

    public BeanstalkerS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, Region region) {
        super(credentialsProvider, clientConfiguration);
        this.init(region);
    }

    public boolean isMultipartUpload() {
        return this.multipartUpload;
    }

    public void setMultipartUpload(boolean multipartUploadP) {
        this.multipartUpload = multipartUploadP;
    }

    public boolean isSilentUpload() {
        return this.silentUpload;
    }

    public void setSilentUpload(boolean silentUpload) {
        this.silentUpload = silentUpload;
    }

    protected void init(Region region) {
        this.transferManager = new TransferManager((AmazonS3)this);
        TransferManagerConfiguration configuration = new TransferManagerConfiguration();
        configuration.setMultipartUploadThreshold(102400);
        this.transferManager.setConfiguration(configuration);
        this.setRegion(region);
    }

    public TransferManager getTransferManager() {
        return this.transferManager;
    }

    public String asNumber(long bytesTransfered) {
        return FileUtils.byteCountToDisplaySize((long)bytesTransfered).replaceAll("B$", "iB");
    }

    public PutObjectResult putObject(PutObjectRequest req) throws AmazonClientException, AmazonServiceException {
        if (!this.multipartUpload) {
            return super.putObject(req);
        }
        long contentLen = TransferManagerUtils.getContentLength((PutObjectRequest)req);
        String tempFilename = req.getKey() + ".tmp";
        String origFilename = req.getKey();
        req.setKey(tempFilename);
        XProgressListener progressListener = new XProgressListener();
        req.setGeneralProgressListener((ProgressListener)new ProgressListenerChain(new ProgressListener[]{progressListener}));
        progressListener.setContentLen(contentLen);
        progressListener.setUpload(this.transferManager.upload(req));
        progressListener.setSilentUpload(this.silentUpload);
        try {
            progressListener.getUpload().waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new AmazonClientException(e.getMessage(), (Throwable)e);
        }
        CopyObjectRequest copyReq = new CopyObjectRequest(req.getBucketName(), tempFilename, req.getBucketName(), origFilename);
        this.copyObject(copyReq);
        this.deleteObject(new DeleteObjectRequest(req.getBucketName(), tempFilename));
        return null;
    }

    public void deleteMultiparts(String bucketName, Date since) {
        this.transferManager.abortMultipartUploads(bucketName, since);
    }

    private final class XProgressListener
    implements ProgressListener {
        private long contentLen;
        private Upload upload;
        private boolean silentUpload;

        private XProgressListener() {
        }

        public void setContentLen(long contentLen) {
            this.contentLen = contentLen;
        }

        public void setSilentUpload(boolean silentUpload) {
            this.silentUpload = silentUpload;
        }

        public Upload getUpload() {
            return this.upload;
        }

        public void setUpload(Upload upload) {
            this.upload = upload;
        }

        public void progressChanged(ProgressEvent e) {
            if (null == this.upload) {
                return;
            }
            TransferProgress xProgress = this.upload.getProgress();
            if (!this.silentUpload) {
                System.out.print("\r  " + String.format("%.2f", xProgress.getPercentTransferred()) + "% " + BeanstalkerS3Client.this.asNumber(xProgress.getBytesTransferred()) + "/" + BeanstalkerS3Client.this.asNumber(this.contentLen) + BLANK_LINE);
            }
            switch (e.getEventCode()) {
                case 4: {
                    System.out.println("Done");
                    break;
                }
                case 8: {
                    try {
                        AmazonClientException exc = this.upload.waitForException();
                        System.err.println("Unable to upload file: " + exc.getMessage());
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

