/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CredentialsUtil {
    public static final Pattern PATTERN_ALNUM_40 = Pattern.compile("[\\p{Alnum}\\/\\+]{40}");
    public static final Pattern PATTERN_HEX_40 = Pattern.compile("[\\p{XDigit}\\/\\+]{40}", 2);
    public static final String MESSAGE = "/** REDACTED POSSIBLE AWS CREDENTIAL **/";

    public static String redact(String s) {
        boolean found;
        s = StringUtils.defaultString((String)s);
        StringBuilder stringBuilder = new StringBuilder(s);
        int lastPos = 0;
        do {
            Matcher matcher;
            if (!(found = (matcher = PATTERN_ALNUM_40.matcher(stringBuilder)).find(lastPos))) continue;
            CharSequence segment = stringBuilder.subSequence(matcher.start(), matcher.end());
            if (!PATTERN_HEX_40.matcher(segment).matches()) {
                stringBuilder.replace(matcher.start(), matcher.end(), MESSAGE);
                lastPos = matcher.start() + MESSAGE.length();
                continue;
            }
            lastPos = matcher.end();
        } while (found);
        return stringBuilder.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CredentialsUtil.redact("{\n  \"accessKey\": \"0THISISANACCESSKEYh3\",\n  \"secretKey\": \"abc123abdefasad32ldasdlj323lkjaR+secretk\",\n  \"applicationName\": \"multipackage-example\",\n  \"commitId\": \"73031a04846d8adaee6fc1eb1b4bb98af9878c3b\",\n  \"repoName\": \"ingenieux-image-blobs\",\n  \"targetPath\": \"s3://elasticbeanstalk-us-east-1-235368163414/apps/multipackage-example/versions/git-73031a04846d8adaee6fc1eb1b4bb98af9878c3b.zip\"\n}"));
    }
}

