/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws.util;

import br.com.ingenieux.mojo.aws.util.GlobUtil;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesResult;
import com.amazonaws.services.identitymanagement.model.Role;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RoleResolver {
    public static final Pattern PATTERN_IAM_ROLE = Pattern.compile("arn:aws:iam:[\\w\\-]*:(\\d+):(.*)");
    private final AmazonIdentityManagement iam;
    private final String accountId;
    Set<String> roles = new LinkedHashSet<String>();

    public RoleResolver(AmazonIdentityManagement iam) {
        this.iam = iam;
        this.roles = this.loadRoles();
        String firstRole = this.roles.iterator().next();
        Matcher m = PATTERN_IAM_ROLE.matcher(firstRole);
        if (!m.find()) {
            throw new IllegalStateException("Unable to find account id!");
        }
        this.accountId = m.group(1);
    }

    public String getAccountId() {
        return this.accountId;
    }

    private Set<String> loadRoles() {
        TreeSet<String> result = new TreeSet<String>();
        boolean done = false;
        String marker = null;
        do {
            ListRolesRequest listRolesRequest = new ListRolesRequest();
            listRolesRequest.setMarker(marker);
            ListRolesResult listRolesResult = this.iam.listRoles(listRolesRequest);
            for (Role r : listRolesResult.getRoles()) {
                result.add(r.getArn());
            }
            done = listRolesResult.isTruncated() == false;
            marker = listRolesResult.getMarker();
        } while (!done);
        return result;
    }

    public String lookupRoleGlob(String role) {
        if (GlobUtil.hasWildcards(role)) {
            Pattern p = GlobUtil.globify(role);
            for (String s : this.roles) {
                if (!p.matcher(s).matches()) continue;
                return s;
            }
            throw new IllegalStateException("Unable to lookup role '" + role + "': Not found");
        }
        return role;
    }
}

