/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.jbake;

import br.com.ingenieux.mojo.jbake.GenerateMojo;
import br.com.ingenieux.mojo.jbake.util.DirWatcher;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="watch", requiresDirectInvocation=true, requiresProject=false)
public class WatchMojo
extends GenerateMojo {
    @Override
    public void executeInternal() throws MojoExecutionException {
        this.reRender();
        Long lastProcessed = System.currentTimeMillis();
        this.getLog().info((CharSequence)("Now listening for changes on path " + this.inputDirectory.getPath()));
        this.initServer();
        DirWatcher dirWatcher = null;
        try {
            dirWatcher = new DirWatcher(this.inputDirectory);
            final AtomicBoolean done = new AtomicBoolean(false);
            final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        WatchMojo.this.getLog().info((CharSequence)"Running. Enter a blank line to finish. Anything else forces re-rendering.");
                        while (!StringUtils.isBlank((String)(line = reader.readLine()))) {
                            WatchMojo.this.reRender();
                        }
                    }
                    catch (Exception exc) {
                        WatchMojo.this.getLog().info((CharSequence)"Ooops", (Throwable)exc);
                    }
                    finally {
                        done.set(true);
                    }
                }
            }.start();
            dirWatcher.start();
            do {
                Long result;
                if (null == (result = dirWatcher.processEvents()) || result < lastProcessed) continue;
                this.getLog().info((CharSequence)"Refreshing");
                super.reRender();
                lastProcessed = System.currentTimeMillis();
            } while (!done.get());
        }
        catch (Exception exc) {
            this.getLog().info((CharSequence)"Oops", (Throwable)exc);
            throw new MojoExecutionException("Oops", exc);
        }
        finally {
            this.getLog().info((CharSequence)"Finishing");
            if (null != dirWatcher) {
                dirWatcher.stop();
            }
            this.stopServer();
        }
    }

    protected void stopServer() throws MojoExecutionException {
    }

    protected void initServer() throws MojoExecutionException {
    }
}

