/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.jbake;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="seed", requiresProject=true, requiresDirectInvocation=true)
public class SeedMojo
extends AbstractMojo {
    @Parameter(property="jbake.seedUrl", defaultValue="https://github.com/jbake-org/jbake-template-bootstrap/zipball/master/", required=true)
    protected String seedUrl;
    @Parameter(property="jbake.outputDirectory", defaultValue="${project.basedir}/src/main/jbake", required=true)
    protected File outputDirectory;
    @Parameter(property="jbake.force", defaultValue="false")
    protected Boolean force;

    public void execute() throws MojoExecutionException {
        if (this.outputDirectory.exists() && !this.force.booleanValue()) {
            throw new MojoExecutionException(String.format("The outputDirectory %s must *NOT* exist. Invoke with jbake.force as true to disregard", this.outputDirectory.getName()));
        }
        try {
            URL url = new URL(this.seedUrl);
            File tmpZipFile = File.createTempFile("jbake", ".zip");
            this.getLog().info((CharSequence)String.format("Downloading contents from %s into %s", this.seedUrl, tmpZipFile));
            FileOutputStream fos = new FileOutputStream(tmpZipFile);
            int length = IOUtils.copy((InputStream)url.openStream(), (OutputStream)fos);
            fos.close();
            this.getLog().info((CharSequence)String.format("%d bytes downloaded. Unpacking into %s", length, this.outputDirectory));
            this.unpackZip(tmpZipFile);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"Oops", (Throwable)e);
            throw new MojoExecutionException("Failure when running: ", e);
        }
    }

    private void unpackZip(File tmpZipFile) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(tmpZipFile));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            if (ze.isDirectory()) {
                ze = zis.getNextEntry();
                continue;
            }
            String fileName = this.stripLeadingPath(ze.getName());
            File newFile = new File(this.outputDirectory + File.separator + fileName);
            new File(newFile.getParent()).mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            IOUtils.copy((InputStream)zis, (OutputStream)fos);
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private String stripLeadingPath(String name) {
        LinkedList<String> elements = new LinkedList<String>(Arrays.asList(name.split("/")));
        elements.pop();
        return StringUtils.join(elements.iterator(), (char)'/');
    }
}

