/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.lambda;

import br.com.ingenieux.mojo.aws.util.GlobUtil;
import br.com.ingenieux.mojo.lambda.AbstractLambdaMojo;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.services.lambda.model.ListFunctionsRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-aliases")
public class ListAliasesMojo
extends AbstractLambdaMojo {
    public static final Pattern PATTERN_ALIAS = Pattern.compile("(?!^[0-9]+$)([a-zA-Z0-9-_]+)");
    public static final String PATTERN_ALIAS_ARN = "arn:aws:lambda:[a-z]{2}-[a-z]+-\\d{1}:\\d{12}:function:[a-zA-Z0-9-_]+:(\\$LATEST|[a-zA-Z0-9-_]+)";
    private AWSLambdaClient lambdaClient;
    @Parameter(property="lambda.function.includes", defaultValue="*")
    List<String> includes;
    List<Pattern> globIncludes;

    protected void configure() {
        super.configure();
        try {
            this.configureInternal();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private void configureInternal() throws MojoExecutionException {
        this.lambdaClient = (AWSLambdaClient)this.getService();
        this.globIncludes = Lists.transform(this.includes, GlobUtil::globify);
    }

    protected Object executeInternal() throws Exception {
        Map<String, Set<String>> aliasMap = this.fetchAliases();
        return aliasMap;
    }

    private Map<String, Set<String>> fetchAliases() {
        ListFunctionsResult listFunctionsResult;
        LinkedHashMap<String, Set<String>> aliases = new LinkedHashMap<String, Set<String>>();
        String marker = null;
        do {
            listFunctionsResult = this.lambdaClient.listFunctions(new ListFunctionsRequest().withMarker(marker));
            listFunctionsResult.getFunctions().stream().map(FunctionConfiguration::getFunctionName).filter(this::isItIncluded).forEach(func -> {
                Set aliasesSet = this.lambdaClient.listAliases(new ListAliasesRequest().withFunctionName(func)).getAliases().stream().map(x -> x.getAliasArn().replaceAll(PATTERN_ALIAS_ARN, "$1")).collect(Collectors.toSet());
                aliases.put((String)func, aliasesSet);
            });
        } while (StringUtils.isNotEmpty((String)(marker = listFunctionsResult.getNextMarker())));
        return aliases;
    }

    public boolean isItIncluded(String functionArn) {
        for (Pattern p : this.globIncludes) {
            if (!p.matcher(functionArn).matches()) continue;
            return true;
        }
        return false;
    }
}

