/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractTomcatContainer
extends AbstractJavaContainer {
    private File dir;
    private List confFileSets = new ArrayList();
    private File serverXml;
    private int port = 8080;

    public final void addConf(FileSet theConf) {
        theConf.createExclude().setName("**/server.xml");
        this.confFileSets.add(theConf);
    }

    public final File getDir() {
        return this.dir;
    }

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public final File getServerXml() {
        return this.serverXml;
    }

    public final void setServerXml(File theServerXml) {
        this.serverXml = theServerXml;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final int getPort() {
        return this.port;
    }

    public void init() {
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir + " is not a directory");
        }
        if (!this.getDeployableFile().getName().toLowerCase().endsWith(".war")) {
            throw new BuildException("Tomcat doesn't support the deployment of EAR files");
        }
    }

    protected final void copyConfFiles(File theConfDir) {
        if (this.getServerXml() != null) {
            FileUtils fileUtils = FileUtils.newFileUtils();
            try {
                fileUtils.copyFile(this.getServerXml(), new File(theConfDir, "server.xml"));
            }
            catch (IOException ioe) {
                throw new BuildException("Could not copy " + this.getServerXml() + " to directory " + theConfDir, (Throwable)ioe);
            }
        }
        if (!this.confFileSets.isEmpty()) {
            Copy copy = (Copy)this.createAntTask("copy");
            copy.setTodir(theConfDir);
            Iterator i = this.confFileSets.iterator();
            while (i.hasNext()) {
                copy.addFileset((FileSet)i.next());
            }
            copy.execute();
        }
    }
}

