/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cactus.integration.ant.deployment.ApplicationXmlTag;
import org.apache.cactus.integration.ant.deployment.ApplicationXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationXml {
    private final Document document;
    private final Element rootElement;

    public ApplicationXml(Document theDocument) {
        this.document = theDocument;
        this.rootElement = theDocument.getDocumentElement();
    }

    public final Document getDocument() {
        return this.document;
    }

    public final ApplicationXmlVersion getVersion() {
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            return ApplicationXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final Element getWebModule(String theWebUri) {
        if (theWebUri == null) {
            throw new NullPointerException();
        }
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || !theWebUri.equals(this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI))) continue;
            return webElement;
        }
        return null;
    }

    public final String getWebModuleContextRoot(String theWebUri) {
        Element webModuleElement = this.getWebModule(theWebUri);
        if (webModuleElement == null) {
            throw new IllegalArgumentException("Web Module '" + theWebUri + "' not defined");
        }
        return this.getNestedText(webModuleElement, ApplicationXmlTag.CONTEXT_ROOT);
    }

    public final Iterator getWebModuleUris() {
        ArrayList<String> webUris = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            String webUri;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || (webUri = this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI)) == null) continue;
            webUris.add(webUri);
        }
        return webUris.iterator();
    }

    public final Iterator getElements(ApplicationXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = this.rootElement.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    private Iterator getNestedElements(Element theParent, ApplicationXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = theParent.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    private String getNestedText(Element theElement, ApplicationXmlTag theTag) {
        Node nestedText;
        NodeList nestedElements = theElement.getElementsByTagName(theTag.getTagName());
        if (nestedElements.getLength() > 0 && (nestedText = nestedElements.item(0).getFirstChild()) != null) {
            return nestedText.getNodeValue();
        }
        return null;
    }
}

