/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.ant.deployment.JarArchive;
import org.apache.cactus.integration.ant.deployment.WebXml;
import org.apache.cactus.integration.ant.deployment.WebXmlIo;
import org.xml.sax.SAXException;

public class WarArchive
extends JarArchive {
    private WebXml webXml;

    public WarArchive(File theFile) throws IOException {
        super(theFile);
    }

    public WarArchive(InputStream theInputStream) throws IOException {
        super(theInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WebXml getWebXml() throws IOException, SAXException, ParserConfigurationException {
        if (this.webXml == null) {
            InputStream in = null;
            try {
                in = this.getResource("WEB-INF/web.xml");
                if (in != null) {
                    this.webXml = WebXmlIo.parseWebXml(in, null);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return this.webXml;
    }

    public final boolean containsClass(String theClassName) throws IOException {
        String resourceName = "WEB-INF/classes/" + theClassName.replace('.', '/') + ".class";
        if (this.getResource(resourceName) != null) {
            return true;
        }
        List jars = this.getResources("WEB-INF/lib/");
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            JarArchive jar = new JarArchive(this.getResource((String)i.next()));
            if (!jar.containsClass(theClassName)) continue;
            return true;
        }
        return false;
    }
}

