/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication;

import java.io.File;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.security.authentication.KerberosTestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class KerberosTestUtils {
    private static String keytabFile = new File(System.getProperty("test.dir", "target"), UUID.randomUUID().toString()).toString();

    public static String getRealm() {
        return "EXAMPLE.COM";
    }

    public static String getClientPrincipal() {
        return "client@EXAMPLE.COM";
    }

    public static String getServerPrincipal() {
        return "HTTP/localhost@EXAMPLE.COM";
    }

    public static String getKeytabFile() {
        return keytabFile;
    }

    public static <T> T doAs(String principal, Callable<T> callable) throws Exception {
        LoginContext loginContext = null;
        try {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(KerberosTestUtils.getClientPrincipal()));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, (Configuration)new KerberosConfiguration(principal));
            loginContext.login();
            subject = loginContext.getSubject();
            Object t = Subject.doAs(subject, new /* Unavailable Anonymous Inner Class!! */);
            return t;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }

    public static <T> T doAsClient(Callable<T> callable) throws Exception {
        return (T)KerberosTestUtils.doAs((String)KerberosTestUtils.getClientPrincipal(), callable);
    }

    public static <T> T doAsServer(Callable<T> callable) throws Exception {
        return (T)KerberosTestUtils.doAs((String)KerberosTestUtils.getServerPrincipal(), callable);
    }
}

