/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleUdpServer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;

public abstract class MountdBase {
    public static final Log LOG = LogFactory.getLog(MountdBase.class);
    private final RpcProgram rpcProgram;
    private int udpBoundPort;
    private int tcpBoundPort;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    public MountdBase(RpcProgram program) throws IOException {
        this.rpcProgram = program;
    }

    private void startUDPServer() {
        SimpleUdpServer udpServer = new SimpleUdpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        try {
            udpServer.run();
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Failed to start the UDP server.", e);
            if (udpServer.getBoundPort() > 0) {
                this.rpcProgram.unregister(17, udpServer.getBoundPort());
            }
            udpServer.shutdown();
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.udpBoundPort = udpServer.getBoundPort();
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        try {
            tcpServer.run();
        }
        catch (Throwable e) {
            LOG.fatal((Object)"Failed to start the TCP server.", e);
            if (tcpServer.getBoundPort() > 0) {
                this.rpcProgram.unregister(6, tcpServer.getBoundPort());
            }
            tcpServer.shutdown();
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.tcpBoundPort = tcpServer.getBoundPort();
    }

    public void start(boolean register) {
        this.startUDPServer();
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new Unregister(), 10);
            try {
                this.rpcProgram.register(17, this.udpBoundPort);
                this.rpcProgram.register(6, this.tcpBoundPort);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Failed to register the MOUNT service.", e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    private class Unregister
    implements Runnable {
        private Unregister() {
        }

        @Override
        public synchronized void run() {
            MountdBase.this.rpcProgram.unregister(17, MountdBase.this.udpBoundPort);
            MountdBase.this.rpcProgram.unregister(6, MountdBase.this.tcpBoundPort);
        }
    }
}

