/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.clusterchooser;

import cn.com.vastbase.Driver;
import cn.com.vastbase.PGProperty;
import cn.com.vastbase.QueryCNListUtils;
import cn.com.vastbase.clusterchooser.ClusterStatus;
import cn.com.vastbase.hostchooser.MultiHostChooser;
import cn.com.vastbase.log.Log;
import cn.com.vastbase.log.Logger;
import cn.com.vastbase.util.ClusterSpec;
import cn.com.vastbase.util.HostSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalClusterStatusTracker {
    private static final Map<String, ClusterSpecStatus> clusterStatusMap = new HashMap<String, ClusterSpecStatus>();
    private static final Map<String, Boolean> firstConnectionMap = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, String> masterClusterList = new HashMap<String, String>();
    private static Log LOGGER = Logger.getLogger(GlobalClusterStatusTracker.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportClusterStatus(ClusterSpec clusterSpec, ClusterStatus clusterStatus) {
        String key = GlobalClusterStatusTracker.keyFromClusterSpec(clusterSpec);
        Map<String, ClusterSpecStatus> map = clusterStatusMap;
        synchronized (map) {
            ClusterSpecStatus clusterSpecStatus = clusterStatusMap.get(key);
            if (clusterSpecStatus == null) {
                clusterSpecStatus = new ClusterSpecStatus(clusterSpec);
                clusterStatusMap.put(key, clusterSpecStatus);
            }
            clusterSpecStatus.status = clusterStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportMasterCluster(Properties props, ClusterSpec clusterSpec) {
        String urlKey = QueryCNListUtils.keyFromURL(props);
        String masterClusterKey = GlobalClusterStatusTracker.keyFromClusterSpec(clusterSpec);
        Map<String, String> map = masterClusterList;
        synchronized (map) {
            masterClusterList.put(urlKey, masterClusterKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterStatus getClusterStatus(HostSpec[] hostSpecs) {
        Object[] cloneHostSpecs = (HostSpec[])hostSpecs.clone();
        Arrays.sort(cloneHostSpecs);
        String clusterKey = Arrays.toString(cloneHostSpecs);
        Map<String, ClusterSpecStatus> map = clusterStatusMap;
        synchronized (map) {
            ClusterSpecStatus clusterSpecStatus = clusterStatusMap.get(clusterKey);
            if (clusterSpecStatus != null && clusterSpecStatus.status != null) {
                return clusterSpecStatus.status;
            }
        }
        return ClusterStatus.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProperties(Properties props) {
        boolean block;
        String key = QueryCNListUtils.keyFromURL(props);
        Map<String, Boolean> map = firstConnectionMap;
        synchronized (map) {
            block = firstConnectionMap.get(key) == null ? false : firstConnectionMap.get(key);
            firstConnectionMap.put(key, true);
        }
        String masterClusterkey = GlobalClusterStatusTracker.getMasterClusterkey(key, block);
        if ("".equals(masterClusterkey)) {
            return;
        }
        LOGGER.info("[PRIORITYSERVERS] Find the main cluster in dual clusters. | DualCluster: " + key + " | MasterCluster:" + masterClusterkey);
        props.setProperty("MASTERCLUSTER", masterClusterkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMasterClusterkey(String key, boolean block) {
        int intervalWaitHasRefreshedCNList = 10;
        int timesWaitHasRefreshedCNList = 200;
        for (int i = 0; i <= timesWaitHasRefreshedCNList; ++i) {
            Map<String, String> map = masterClusterList;
            synchronized (map) {
                String masterClusterKey = masterClusterList.get(key);
                if (masterClusterKey != null && !"".equals(masterClusterKey)) {
                    return masterClusterKey;
                }
            }
            if (!block) break;
            try {
                Thread.sleep(intervalWaitHasRefreshedCNList);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.info("[PRIORITYSERVERS] InterruptedException. This caused by: \"Thread.sleep\", waiting for refreshing master cluster from connection.");
            }
        }
        if (block) {
            LOGGER.info("[PRIORITYSERVERS] Blocking time extends 2 seconds need to pay attention.");
        }
        return "";
    }

    public static boolean isVaildPriorityServers(Properties props) {
        String priorityServers = PGProperty.PRIORITY_SERVERS.get(props);
        try {
            int priorityServersNumber = Integer.parseInt(priorityServers);
            int lengthPGPORTURL = props.getProperty("PGPORTURL").split(",").length;
            if (lengthPGPORTURL <= priorityServersNumber || priorityServersNumber <= 0) {
                LOGGER.warn("When configuring priority servers, The number of priority nodes should be less than the number of nodes on the URL and greater than 0.");
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("When configuring priority servers, \"priorityServers\" should be number.");
            return false;
        }
        return true;
    }

    public static Iterator<ClusterSpec> getClusterFromHostSpecs(HostSpec[] hostSpecs, Properties info) {
        ClusterSpec[] clusterSpecs;
        String priorityServers = PGProperty.PRIORITY_SERVERS.get(info);
        if (priorityServers != null) {
            clusterSpecs = new ClusterSpec[2];
            Integer index = Integer.valueOf(priorityServers);
            String masterCluster = info.getProperty("MASTERCLUSTER");
            if (MultiHostChooser.isUsingAutoLoadBalance(info) && masterCluster != null) {
                clusterSpecs[0] = new ClusterSpec(hostSpecs);
                HostSpec[] urlHostSpecs = Driver.getURLHostSpecs(info);
                HostSpec[] slaveHostSpecs = Arrays.copyOfRange(urlHostSpecs, (int)index, urlHostSpecs.length);
                clusterSpecs[1] = !masterCluster.contains(slaveHostSpecs[0].toString()) ? new ClusterSpec(slaveHostSpecs) : new ClusterSpec(Arrays.copyOfRange(urlHostSpecs, 0, (int)index));
            } else {
                HostSpec[] masterHostSpecs = Arrays.copyOfRange(hostSpecs, 0, (int)index);
                HostSpec[] slaveHostSpecs = Arrays.copyOfRange(hostSpecs, (int)index, hostSpecs.length);
                if (masterCluster != null && masterCluster.contains(slaveHostSpecs[0].toString())) {
                    clusterSpecs[0] = new ClusterSpec(slaveHostSpecs);
                    clusterSpecs[1] = new ClusterSpec(masterHostSpecs);
                } else {
                    clusterSpecs[0] = new ClusterSpec(masterHostSpecs);
                    clusterSpecs[1] = new ClusterSpec(slaveHostSpecs);
                }
            }
        } else {
            clusterSpecs = new ClusterSpec[]{new ClusterSpec(hostSpecs)};
        }
        return new ArrayList<ClusterSpec>(Arrays.asList(clusterSpecs)).iterator();
    }

    public static String keyFromClusterSpec(ClusterSpec clusterSpec) {
        Object[] hostSpecs = clusterSpec.getHostSpecs();
        Arrays.sort(hostSpecs);
        return Arrays.toString(hostSpecs);
    }

    static class ClusterSpecStatus {
        final ClusterSpec cluster;
        ClusterStatus status;

        ClusterSpecStatus(ClusterSpec cluster) {
            this.cluster = cluster;
        }

        public String toString() {
            return this.cluster.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

