/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.jdbc;

import cn.com.vastbase.Driver;
import cn.com.vastbase.core.BaseStatement;
import cn.com.vastbase.core.ParameterList;
import cn.com.vastbase.core.Query;
import cn.com.vastbase.jdbc.BatchResultHandler;
import cn.com.vastbase.jdbc.CallableBatchResultHandler;
import cn.com.vastbase.jdbc.PgConnection;
import cn.com.vastbase.jdbc.PgPreparedStatement;
import cn.com.vastbase.util.GT;
import cn.com.vastbase.util.PSQLException;
import cn.com.vastbase.util.PSQLState;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected ResultSet resultSet;
    protected Integer[] outparamList;
    private int lastIndex = 0;
    private String compatibilityMode;
    private boolean isACompatibilityFunction;
    private boolean enableOutparamOveride;
    private ConcurrentHashMap<Integer, List<Object[]>> compositeTypeStructMap = new ConcurrentHashMap();
    private boolean isContainCompositeType = false;
    private PreparedStatement getCompositeTypeStatementSimple;
    private ConcurrentHashMap<String, List<Object[]>> compositeTypeMap = new ConcurrentHashMap();
    private static HashMap<Integer, Integer> sqlTypeToOid = new HashMap();

    PgCallableStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, connection.borrowCallableQuery(sql), rsType, rsConcurrency, rsHoldability);
        this.isFunction = this.preparedQuery.isFunction;
        this.isACompatibilityFunction = this.preparedQuery.isACompatibilityFunction;
        this.compatibilityMode = connection.getQueryExecutor().getCompatibilityMode();
        this.enableOutparamOveride = connection.getQueryExecutor().getEnableOutparamOveride();
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        ResultSet rs;
        boolean hasResultSet = super.executeWithFlags(flags);
        if (!this.isFunction || !this.returnTypeSet) {
            if (!this.returnTypeSet && this.result != null) {
                this.result.popLast();
            }
            return hasResultSet;
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        PgCallableStatement pgCallableStatement = this;
        synchronized (pgCallableStatement) {
            this.checkClosed();
            rs = this.result.getLast().getResultSet();
        }
        if (!rs.next()) {
            throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
        }
        int cols = rs.getMetaData().getColumnCount();
        int outParameterCount = this.preparedParameters.getOutParameterCount();
        this.lastIndex = 0;
        this.outparamList = new Integer[this.preparedParameters.getParameterCount() + 1];
        int i = 0;
        int j = 0;
        while (i < cols) {
            while (j < this.functionReturnType.length && this.functionReturnType[j] == 0) {
                ++j;
            }
            this.outparamList[j] = i;
            ++i;
            ++j;
        }
        this.resultSet = rs;
        PgCallableStatement pgCallableStatement2 = this;
        synchronized (pgCallableStatement2) {
            this.result.popLast();
        }
        return false;
    }

    private boolean isContainSpecialChar(String str) {
        return str.contains(Character.toString('\"')) || str.contains(Character.toString('\\')) || str.contains(Character.toString('(')) || str.contains(Character.toString(')')) || str.contains(Character.toString(',')) || str.contains(Character.toString(' '));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = -6;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
            case 16: {
                sqlType = -7;
                break;
            }
            case -15: {
                sqlType = 1;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                sqlType = 93;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        this.preparedParameters.registerOutParameter(parameterIndex, sqlType);
        if (this.isACompatibilityAndOverLoad()) {
            Integer oid = sqlTypeToOid.get(sqlType) == null ? Integer.valueOf(0) : sqlTypeToOid.get(sqlType);
            this.preparedParameters.bindRegisterOutParameter(parameterIndex, oid, this.isACompatibilityFunction);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.resultSet.getObject(this.getOutIndex(this.lastIndex)) == null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getString(this.getOutIndex(parameterIndex));
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        this.checkClosed();
        return (ResultSet)this.resultSet.getObject(this.getOutIndex(parameterIndex));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getBoolean(this.getOutIndex(parameterIndex));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getByte(this.getOutIndex(parameterIndex));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getShort(this.getOutIndex(parameterIndex));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getInt(this.getOutIndex(parameterIndex));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getLong(this.getOutIndex(parameterIndex));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getFloat(this.getOutIndex(parameterIndex));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getDouble(this.getOutIndex(parameterIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        return this.resultSet.getBigDecimal(this.getOutIndex(parameterIndex));
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getBytes(this.getOutIndex(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getDate(this.getOutIndex(parameterIndex));
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getTime(this.getOutIndex(parameterIndex));
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getTimestamp(this.getOutIndex(parameterIndex));
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getObject(this.getOutIndex(parameterIndex));
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.resultSet == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    private int getOutIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        this.lastIndex = parameterIndex;
        return this.outparamList[parameterIndex - 1] + 1;
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new CallableBatchResultHandler(this, queries, parameterLists);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        return this.resultSet.getArray(this.getOutIndex(i));
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getBigDecimal(this.getOutIndex(parameterIndex));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkClosed();
        return this.resultSet.getBlob(this.getOutIndex(i));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkClosed();
        return this.resultSet.getClob(this.getOutIndex(i));
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.resultSet.getDate(this.getOutIndex(i), cal);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.resultSet.getTime(this.getOutIndex(i), cal);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        return this.resultSet.getTimestamp(this.getOutIndex(i), cal);
    }

    private PreparedStatement getCompositeTypeStatement(String typeName) throws SQLException {
        if (this.getCompositeTypeStatementSimple == null) {
            String sql = "SELECT attname, atttypid FROM pg_attribute a JOIN pg_class c ON a.attrelid = c.oid WHERE c.oid IN ( SELECT a.typrelid FROM ( SELECT pn.nspname || '.' || pt.typname AS typname, pt.typrelid FROM pg_namespace pn LEFT JOIN pg_type pt ON pn.oid = pt.typnamespace) a WHERE a.typname = ? ) AND a.attnum > 0 ORDER BY a.attnum";
            this.getCompositeTypeStatementSimple = this.connection.prepareStatement(sql);
        }
        this.getCompositeTypeStatementSimple.setString(1, typeName);
        return this.getCompositeTypeStatementSimple;
    }

    private Object[] getcompositeTypeStruct(int index) {
        List<Object[]> struct = this.compositeTypeStructMap.get(index);
        Object[] res = new Object[struct.size()];
        for (int i = 0; i < struct.size(); ++i) {
            res[i] = struct.get(i)[0];
        }
        return res;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (sqlType == 2002) {
            this.checkClosed();
            if (!this.isFunction) {
                throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
            }
            this.checkIndex(parameterIndex, false);
            if (this.compositeTypeMap.containsKey(typeName)) {
                this.compositeTypeStructMap.put(parameterIndex, this.compositeTypeMap.get(typeName));
            } else {
                PreparedStatement compositeTypeStatement = this.getCompositeTypeStatement(typeName);
                if (!((BaseStatement)((Object)compositeTypeStatement)).executeWithFlags(16)) {
                    throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
                }
                ResultSet rs = compositeTypeStatement.getResultSet();
                ArrayList<Object[]> compositeType = new ArrayList<Object[]>();
                while (rs.next()) {
                    compositeType.add(new Object[]{rs.getString(1), rs.getInt(2)});
                }
                rs.close();
                this.compositeTypeStructMap.put(parameterIndex, compositeType);
            }
            this.preparedParameters.registerOutParameter(parameterIndex, 1111);
            if (this.isACompatibilityAndOverLoad()) {
                this.preparedParameters.bindRegisterOutParameter(parameterIndex, this.connection.getTypeInfo().getPGType(typeName), this.isACompatibilityFunction);
            }
        } else {
            throw Driver.notImplemented(this.getClass(), "registerOutParameter(int,int,String)");
        }
        this.functionReturnType[parameterIndex - 1] = 1111;
        this.testReturn[parameterIndex - 1] = 1111;
        this.returnTypeSet = true;
        this.isContainCompositeType = true;
    }

    private boolean isACompatibilityAndOverLoad() {
        return this.enableOutparamOveride && ("A".equalsIgnoreCase(this.compatibilityMode) || "ORA".equalsIgnoreCase(this.compatibilityMode));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getRowId(this.getOutIndex(parameterIndex));
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        return this.resultSet.getSQLXML(this.getOutIndex(parameterIndex));
    }

    @Override
    public SQLXML getSQLXML(String parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(this.getOutIndex(parameterIndex));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == ResultSet.class) {
            return type.cast(this.getObject(this.getOutIndex(parameterIndex)));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.registerOutParameter(index, sqlType);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.registerOutParameter(index, sqlType, scale);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        List<Integer> parameterIndexList = this.preparedQuery.query.getBindParameterIndex(parameterName);
        for (int index : parameterIndexList) {
            this.registerOutParameter(index, sqlType, typeName);
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getString(String)");
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBoolean(String)");
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getByte(String)");
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getShort(String)");
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getInt(String)");
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLong(String)");
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getFloat(String)");
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDouble(String)");
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBytes(String)");
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String)");
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String)");
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String)");
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBigDecimal(String)");
    }

    public Object getObjectImpl(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String,Map)");
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(String)");
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(String)");
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(String)");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getArray(String)");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getDate(String,Calendar)");
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTime(String,Calendar)");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getTimestamp(String,Calendar)");
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    static {
        sqlTypeToOid.put(2009, 142);
        sqlTypeToOid.put(4, 23);
        sqlTypeToOid.put(-6, 5545);
        sqlTypeToOid.put(5, 21);
        sqlTypeToOid.put(-5, 20);
        sqlTypeToOid.put(7, 700);
        sqlTypeToOid.put(12, 1043);
        sqlTypeToOid.put(8, 701);
        sqlTypeToOid.put(6, 701);
        sqlTypeToOid.put(3, 1700);
        sqlTypeToOid.put(2, 1700);
        sqlTypeToOid.put(1, 1042);
        sqlTypeToOid.put(91, 1082);
        sqlTypeToOid.put(92, 1083);
        sqlTypeToOid.put(93, 1114);
        sqlTypeToOid.put(16, 16);
        sqlTypeToOid.put(-7, 16);
        sqlTypeToOid.put(-2, 17);
        sqlTypeToOid.put(-3, 17);
        sqlTypeToOid.put(-4, 17);
        sqlTypeToOid.put(2004, 88);
        sqlTypeToOid.put(2005, 90);
        sqlTypeToOid.put(2003, 1015);
        sqlTypeToOid.put(2001, 0);
        sqlTypeToOid.put(2002, 0);
        sqlTypeToOid.put(0, 0);
        sqlTypeToOid.put(1111, 0);
        sqlTypeToOid.put(-1, 1043);
        sqlTypeToOid.put(-9, 1043);
        sqlTypeToOid.put(-16, 1043);
        sqlTypeToOid.put(-15, 18);
    }
}

