/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.replication;

import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.replication.PGReplicationConnection;
import cn.com.vastbase.replication.fluent.ChainedCreateReplicationSlotBuilder;
import cn.com.vastbase.replication.fluent.ChainedStreamBuilder;
import cn.com.vastbase.replication.fluent.ReplicationCreateSlotBuilder;
import cn.com.vastbase.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

