/*
 * Decompiled with CFR 0.152.
 */
package cn.com.vastbase.replication.fluent;

import cn.com.vastbase.core.BaseConnection;
import cn.com.vastbase.core.ReplicationProtocol;
import cn.com.vastbase.replication.PGReplicationStream;
import cn.com.vastbase.replication.fluent.ChainedStreamBuilder;
import cn.com.vastbase.replication.fluent.logical.ChainedLogicalStreamBuilder;
import cn.com.vastbase.replication.fluent.logical.LogicalReplicationOptions;
import cn.com.vastbase.replication.fluent.logical.LogicalStreamBuilder;
import cn.com.vastbase.replication.fluent.logical.StartLogicalReplicationCallback;
import cn.com.vastbase.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import cn.com.vastbase.replication.fluent.physical.PhysicalReplicationOptions;
import cn.com.vastbase.replication.fluent.physical.PhysicalStreamBuilder;
import cn.com.vastbase.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

