/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.cache;

import cn.idev.excel.cache.ReadCache;
import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.util.FileUtils;
import cn.idev.excel.util.ListUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ehcache
implements ReadCache {
    private static final Logger log = LoggerFactory.getLogger(Ehcache.class);
    public static final int BATCH_COUNT = 100;
    private int activeIndex = 0;
    public static final int DEBUG_CACHE_MISS_SIZE = 1000;
    public static final int DEBUG_WRITE_SIZE = 1000000;
    private ArrayList<String> dataList = ListUtils.newArrayListWithExpectedSize(100);
    private static final CacheManager FILE_CACHE_MANAGER;
    private static final CacheConfiguration<Integer, ArrayList> FILE_CACHE_CONFIGURATION;
    private static final CacheManager ACTIVE_CACHE_MANAGER;
    private static final File CACHE_PATH_FILE;
    private final CacheConfiguration<Integer, ArrayList> activeCacheConfiguration;
    private Cache<Integer, ArrayList> fileCache;
    private Cache<Integer, ArrayList> activeCache;
    private String cacheAlias;
    private int cacheMiss = 0;

    @Deprecated
    public Ehcache(Integer maxCacheActivateSize) {
        this(maxCacheActivateSize, null);
    }

    public Ehcache(Integer maxCacheActivateSize, Integer maxCacheActivateBatchCount) {
        this.activeCacheConfiguration = maxCacheActivateSize != null ? CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, ArrayList.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)maxCacheActivateSize.intValue(), (ResourceUnit)MemoryUnit.MB)).build() : CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, ArrayList.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)maxCacheActivateBatchCount.intValue(), (ResourceUnit)EntryUnit.ENTRIES)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void init(AnalysisContext analysisContext) {
        this.cacheAlias = UUID.randomUUID().toString();
        try {
            this.fileCache = FILE_CACHE_MANAGER.createCache(this.cacheAlias, FILE_CACHE_CONFIGURATION);
        }
        catch (IllegalStateException e) {
            if (CACHE_PATH_FILE.exists()) {
                throw e;
            }
            Class<Ehcache> clazz = Ehcache.class;
            // MONITORENTER : cn.idev.excel.cache.Ehcache.class
            if (!CACHE_PATH_FILE.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("cache file dir is not exist retry create");
                }
                FileUtils.createDirectory(CACHE_PATH_FILE);
            }
            // MONITOREXIT : clazz
            this.fileCache = FILE_CACHE_MANAGER.createCache(this.cacheAlias, FILE_CACHE_CONFIGURATION);
        }
        this.activeCache = ACTIVE_CACHE_MANAGER.createCache(this.cacheAlias, this.activeCacheConfiguration);
    }

    @Override
    public void put(String value) {
        int alreadyPut;
        this.dataList.add(value);
        if (this.dataList.size() >= 100) {
            this.fileCache.put((Object)this.activeIndex, this.dataList);
            ++this.activeIndex;
            this.dataList = ListUtils.newArrayListWithExpectedSize(100);
        }
        if (log.isDebugEnabled() && (alreadyPut = this.activeIndex * 100 + this.dataList.size()) % 1000000 == 0) {
            log.debug("Already put :{}", (Object)alreadyPut);
        }
    }

    @Override
    public String get(Integer key) {
        if (key == null || key < 0) {
            return null;
        }
        int route = key / 100;
        ArrayList dataList = (ArrayList)this.activeCache.get((Object)route);
        if (dataList == null) {
            dataList = (ArrayList)this.fileCache.get((Object)route);
            this.activeCache.put((Object)route, (Object)dataList);
            if (log.isDebugEnabled() && this.cacheMiss++ % 1000 == 0) {
                log.debug("Cache misses count:{}", (Object)this.cacheMiss);
            }
        }
        return (String)dataList.get(key % 100);
    }

    @Override
    public void putFinished() {
        if (CollectionUtils.isEmpty(this.dataList)) {
            return;
        }
        this.fileCache.put((Object)this.activeIndex, this.dataList);
    }

    @Override
    public void destroy() {
        FILE_CACHE_MANAGER.removeCache(this.cacheAlias);
        ACTIVE_CACHE_MANAGER.removeCache(this.cacheAlias);
    }

    static {
        CACHE_PATH_FILE = FileUtils.createCacheTmpFile();
        FILE_CACHE_MANAGER = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)CACHE_PATH_FILE)).build(true);
        ACTIVE_CACHE_MANAGER = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        FILE_CACHE_CONFIGURATION = CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, ArrayList.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(20L, MemoryUnit.GB)).build();
    }
}

