/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor;

import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;

public class Excel2PdfUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TRUE_STRING = "TRUE";
    private static final String FALSE_STRING = "FALSE";
    private static final String EMPTY_STRING = "";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT, LocaleUtil.getUserLocale()));

    public static String getValue(Cell cell) {
        if (cell == null) {
            return EMPTY_STRING;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BOOLEAN: {
                return cell.getBooleanCellValue() ? TRUE_STRING : FALSE_STRING;
            }
            case NUMERIC: {
                return Excel2PdfUtils.getNumericCellValue(cell);
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return EMPTY_STRING;
    }

    private static String getNumericCellValue(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            return DATE_FORMATTER.get().format(cell.getDateCellValue());
        }
        return String.valueOf(cell.getNumericCellValue());
    }
}

