/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.connection.HttpResponseHandler;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.ResponseWrapper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.CountDownLatch;

public class NettyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private SslContext _sslCtx;
    private NettyHttpClient.BaseCallback _callback;
    private CountDownLatch _latch;
    private HttpResponseHandler _handler;

    public NettyClientInitializer(SslContext sslContext, NettyHttpClient.BaseCallback callback, CountDownLatch latch) {
        this._sslCtx = sslContext;
        this._callback = callback;
        this._latch = latch;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        this._handler = new HttpResponseHandler(this._callback, this._latch);
        socketChannel.pipeline().addLast(new ChannelHandler[]{this._sslCtx.newHandler(socketChannel.alloc()), new HttpClientCodec(), this._handler});
    }

    public void resetLatch(CountDownLatch latch) {
        this._handler.resetLatch(latch);
    }

    public ResponseWrapper getResponse() {
        return this._handler.getResponse();
    }
}

