/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.DomainCreatePermission;
import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.DomainPermissions;
import com.acciente.oacc.SysPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DomainCreatePermissions {
    private static final SysPermission SYSPERMISSION_CREATE = new SysPermission(-300, "*CREATE");
    public static final String CREATE = SYSPERMISSION_CREATE.getPermissionName();
    private static final Map<String, SysPermission> sysPermissionsByName = new HashMap<String, SysPermission>();
    private static final Map<Long, String> sysPermissionNamesById;
    private static final List<String> sysPermissionNames;
    private static final ConcurrentMap<String, DomainCreatePermission> grantableCreatePermissionsByName;
    private static final ConcurrentMap<String, DomainCreatePermission> ungrantableCreatePermissionsByName;
    private static final ConcurrentMap<DomainPermission, DomainCreatePermission> grantableCreatePermissionsByPostCreatePermission;
    private static final ConcurrentMap<DomainPermission, DomainCreatePermission> ungrantableCreatePermissionsByPostCreatePermission;

    public static List<String> getSysPermissionNames() {
        return sysPermissionNames;
    }

    public static String getSysPermissionName(long systemPermissionId) {
        String sysPermissionName = sysPermissionNamesById.get(systemPermissionId);
        if (sysPermissionName == null) {
            throw new IllegalArgumentException("Invalid system permission ID: " + systemPermissionId);
        }
        return sysPermissionName;
    }

    public static DomainCreatePermission getInstanceWithGrantOption(String sysPermissionName) {
        DomainCreatePermission cachedInstance;
        DomainCreatePermission domainCreatePermission = (DomainCreatePermission)grantableCreatePermissionsByName.get(sysPermissionName = DomainCreatePermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (domainCreatePermission == null && (cachedInstance = grantableCreatePermissionsByName.putIfAbsent(sysPermissionName, domainCreatePermission = new DomainCreatePermissionImpl(sysPermissionName, true))) != null) {
            domainCreatePermission = cachedInstance;
        }
        return domainCreatePermission;
    }

    public static DomainCreatePermission getInstance(String sysPermissionName) {
        DomainCreatePermission cachedInstance;
        DomainCreatePermission domainCreatePermission = (DomainCreatePermission)ungrantableCreatePermissionsByName.get(sysPermissionName = DomainCreatePermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (domainCreatePermission == null && (cachedInstance = ungrantableCreatePermissionsByName.putIfAbsent(sysPermissionName, domainCreatePermission = new DomainCreatePermissionImpl(sysPermissionName, false))) != null) {
            domainCreatePermission = cachedInstance;
        }
        return domainCreatePermission;
    }

    public static DomainCreatePermission getInstance(DomainPermission postCreateDomainPermission) {
        DomainCreatePermission cachedInstance;
        DomainCreatePermissions.assertPostCreatePermissionSpecified(postCreateDomainPermission);
        postCreateDomainPermission = DomainPermissions.getInstance(postCreateDomainPermission);
        DomainCreatePermission domainCreatePermission = (DomainCreatePermission)ungrantableCreatePermissionsByPostCreatePermission.get(postCreateDomainPermission);
        if (domainCreatePermission == null && (cachedInstance = ungrantableCreatePermissionsByPostCreatePermission.putIfAbsent(postCreateDomainPermission, domainCreatePermission = new DomainCreatePermissionImpl((DomainPermissions.DomainPermissionImpl)postCreateDomainPermission, false))) != null) {
            domainCreatePermission = cachedInstance;
        }
        return domainCreatePermission;
    }

    public static DomainCreatePermission getInstanceWithGrantOption(DomainPermission postCreateDomainPermission) {
        DomainCreatePermission cachedInstance;
        DomainCreatePermissions.assertPostCreatePermissionSpecified(postCreateDomainPermission);
        postCreateDomainPermission = DomainPermissions.getInstance(postCreateDomainPermission);
        DomainCreatePermission domainCreatePermission = (DomainCreatePermission)grantableCreatePermissionsByPostCreatePermission.get(postCreateDomainPermission);
        if (domainCreatePermission == null && (cachedInstance = grantableCreatePermissionsByPostCreatePermission.putIfAbsent(postCreateDomainPermission, domainCreatePermission = new DomainCreatePermissionImpl((DomainPermissions.DomainPermissionImpl)postCreateDomainPermission, true))) != null) {
            domainCreatePermission = cachedInstance;
        }
        return domainCreatePermission;
    }

    public static DomainCreatePermission getInstance(DomainCreatePermission domainCreatePermission) {
        DomainCreatePermission verifiedPermission;
        if (domainCreatePermission instanceof DomainCreatePermissionImpl) {
            return domainCreatePermission;
        }
        if (domainCreatePermission.isSystemPermission()) {
            verifiedPermission = domainCreatePermission.isWithGrantOption() ? DomainCreatePermissions.getInstanceWithGrantOption(domainCreatePermission.getPermissionName()) : DomainCreatePermissions.getInstance(domainCreatePermission.getPermissionName());
            if (verifiedPermission.getSystemPermissionId() != domainCreatePermission.getSystemPermissionId()) {
                throw new IllegalArgumentException("Invalid system permission id for domain create permission: " + domainCreatePermission);
            }
        } else {
            verifiedPermission = domainCreatePermission.isWithGrantOption() ? DomainCreatePermissions.getInstanceWithGrantOption(DomainPermissions.getInstance(domainCreatePermission.getPostCreateDomainPermission())) : DomainCreatePermissions.getInstance(DomainPermissions.getInstance(domainCreatePermission.getPostCreateDomainPermission()));
        }
        return verifiedPermission;
    }

    private static String getCanonicalSysPermissionName(String permissionName) {
        if (permissionName == null) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        if ((permissionName = permissionName.trim()).isEmpty()) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        return permissionName;
    }

    private static void assertPostCreatePermissionSpecified(DomainPermission postCreateDomainPermission) {
        if (postCreateDomainPermission == null) {
            throw new IllegalArgumentException("A post create domain permission is required");
        }
    }

    static {
        sysPermissionsByName.put(CREATE, SYSPERMISSION_CREATE);
        sysPermissionNamesById = new HashMap<Long, String>(sysPermissionsByName.size());
        for (SysPermission sysPermission : sysPermissionsByName.values()) {
            sysPermissionNamesById.put(sysPermission.getSystemPermissionId(), sysPermission.getPermissionName());
        }
        sysPermissionNames = Collections.unmodifiableList(new ArrayList<String>(sysPermissionNamesById.values()));
        grantableCreatePermissionsByName = new ConcurrentHashMap<String, DomainCreatePermission>(sysPermissionsByName.size());
        ungrantableCreatePermissionsByName = new ConcurrentHashMap<String, DomainCreatePermission>(sysPermissionsByName.size());
        grantableCreatePermissionsByPostCreatePermission = new ConcurrentHashMap<DomainPermission, DomainCreatePermission>();
        ungrantableCreatePermissionsByPostCreatePermission = new ConcurrentHashMap<DomainPermission, DomainCreatePermission>();
    }

    static class DomainCreatePermissionImpl
    implements DomainCreatePermission,
    Serializable {
        private static final long serialVersionUID = 2L;
        private final long systemPermissionId;
        private final String sysPermissionName;
        private final DomainPermissions.DomainPermissionImpl postCreateDomainPermission;
        private final boolean withGrantOption;

        private DomainCreatePermissionImpl(String sysPermissionName, boolean withGrantOption) {
            SysPermission sysPermission = DomainCreatePermissionImpl.getSysPermission(sysPermissionName);
            this.systemPermissionId = sysPermission.getSystemPermissionId();
            this.sysPermissionName = sysPermission.getPermissionName();
            this.postCreateDomainPermission = null;
            this.withGrantOption = withGrantOption;
        }

        private DomainCreatePermissionImpl(DomainPermissions.DomainPermissionImpl postCreateDomainPermission, boolean withGrantOption) {
            this.systemPermissionId = 0L;
            this.sysPermissionName = null;
            this.postCreateDomainPermission = postCreateDomainPermission;
            this.withGrantOption = withGrantOption;
        }

        @Override
        public boolean isSystemPermission() {
            return this.systemPermissionId != 0L;
        }

        @Override
        public String getPermissionName() {
            if (!this.isSystemPermission()) {
                throw new IllegalStateException("No system permission name may be retrieved for non-system domain create permission: " + this + ", please check your code");
            }
            return this.sysPermissionName;
        }

        @Override
        public long getSystemPermissionId() {
            if (!this.isSystemPermission()) {
                throw new IllegalStateException("No system permission ID may be retrieved for non-system domain create permission: " + this + ", please check your code");
            }
            return this.systemPermissionId;
        }

        @Override
        public DomainPermission getPostCreateDomainPermission() {
            if (this.isSystemPermission()) {
                throw new IllegalStateException("No post create domain permission may be retrieved for system domain create permission: " + this + ", please check your code");
            }
            return this.postCreateDomainPermission;
        }

        @Override
        public boolean isWithGrantOption() {
            return this.withGrantOption;
        }

        @Override
        public boolean isGrantableFrom(DomainCreatePermission other) {
            if (other == null) {
                return false;
            }
            if (!other.isWithGrantOption()) {
                return false;
            }
            if (this.isSystemPermission() != other.isSystemPermission()) {
                return false;
            }
            if (this.isSystemPermission()) {
                return this.systemPermissionId == other.getSystemPermissionId();
            }
            if (this.postCreateDomainPermission.isWithGrantOption() && !other.getPostCreateDomainPermission().isWithGrantOption()) {
                return false;
            }
            return this.postCreateDomainPermission.equalsIgnoreGrantOption(other.getPostCreateDomainPermission());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DomainCreatePermissionImpl otherDomainCreatePermission = (DomainCreatePermissionImpl)other;
            if (this.systemPermissionId != otherDomainCreatePermission.systemPermissionId) {
                return false;
            }
            if (this.withGrantOption != otherDomainCreatePermission.withGrantOption) {
                return false;
            }
            if (this.postCreateDomainPermission != null ? !this.postCreateDomainPermission.equals(otherDomainCreatePermission.postCreateDomainPermission) : otherDomainCreatePermission.postCreateDomainPermission != null) {
                return false;
            }
            return !(this.sysPermissionName != null ? !this.sysPermissionName.equals(otherDomainCreatePermission.sysPermissionName) : otherDomainCreatePermission.sysPermissionName != null);
        }

        @Override
        public boolean equalsIgnoreGrantOption(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DomainCreatePermissionImpl otherDomainCreatePermission = (DomainCreatePermissionImpl)other;
            if (this.systemPermissionId != otherDomainCreatePermission.systemPermissionId) {
                return false;
            }
            if (this.postCreateDomainPermission != null ? !this.postCreateDomainPermission.equals(otherDomainCreatePermission.postCreateDomainPermission) : otherDomainCreatePermission.postCreateDomainPermission != null) {
                return false;
            }
            return !(this.sysPermissionName != null ? !this.sysPermissionName.equals(otherDomainCreatePermission.sysPermissionName) : otherDomainCreatePermission.sysPermissionName != null);
        }

        public int hashCode() {
            int result = (int)(this.systemPermissionId ^ this.systemPermissionId >>> 32);
            result = 31 * result + (this.sysPermissionName != null ? this.sysPermissionName.hashCode() : 0);
            result = 31 * result + (this.postCreateDomainPermission != null ? this.postCreateDomainPermission.hashCode() : 0);
            result = 31 * result + (this.withGrantOption ? 1 : 0);
            return result;
        }

        public String toString() {
            if (this.postCreateDomainPermission == null) {
                return this.withGrantOption ? this.sysPermissionName + " /G" : this.sysPermissionName;
            }
            return "[" + this.postCreateDomainPermission.toString() + "]" + (this.withGrantOption ? " /G" : "");
        }

        private static SysPermission getSysPermission(String permissionName) {
            if (permissionName == null) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            String trimmedPermissionName = permissionName.trim();
            if (trimmedPermissionName.isEmpty()) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            SysPermission sysPermission = (SysPermission)sysPermissionsByName.get(trimmedPermissionName);
            if (sysPermission == null) {
                throw new IllegalArgumentException("Invalid system permission name: " + trimmedPermissionName);
            }
            return sysPermission;
        }
    }
}

