/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.SysPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DomainPermissions {
    private static final SysPermission SYSPERMISSION_SUPER_USER = new SysPermission(-301, "*SUPER-USER");
    public static final String SUPER_USER = SYSPERMISSION_SUPER_USER.getPermissionName();
    private static final SysPermission SYSPERMISSION_CREATE_CHILD_DOMAIN = new SysPermission(-302, "*CREATE-CHILD-DOMAIN");
    public static final String CREATE_CHILD_DOMAIN = SYSPERMISSION_CREATE_CHILD_DOMAIN.getPermissionName();
    private static final SysPermission SYSPERMISSION_DELETE = new SysPermission(-303, "*DELETE");
    public static final String DELETE = SYSPERMISSION_DELETE.getPermissionName();
    private static final Map<String, SysPermission> sysPermissionsByName = new HashMap<String, SysPermission>();
    private static final Map<Long, String> sysPermissionNamesById;
    private static final List<String> sysPermissionNames;
    private static final ConcurrentMap<String, DomainPermission> grantablePermissionsByName;
    private static final ConcurrentMap<String, DomainPermission> ungrantablePermissionsByName;

    public static List<String> getSysPermissionNames() {
        return sysPermissionNames;
    }

    public static String getSysPermissionName(long systemPermissionId) {
        String sysPermissionName = sysPermissionNamesById.get(systemPermissionId);
        if (sysPermissionName == null) {
            throw new IllegalArgumentException("Invalid system permission ID: " + systemPermissionId);
        }
        return sysPermissionName;
    }

    public static DomainPermission getInstance(String sysPermissionName) {
        DomainPermission cachedInstance;
        DomainPermission domainPermission = (DomainPermission)ungrantablePermissionsByName.get(sysPermissionName = DomainPermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (domainPermission == null && (cachedInstance = ungrantablePermissionsByName.putIfAbsent(sysPermissionName, domainPermission = new DomainPermissionImpl(sysPermissionName, false))) != null) {
            domainPermission = cachedInstance;
        }
        return domainPermission;
    }

    public static DomainPermission getInstanceWithGrantOption(String sysPermissionName) {
        DomainPermission cachedInstance;
        DomainPermission domainPermission = (DomainPermission)grantablePermissionsByName.get(sysPermissionName = DomainPermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (domainPermission == null && (cachedInstance = grantablePermissionsByName.putIfAbsent(sysPermissionName, domainPermission = new DomainPermissionImpl(sysPermissionName, true))) != null) {
            domainPermission = cachedInstance;
        }
        return domainPermission;
    }

    public static DomainPermission getInstance(DomainPermission domainPermission) {
        if (domainPermission instanceof DomainPermissionImpl) {
            return domainPermission;
        }
        DomainPermission verifiedPermission = domainPermission.isWithGrantOption() ? DomainPermissions.getInstanceWithGrantOption(domainPermission.getPermissionName()) : DomainPermissions.getInstance(domainPermission.getPermissionName());
        if (verifiedPermission.getSystemPermissionId() != domainPermission.getSystemPermissionId()) {
            throw new IllegalArgumentException("Invalid system permission id for domain permission: " + domainPermission);
        }
        return verifiedPermission;
    }

    private static String getCanonicalSysPermissionName(String permissionName) {
        if (permissionName == null) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        if ((permissionName = permissionName.trim()).isEmpty()) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        return permissionName;
    }

    static {
        sysPermissionsByName.put(SUPER_USER, SYSPERMISSION_SUPER_USER);
        sysPermissionsByName.put(CREATE_CHILD_DOMAIN, SYSPERMISSION_CREATE_CHILD_DOMAIN);
        sysPermissionsByName.put(DELETE, SYSPERMISSION_DELETE);
        sysPermissionNamesById = new HashMap<Long, String>(sysPermissionsByName.size());
        for (SysPermission sysPermission : sysPermissionsByName.values()) {
            sysPermissionNamesById.put(sysPermission.getSystemPermissionId(), sysPermission.getPermissionName());
        }
        sysPermissionNames = Collections.unmodifiableList(new ArrayList<String>(sysPermissionNamesById.values()));
        grantablePermissionsByName = new ConcurrentHashMap<String, DomainPermission>(sysPermissionsByName.size());
        ungrantablePermissionsByName = new ConcurrentHashMap<String, DomainPermission>(sysPermissionsByName.size());
    }

    static class DomainPermissionImpl
    implements DomainPermission,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long systemPermissionId;
        private final String permissionName;
        private final boolean withGrantOption;

        private DomainPermissionImpl(String sysPermissionName, boolean withGrantOption) {
            SysPermission sysPermission = DomainPermissionImpl.getSysPermission(sysPermissionName);
            this.systemPermissionId = sysPermission.getSystemPermissionId();
            this.permissionName = sysPermission.getPermissionName();
            this.withGrantOption = withGrantOption;
        }

        @Override
        public boolean isSystemPermission() {
            return this.systemPermissionId != 0L;
        }

        @Override
        public String getPermissionName() {
            return this.permissionName;
        }

        @Override
        public long getSystemPermissionId() {
            if (!this.isSystemPermission()) {
                throw new IllegalArgumentException("No system permission ID may be retrieved for user permission: " + this.permissionName + ", please check your code");
            }
            return this.systemPermissionId;
        }

        @Override
        public boolean isWithGrantOption() {
            return this.withGrantOption;
        }

        @Override
        public boolean isGrantableFrom(DomainPermission other) {
            if (other == null) {
                return false;
            }
            if (!other.isWithGrantOption()) {
                return false;
            }
            return this.permissionName.equals(other.getPermissionName());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DomainPermissionImpl otherDomainPermission = (DomainPermissionImpl)other;
            if (this.withGrantOption != otherDomainPermission.withGrantOption) {
                return false;
            }
            return this.permissionName.equals(otherDomainPermission.permissionName);
        }

        @Override
        public boolean equalsIgnoreGrantOption(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DomainPermissionImpl otherDomainPermission = (DomainPermissionImpl)other;
            return this.permissionName.equals(otherDomainPermission.permissionName);
        }

        public int hashCode() {
            int result = this.permissionName.hashCode();
            result = 31 * result + (this.withGrantOption ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.withGrantOption ? this.permissionName + " /G" : this.permissionName;
        }

        private static SysPermission getSysPermission(String permissionName) {
            if (permissionName == null) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            String trimmedPermissionName = permissionName.trim();
            if (trimmedPermissionName.isEmpty()) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            SysPermission sysPermission = (SysPermission)sysPermissionsByName.get(trimmedPermissionName);
            if (sysPermission == null) {
                throw new IllegalArgumentException("Invalid system permission name: " + trimmedPermissionName);
            }
            return sysPermission;
        }
    }
}

