/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.AuthorizationException;
import com.acciente.oacc.DomainCreatePermission;
import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourceCreatePermission;
import com.acciente.oacc.ResourcePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class NotAuthorizedException
extends AuthorizationException {
    private static final long serialVersionUID = 1L;

    public NotAuthorizedException(String message) {
        super(message);
    }

    public NotAuthorizedException(String message, Throwable cause) {
        super(message, cause);
    }

    public NotAuthorizedException(Throwable cause) {
        super(cause);
    }

    public static NotAuthorizedException newInstanceForAction(Resource accessorResource, String action) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " is not authorized to " + action);
    }

    public static NotAuthorizedException newInstanceForActionOnResource(Resource accessorResource, String action, Resource accessedResource) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " is not authorized to " + action + " resource " + String.valueOf(accessedResource));
    }

    public static NotAuthorizedException newInstanceForDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have domain create permission(s) " + String.valueOf(domainCreatePermissions));
    }

    public static NotAuthorizedException newInstanceForDomainCreatePermissions(Resource accessorResource, DomainCreatePermission domainCreatePermission, DomainCreatePermission ... domainCreatePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have domain create permission(s) " + NotAuthorizedException.toString(domainCreatePermission, domainCreatePermissions));
    }

    public static NotAuthorizedException newInstanceForDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> domainPermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have domain permission(s) " + String.valueOf(domainPermissions) + " on domain " + domainName);
    }

    public static NotAuthorizedException newInstanceForDomainPermissions(Resource accessorResource, String domainName, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have domain permission(s) " + NotAuthorizedException.toString(domainPermission, domainPermissions) + " on domain " + domainName);
    }

    public static NotAuthorizedException newInstanceForPostCreateDomainPermissions(Resource accessorResource, Set<DomainPermission> domainPermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " is not authorized to receive " + String.valueOf(domainPermissions) + " domain permission(s) after creating a domain");
    }

    public static NotAuthorizedException newInstanceForPostCreateDomainPermissions(Resource accessorResource, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " is not authorized to receive " + NotAuthorizedException.toString(domainPermission, domainPermissions) + " domain permission(s) after creating a domain");
    }

    public static NotAuthorizedException newInstanceForResourceCreatePermissions(Resource accessorResource, Set<ResourceCreatePermission> resourceCreatePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have resource create permission(s) " + String.valueOf(resourceCreatePermissions));
    }

    public static NotAuthorizedException newInstanceForResourceCreatePermissions(Resource accessorResource, ResourceCreatePermission resourceCreatePermission, ResourceCreatePermission ... resourceCreatePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have resource create permission(s) " + NotAuthorizedException.toString(resourceCreatePermission, resourceCreatePermissions));
    }

    public static NotAuthorizedException newInstanceForResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have permission(s) " + String.valueOf(resourcePermissions) + " on resource " + String.valueOf(accessedResource));
    }

    public static NotAuthorizedException newInstanceForResourcePermissions(Resource accessorResource, Resource accessedResource, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have permission(s) " + NotAuthorizedException.toString(resourcePermission, resourcePermissions) + " on resource " + String.valueOf(accessedResource));
    }

    public static NotAuthorizedException newInstanceForGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have global permission(s) " + String.valueOf(resourcePermissions) + " on resources of class " + resourceClassName + " in domain " + domainName);
    }

    public static NotAuthorizedException newInstanceForGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        return new NotAuthorizedException("Resource " + String.valueOf(accessorResource) + " does not have global permission(s) " + NotAuthorizedException.toString(resourcePermission, resourcePermissions) + " on resources of class " + resourceClassName + " in domain " + domainName);
    }

    public static NotAuthorizedException newInstanceForPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        return new NotAuthorizedException(accessorResource + "receive " + String.valueOf(resourcePermissions) + " permission(s) after creating a " + resourceClassName + " resource in domain " + domainName);
    }

    public static NotAuthorizedException newInstanceForPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        return new NotAuthorizedException(accessorResource + "receive " + NotAuthorizedException.toString(resourcePermission, resourcePermissions) + " permission(s) after creating a " + resourceClassName + " resource in domain " + domainName);
    }

    @SafeVarargs
    private static <T> String toString(T first, T ... others) {
        ArrayList<T> resultList;
        if (others == null) {
            resultList = new ArrayList<T>(2);
            resultList.add(null);
        } else {
            resultList = new ArrayList(others.length + 1);
            Collections.addAll(resultList, others);
        }
        resultList.add(first);
        return ((Object)resultList).toString();
    }
}

