/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.ResourceCreatePermission;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.SysPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ResourceCreatePermissions {
    private static final SysPermission SYSPERMISSION_CREATE = new SysPermission(-100, "*CREATE");
    public static final String CREATE = SYSPERMISSION_CREATE.getPermissionName();
    private static final Map<String, SysPermission> sysPermissionsByName = new HashMap<String, SysPermission>();
    private static final Map<Long, String> sysPermissionNamesById;
    private static final List<String> sysPermissionNames;
    private static final ConcurrentMap<String, ResourceCreatePermission> grantableCreatePermissionsByName;
    private static final ConcurrentMap<String, ResourceCreatePermission> ungrantableCreatePermissionsByName;
    private static final ConcurrentMap<ResourcePermission, ResourceCreatePermission> grantableCreatePermissionsByPostCreatePermission;
    private static final ConcurrentMap<ResourcePermission, ResourceCreatePermission> ungrantableCreatePermissionsByPostCreatePermission;

    public static List<String> getSysPermissionNames() {
        return sysPermissionNames;
    }

    public static String getSysPermissionName(long systemPermissionId) {
        String sysPermissionName = sysPermissionNamesById.get(systemPermissionId);
        if (sysPermissionName == null) {
            throw new IllegalArgumentException("Invalid system permission ID: " + systemPermissionId);
        }
        return sysPermissionName;
    }

    public static ResourceCreatePermission getInstanceWithGrantOption(String sysPermissionName) {
        ResourceCreatePermission cachedInstance;
        ResourceCreatePermission resourceCreatePermission = (ResourceCreatePermission)grantableCreatePermissionsByName.get(sysPermissionName = ResourceCreatePermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (resourceCreatePermission == null && (cachedInstance = grantableCreatePermissionsByName.putIfAbsent(sysPermissionName, resourceCreatePermission = new ResourceCreatePermissionImpl(sysPermissionName, true))) != null) {
            resourceCreatePermission = cachedInstance;
        }
        return resourceCreatePermission;
    }

    public static ResourceCreatePermission getInstance(String sysPermissionName) {
        ResourceCreatePermission cachedInstance;
        ResourceCreatePermission resourceCreatePermission = (ResourceCreatePermission)ungrantableCreatePermissionsByName.get(sysPermissionName = ResourceCreatePermissions.getCanonicalSysPermissionName(sysPermissionName));
        if (resourceCreatePermission == null && (cachedInstance = ungrantableCreatePermissionsByName.putIfAbsent(sysPermissionName, resourceCreatePermission = new ResourceCreatePermissionImpl(sysPermissionName, false))) != null) {
            resourceCreatePermission = cachedInstance;
        }
        return resourceCreatePermission;
    }

    public static ResourceCreatePermission getInstance(ResourcePermission postCreateResourcePermission) {
        ResourceCreatePermission cachedInstance;
        ResourceCreatePermissions.assertPostCreatePermissionSpecified(postCreateResourcePermission);
        postCreateResourcePermission = ResourcePermissions.getInstance(postCreateResourcePermission);
        ResourceCreatePermission resourceCreatePermission = (ResourceCreatePermission)ungrantableCreatePermissionsByPostCreatePermission.get(postCreateResourcePermission);
        if (resourceCreatePermission == null && (cachedInstance = ungrantableCreatePermissionsByPostCreatePermission.putIfAbsent(postCreateResourcePermission, resourceCreatePermission = new ResourceCreatePermissionImpl((ResourcePermissions.ResourcePermissionImpl)postCreateResourcePermission, false))) != null) {
            resourceCreatePermission = cachedInstance;
        }
        return resourceCreatePermission;
    }

    public static ResourceCreatePermission getInstanceWithGrantOption(ResourcePermission postCreateResourcePermission) {
        ResourceCreatePermission cachedInstance;
        ResourceCreatePermissions.assertPostCreatePermissionSpecified(postCreateResourcePermission);
        postCreateResourcePermission = ResourcePermissions.getInstance(postCreateResourcePermission);
        ResourceCreatePermission resourceCreatePermission = (ResourceCreatePermission)grantableCreatePermissionsByPostCreatePermission.get(postCreateResourcePermission);
        if (resourceCreatePermission == null && (cachedInstance = grantableCreatePermissionsByPostCreatePermission.putIfAbsent(postCreateResourcePermission, resourceCreatePermission = new ResourceCreatePermissionImpl((ResourcePermissions.ResourcePermissionImpl)postCreateResourcePermission, true))) != null) {
            resourceCreatePermission = cachedInstance;
        }
        return resourceCreatePermission;
    }

    public static ResourceCreatePermission getInstance(ResourceCreatePermission resourceCreatePermission) {
        ResourceCreatePermission verifiedPermission;
        if (resourceCreatePermission instanceof ResourceCreatePermissionImpl) {
            return resourceCreatePermission;
        }
        if (resourceCreatePermission.isSystemPermission()) {
            verifiedPermission = resourceCreatePermission.isWithGrantOption() ? ResourceCreatePermissions.getInstanceWithGrantOption(resourceCreatePermission.getPermissionName()) : ResourceCreatePermissions.getInstance(resourceCreatePermission.getPermissionName());
            if (verifiedPermission.getSystemPermissionId() != resourceCreatePermission.getSystemPermissionId()) {
                throw new IllegalArgumentException("Invalid system permission id for resource create permission: " + resourceCreatePermission);
            }
        } else {
            verifiedPermission = resourceCreatePermission.isWithGrantOption() ? ResourceCreatePermissions.getInstanceWithGrantOption(ResourcePermissions.getInstance(resourceCreatePermission.getPostCreateResourcePermission())) : ResourceCreatePermissions.getInstance(ResourcePermissions.getInstance(resourceCreatePermission.getPostCreateResourcePermission()));
        }
        return verifiedPermission;
    }

    private static String getCanonicalSysPermissionName(String permissionName) {
        if (permissionName == null) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        if ((permissionName = permissionName.trim()).isEmpty()) {
            throw new IllegalArgumentException("A system permission name is required");
        }
        return permissionName;
    }

    private static void assertPostCreatePermissionSpecified(ResourcePermission postCreateResourcePermission) {
        if (postCreateResourcePermission == null) {
            throw new IllegalArgumentException("A post create resource permission is required");
        }
    }

    static {
        sysPermissionsByName.put(CREATE, SYSPERMISSION_CREATE);
        sysPermissionNamesById = new HashMap<Long, String>(sysPermissionsByName.size());
        for (SysPermission sysPermission : sysPermissionsByName.values()) {
            sysPermissionNamesById.put(sysPermission.getSystemPermissionId(), sysPermission.getPermissionName());
        }
        sysPermissionNames = Collections.unmodifiableList(new ArrayList<String>(sysPermissionNamesById.values()));
        grantableCreatePermissionsByName = new ConcurrentHashMap<String, ResourceCreatePermission>(sysPermissionsByName.size());
        ungrantableCreatePermissionsByName = new ConcurrentHashMap<String, ResourceCreatePermission>(sysPermissionsByName.size());
        grantableCreatePermissionsByPostCreatePermission = new ConcurrentHashMap<ResourcePermission, ResourceCreatePermission>();
        ungrantableCreatePermissionsByPostCreatePermission = new ConcurrentHashMap<ResourcePermission, ResourceCreatePermission>();
    }

    static class ResourceCreatePermissionImpl
    implements ResourceCreatePermission,
    Serializable {
        private static final long serialVersionUID = 2L;
        private final long systemPermissionId;
        private final String sysPermissionName;
        private final ResourcePermissions.ResourcePermissionImpl postCreateResourcePermission;
        private final boolean withGrantOption;

        private ResourceCreatePermissionImpl(String sysPermissionName, boolean withGrantOption) {
            SysPermission sysPermission = ResourceCreatePermissionImpl.getSysPermission(sysPermissionName);
            this.systemPermissionId = sysPermission.getSystemPermissionId();
            this.sysPermissionName = sysPermission.getPermissionName();
            this.postCreateResourcePermission = null;
            this.withGrantOption = withGrantOption;
        }

        private ResourceCreatePermissionImpl(ResourcePermissions.ResourcePermissionImpl postCreateResourcePermission, boolean withGrantOption) {
            this.systemPermissionId = 0L;
            this.sysPermissionName = null;
            this.postCreateResourcePermission = postCreateResourcePermission;
            this.withGrantOption = withGrantOption;
        }

        @Override
        public boolean isSystemPermission() {
            return this.systemPermissionId != 0L;
        }

        @Override
        public String getPermissionName() {
            if (!this.isSystemPermission()) {
                throw new IllegalArgumentException("No system permission name may be retrieved for non-system resource create permission: " + this + ", please check your code");
            }
            return this.sysPermissionName;
        }

        @Override
        public long getSystemPermissionId() {
            if (!this.isSystemPermission()) {
                throw new IllegalArgumentException("No system permission ID may be retrieved for non-system resource create permission: " + this + ", please check your code");
            }
            return this.systemPermissionId;
        }

        @Override
        public ResourcePermission getPostCreateResourcePermission() {
            if (this.isSystemPermission()) {
                throw new IllegalArgumentException("No post create resource permission may be retrieved for system resource create permission: " + this + ", please check your code");
            }
            return this.postCreateResourcePermission;
        }

        @Override
        public boolean isWithGrantOption() {
            return this.withGrantOption;
        }

        @Override
        public boolean isGrantableFrom(ResourceCreatePermission other) {
            if (other == null) {
                return false;
            }
            if (!other.isWithGrantOption()) {
                return false;
            }
            if (this.isSystemPermission() != other.isSystemPermission()) {
                return false;
            }
            if (this.isSystemPermission()) {
                return this.systemPermissionId == other.getSystemPermissionId();
            }
            if (this.postCreateResourcePermission.isWithGrantOption() && !other.getPostCreateResourcePermission().isWithGrantOption()) {
                return false;
            }
            return this.postCreateResourcePermission.equalsIgnoreGrantOption(other.getPostCreateResourcePermission());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ResourceCreatePermissionImpl otherResourceCreatePermission = (ResourceCreatePermissionImpl)other;
            if (this.systemPermissionId != otherResourceCreatePermission.systemPermissionId) {
                return false;
            }
            if (this.sysPermissionName != null ? !this.sysPermissionName.equals(otherResourceCreatePermission.sysPermissionName) : otherResourceCreatePermission.sysPermissionName != null) {
                return false;
            }
            if (this.postCreateResourcePermission != null ? !this.postCreateResourcePermission.equals(otherResourceCreatePermission.postCreateResourcePermission) : otherResourceCreatePermission.postCreateResourcePermission != null) {
                return false;
            }
            return this.withGrantOption == otherResourceCreatePermission.withGrantOption;
        }

        @Override
        public boolean equalsIgnoreGrantOption(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ResourceCreatePermissionImpl otherResourceCreatePermission = (ResourceCreatePermissionImpl)other;
            if (this.systemPermissionId != otherResourceCreatePermission.systemPermissionId) {
                return false;
            }
            if (this.sysPermissionName != null ? !this.sysPermissionName.equals(otherResourceCreatePermission.sysPermissionName) : otherResourceCreatePermission.sysPermissionName != null) {
                return false;
            }
            return !(this.postCreateResourcePermission != null ? !this.postCreateResourcePermission.equals(otherResourceCreatePermission.postCreateResourcePermission) : otherResourceCreatePermission.postCreateResourcePermission != null);
        }

        public int hashCode() {
            int result = (int)(this.systemPermissionId ^ this.systemPermissionId >>> 32);
            result = 31 * result + (this.sysPermissionName != null ? this.sysPermissionName.hashCode() : 0);
            result = 31 * result + (this.postCreateResourcePermission != null ? this.postCreateResourcePermission.hashCode() : 0);
            result = 31 * result + (this.withGrantOption ? 1 : 0);
            return result;
        }

        public String toString() {
            if (this.postCreateResourcePermission == null) {
                return this.withGrantOption ? this.sysPermissionName + " /G" : this.sysPermissionName;
            }
            return "[" + this.postCreateResourcePermission.toString() + "]" + (this.withGrantOption ? " /G" : "");
        }

        private static SysPermission getSysPermission(String permissionName) {
            if (permissionName == null) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            String trimmedPermissionName = permissionName.trim();
            if (trimmedPermissionName.isEmpty()) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            SysPermission sysPermission = (SysPermission)sysPermissionsByName.get(trimmedPermissionName);
            if (sysPermission == null) {
                throw new IllegalArgumentException("Invalid system permission name: " + trimmedPermissionName);
            }
            return sysPermission;
        }
    }
}

