/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.SysPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ResourcePermissions {
    private static final SysPermission SYSPERMISSION_INHERIT = new SysPermission(-101, "*INHERIT");
    public static final String INHERIT = SYSPERMISSION_INHERIT.getPermissionName();
    private static final SysPermission SYSPERMISSION_IMPERSONATE = new SysPermission(-102, "*IMPERSONATE");
    public static final String IMPERSONATE = SYSPERMISSION_IMPERSONATE.getPermissionName();
    private static final SysPermission SYSPERMISSION_RESET_CREDENTIALS = new SysPermission(-103, "*RESET-CREDENTIALS");
    public static final String RESET_CREDENTIALS = SYSPERMISSION_RESET_CREDENTIALS.getPermissionName();
    private static final SysPermission SYSPERMISSION_DELETE = new SysPermission(-104, "*DELETE");
    public static final String DELETE = SYSPERMISSION_DELETE.getPermissionName();
    private static final SysPermission SYSPERMISSION_QUERY = new SysPermission(-105, "*QUERY");
    public static final String QUERY = SYSPERMISSION_QUERY.getPermissionName();
    private static final Map<String, SysPermission> sysPermissionsByName = new HashMap<String, SysPermission>();
    private static final Map<Long, String> sysPermissionNamesById;
    private static final List<String> sysPermissionNames;
    private static final ConcurrentMap<String, ResourcePermission> ungrantablePermissionByName;
    private static final ConcurrentMap<String, ResourcePermission> grantablePermissionByName;

    public static List<String> getSysPermissionNames() {
        return sysPermissionNames;
    }

    public static String getSysPermissionName(long systemPermissionId) {
        String sysPermissionName = sysPermissionNamesById.get(systemPermissionId);
        if (sysPermissionName == null) {
            throw new IllegalArgumentException("Invalid system permission ID: " + systemPermissionId);
        }
        return sysPermissionName;
    }

    public static ResourcePermission getInstance(String permissionName) {
        ResourcePermission cachedInstance;
        ResourcePermission resourcePermission = (ResourcePermission)ungrantablePermissionByName.get(permissionName = ResourcePermissions.getCanonicalPermissionName(permissionName));
        if (resourcePermission == null && (cachedInstance = ungrantablePermissionByName.putIfAbsent(permissionName, resourcePermission = new ResourcePermissionImpl(permissionName, false))) != null) {
            resourcePermission = cachedInstance;
        }
        return resourcePermission;
    }

    public static ResourcePermission getInstanceWithGrantOption(String permissionName) {
        ResourcePermission cachedInstance;
        ResourcePermission resourcePermission = (ResourcePermission)grantablePermissionByName.get(permissionName = ResourcePermissions.getCanonicalPermissionName(permissionName));
        if (resourcePermission == null && (cachedInstance = grantablePermissionByName.putIfAbsent(permissionName, resourcePermission = new ResourcePermissionImpl(permissionName, true))) != null) {
            resourcePermission = cachedInstance;
        }
        return resourcePermission;
    }

    public static ResourcePermission getInstance(ResourcePermission resourcePermission) {
        if (resourcePermission instanceof ResourcePermissionImpl) {
            return resourcePermission;
        }
        ResourcePermission verifiedPermission = resourcePermission.isWithGrantOption() ? ResourcePermissions.getInstanceWithGrantOption(resourcePermission.getPermissionName()) : ResourcePermissions.getInstance(resourcePermission.getPermissionName());
        if (resourcePermission.isSystemPermission() && verifiedPermission.getSystemPermissionId() != resourcePermission.getSystemPermissionId()) {
            throw new IllegalArgumentException("Invalid system permission id for resource permission: " + resourcePermission);
        }
        return verifiedPermission;
    }

    private static String getCanonicalPermissionName(String permissionName) {
        if (permissionName == null) {
            throw new IllegalArgumentException("A permission name is required");
        }
        if ((permissionName = permissionName.trim()).isEmpty()) {
            throw new IllegalArgumentException("A permission name is required");
        }
        return permissionName;
    }

    static {
        sysPermissionsByName.put(INHERIT, SYSPERMISSION_INHERIT);
        sysPermissionsByName.put(IMPERSONATE, SYSPERMISSION_IMPERSONATE);
        sysPermissionsByName.put(RESET_CREDENTIALS, SYSPERMISSION_RESET_CREDENTIALS);
        sysPermissionsByName.put(DELETE, SYSPERMISSION_DELETE);
        sysPermissionsByName.put(QUERY, SYSPERMISSION_QUERY);
        sysPermissionNamesById = new HashMap<Long, String>(sysPermissionsByName.size());
        for (SysPermission sysPermission : sysPermissionsByName.values()) {
            sysPermissionNamesById.put(sysPermission.getSystemPermissionId(), sysPermission.getPermissionName());
        }
        sysPermissionNames = Collections.unmodifiableList(new ArrayList<String>(sysPermissionNamesById.values()));
        ungrantablePermissionByName = new ConcurrentHashMap<String, ResourcePermission>();
        grantablePermissionByName = new ConcurrentHashMap<String, ResourcePermission>();
    }

    static class ResourcePermissionImpl
    implements ResourcePermission,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long systemPermissionId;
        private final String permissionName;
        private final boolean withGrantOption;

        private ResourcePermissionImpl(String permissionName, boolean withGrantOption) {
            this.assertPermissionNameSpecified(permissionName);
            permissionName = permissionName.trim();
            if (permissionName.startsWith("*")) {
                SysPermission sysPermission = ResourcePermissionImpl.getSysPermission(permissionName);
                this.systemPermissionId = sysPermission.getSystemPermissionId();
                this.permissionName = sysPermission.getPermissionName();
            } else {
                this.systemPermissionId = 0L;
                this.permissionName = permissionName.intern();
            }
            this.withGrantOption = withGrantOption;
        }

        @Override
        public boolean isSystemPermission() {
            return this.systemPermissionId != 0L;
        }

        @Override
        public String getPermissionName() {
            return this.permissionName;
        }

        @Override
        public long getSystemPermissionId() {
            if (!this.isSystemPermission()) {
                throw new IllegalArgumentException("No system permission ID may be retrieved for user permission: " + this.permissionName + ", please check your code");
            }
            return this.systemPermissionId;
        }

        @Override
        public boolean isWithGrantOption() {
            return this.withGrantOption;
        }

        @Override
        public boolean isGrantableFrom(ResourcePermission other) {
            if (other == null) {
                return false;
            }
            if (!other.isWithGrantOption()) {
                return false;
            }
            return this.equalsIgnoreGrantOption(other);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ResourcePermissionImpl otherResourcePermission = (ResourcePermissionImpl)other;
            if (!this.permissionName.equals(otherResourcePermission.permissionName)) {
                return false;
            }
            return this.withGrantOption == otherResourcePermission.withGrantOption;
        }

        @Override
        public boolean equalsIgnoreGrantOption(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ResourcePermissionImpl otherResourcePermission = (ResourcePermissionImpl)other;
            return this.permissionName.equals(otherResourcePermission.permissionName);
        }

        public int hashCode() {
            int result = this.permissionName.hashCode();
            result = 31 * result + (this.withGrantOption ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.withGrantOption ? this.permissionName + " /G" : this.permissionName;
        }

        private void assertPermissionNameSpecified(String permissionName) {
            if (permissionName == null || permissionName.trim().isEmpty()) {
                throw new IllegalArgumentException("A permission name is required");
            }
        }

        private static SysPermission getSysPermission(String permissionName) {
            if (permissionName == null) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            String trimmedPermissionName = permissionName.trim();
            if (trimmedPermissionName.isEmpty()) {
                throw new IllegalArgumentException("A system permission name is required");
            }
            SysPermission sysPermission = (SysPermission)sysPermissionsByName.get(trimmedPermissionName);
            if (sysPermission == null) {
                throw new IllegalArgumentException("Invalid system permission name: " + trimmedPermissionName);
            }
            return sysPermission;
        }
    }
}

