/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import com.acciente.oacc.Resource;
import java.io.Serializable;

public class Resources {
    public static Resource getInstance(long resourceId) {
        return new ResourceImpl(resourceId, null);
    }

    public static Resource getInstance(long resourceId, String externalId) {
        return new ResourceImpl(resourceId, externalId);
    }

    public static Resource getInstance(String externalId) {
        return new ResourceImpl(externalId);
    }

    private static class ResourceImpl
    implements Resource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Long resourceId;
        private final String externalId;

        private ResourceImpl(long resourceId, String externalId) {
            this.resourceId = resourceId;
            this.externalId = externalId;
        }

        private ResourceImpl(String externalId) {
            this.resourceId = null;
            this.externalId = externalId;
        }

        @Override
        public Long getId() {
            return this.resourceId;
        }

        @Override
        public String getExternalId() {
            return this.externalId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ResourceImpl otherResource = (ResourceImpl)other;
            if (this.resourceId != null ? !this.resourceId.equals(otherResource.resourceId) : otherResource.resourceId != null) {
                return false;
            }
            return !(this.externalId == null ? otherResource.externalId != null : !this.externalId.equals(otherResource.externalId));
        }

        public int hashCode() {
            int result = this.resourceId != null ? this.resourceId.hashCode() : 0;
            result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
            return result;
        }

        public String toString() {
            if (this.resourceId != null && this.externalId != null) {
                return "{resourceId: " + String.valueOf(this.resourceId) + ", externalId: \"" + this.externalId + "\"}";
            }
            if (this.resourceId != null) {
                return "{resourceId: " + String.valueOf(this.resourceId) + "}";
            }
            if (this.externalId != null) {
                return "{externalId: \"" + this.externalId + "\"}";
            }
            return "{}";
        }
    }
}

