/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc;

import java.io.Serializable;

class SysPermission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long systemPermissionId;
    private final String permissionName;

    SysPermission(int systemPermissionId, String permissionName) {
        if (systemPermissionId == 0) {
            throw new IllegalArgumentException("System permission ID must be non-zero");
        }
        if (!permissionName.startsWith("*")) {
            throw new IllegalArgumentException("System permission names MUST start with *");
        }
        this.systemPermissionId = systemPermissionId;
        this.permissionName = permissionName.intern();
    }

    public long getSystemPermissionId() {
        return this.systemPermissionId;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public int hashCode() {
        int result = (int)(this.systemPermissionId ^ this.systemPermissionId >>> 32);
        result = 31 * result + this.permissionName.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SysPermission that = (SysPermission)o;
        if (this.systemPermissionId != that.systemPermissionId) {
            return false;
        }
        return this.permissionName.equals(that.permissionName);
    }
}

