/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import java.io.Serializable;

public class TransitioningPasswordEncryptor
implements PasswordEncryptor,
Serializable {
    private final PasswordEncryptor newPasswordEncryptor;
    private final PasswordEncryptor oldPasswordEncryptor;

    public static TransitioningPasswordEncryptor newInstance(PasswordEncryptor newPasswordEncryptor, PasswordEncryptor oldPasswordEncryptor) {
        return new TransitioningPasswordEncryptor(newPasswordEncryptor, oldPasswordEncryptor);
    }

    private TransitioningPasswordEncryptor(PasswordEncryptor newPasswordEncryptor, PasswordEncryptor oldPasswordEncryptor) {
        this.newPasswordEncryptor = newPasswordEncryptor;
        this.oldPasswordEncryptor = oldPasswordEncryptor;
    }

    @Override
    public String encryptPassword(char[] password) {
        return this.newPasswordEncryptor.encryptPassword(password);
    }

    @Override
    public boolean checkPassword(char[] plainPassword, String encryptedPassword) {
        try {
            return this.newPasswordEncryptor.checkPassword(plainPassword, encryptedPassword);
        }
        catch (IllegalArgumentException e) {
            return this.oldPasswordEncryptor.checkPassword(plainPassword, encryptedPassword);
        }
    }
}

