/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor.bcrypt;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.encryptor.bcrypt.PasswordEncoderDecoder;
import com.acciente.oacc.normalizer.TextNormalizer;
import java.io.Serializable;
import java.security.SecureRandom;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;

public class BCryptPasswordEncryptor
implements PasswordEncryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "bcrypt";
    private static final int BCRYPT_COST_FACTOR_MIN = 4;
    private static final int BCRYPT_COST_FACTOR_MAX = 31;
    private static final int BCRYPT_SALT_SIZE = 16;
    private static final PasswordEncoderDecoder passwordEncoderDecoder = new PasswordEncoderDecoder();
    private static final SecureRandom secureRandom = new SecureRandom();
    private final int costFactor;

    public static BCryptPasswordEncryptor newInstance(int costFactor) {
        BCryptPasswordEncryptor.assertCostFactorValid(costFactor);
        return new BCryptPasswordEncryptor(costFactor);
    }

    private BCryptPasswordEncryptor(int costFactor) {
        this.costFactor = costFactor;
    }

    @Override
    public String encryptPassword(char[] plainPassword) {
        if (plainPassword == null) {
            return null;
        }
        char[] normalizedChars = TextNormalizer.getInstance().normalizeToNfc(plainPassword);
        String bcryptString = OpenBSDBCrypt.generate((char[])normalizedChars, (byte[])BCryptPasswordEncryptor.gensalt(), (int)this.costFactor);
        return passwordEncoderDecoder.encode(bcryptString);
    }

    @Override
    public boolean checkPassword(char[] plainPassword, String storedPassword) {
        if (plainPassword == null) {
            return storedPassword == null;
        }
        if (storedPassword == null) {
            return false;
        }
        String bcryptString = passwordEncoderDecoder.decode(storedPassword);
        char[] normalizedChars = TextNormalizer.getInstance().normalizeToNfc(plainPassword);
        return OpenBSDBCrypt.checkPassword((String)bcryptString, (char[])normalizedChars);
    }

    public int getCostFactor() {
        return this.costFactor;
    }

    private static byte[] gensalt() {
        byte[] saltBytes = new byte[16];
        secureRandom.nextBytes(saltBytes);
        return saltBytes;
    }

    private static void assertCostFactorValid(int computedCostFactorMin) {
        if (computedCostFactorMin < 4 || computedCostFactorMin > 31) {
            throw new IllegalArgumentException("The cost factor must be between 4 and 31 (inclusive)");
        }
    }
}

