/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor.jasypt;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.encryptor.jasypt.DecodedPassword;
import com.acciente.oacc.encryptor.jasypt.PasswordEncoderDecoder;
import com.acciente.oacc.encryptor.jasypt.StandardByteDigesterPool;
import com.acciente.oacc.normalizer.TextNormalizer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class JasyptPasswordEncryptor
implements PasswordEncryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "jasypt";
    private static final StandardByteDigesterPool digesterPool = new StandardByteDigesterPool();
    private static final PasswordEncoderDecoder passwordEncoderDecoder = new PasswordEncoderDecoder();
    private final String algorithm;
    private final int iterations;
    private final int saltSizeBytes;

    public static JasyptPasswordEncryptor newInstance(String algorithm, int iterations, int saltSizeBytes) {
        return new JasyptPasswordEncryptor(algorithm, iterations, saltSizeBytes);
    }

    private JasyptPasswordEncryptor(String algorithm, int iterations, int saltSizeBytes) {
        this.algorithm = algorithm;
        this.iterations = iterations;
        this.saltSizeBytes = saltSizeBytes;
    }

    @Override
    public String encryptPassword(char[] plainPassword) {
        if (plainPassword == null) {
            return null;
        }
        byte[] digest = digesterPool.getStandardByteDigester(this.algorithm, this.iterations, this.saltSizeBytes).digest(JasyptPasswordEncryptor.getCleanedBytes(plainPassword));
        return passwordEncoderDecoder.encode(this.algorithm, this.iterations, this.saltSizeBytes, digest);
    }

    @Override
    public boolean checkPassword(char[] plainPassword, String storedPassword) {
        if (plainPassword == null) {
            return storedPassword == null;
        }
        if (storedPassword == null) {
            return false;
        }
        DecodedPassword decodedPassword = passwordEncoderDecoder.decode(storedPassword);
        return digesterPool.getStandardByteDigester(decodedPassword.getAlgorithm(), decodedPassword.getIterations(), decodedPassword.getSaltSizeBytes()).matches(JasyptPasswordEncryptor.getCleanedBytes(plainPassword), decodedPassword.getDigest());
    }

    private static byte[] getCleanedBytes(char[] password) {
        char[] normalizedChars = TextNormalizer.getInstance().normalizeToNfc(password);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(normalizedChars));
        byte[] byteArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byteArray);
        Arrays.fill(byteBuffer.array(), (byte)0);
        return byteArray;
    }
}

