/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor.jasypt;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.normalizer.TextNormalizer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.digest.StandardByteDigester;

public final class LegacyJasyptPasswordEncryptor
implements PasswordEncryptor {
    private final StandardByteDigester digester = new StandardByteDigester();
    private final Base64 base64;

    public static LegacyJasyptPasswordEncryptor newInstance() {
        return new LegacyJasyptPasswordEncryptor();
    }

    private LegacyJasyptPasswordEncryptor() {
        this.digester.setAlgorithm("SHA-256");
        this.digester.setIterations(100000);
        this.digester.setSaltSizeBytes(16);
        this.digester.initialize();
        this.base64 = new Base64();
    }

    @Override
    public String encryptPassword(char[] password) {
        if (password == null) {
            return null;
        }
        byte[] digest = this.digester.digest(this.getCleanedBytes(password));
        return new String(this.base64.encode(digest), StandardCharsets.US_ASCII);
    }

    @Override
    public boolean checkPassword(char[] plainPassword, String encryptedPassword) {
        if (plainPassword == null) {
            return encryptedPassword == null;
        }
        if (encryptedPassword == null) {
            return false;
        }
        return this.digester.matches(this.getCleanedBytes(plainPassword), this.base64.decode(encryptedPassword.getBytes(StandardCharsets.US_ASCII)));
    }

    private byte[] getCleanedBytes(char[] password) {
        char[] normalizedChars = TextNormalizer.getInstance().normalizeToNfc(password);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(normalizedChars));
        byte[] byteArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byteArray);
        Arrays.fill(byteBuffer.array(), (byte)0);
        return byteArray;
    }
}

