/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor.jasypt;

import com.acciente.oacc.encryptor.jasypt.DecodedPassword;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;

class PasswordEncoderDecoder {
    private static final String MARKER = "jasypt:";
    private static final String PARAM_DELIMITER = "$";
    private static final String QUOTED_PARAM_DELIMITER = Pattern.quote("$");
    private static final int DECODED_PASSWORD_ARRAY_ALGORITHM = 0;
    private static final int DECODED_PASSWORD_ARRAY_ITERATIONS = 1;
    private static final int DECODED_PASSWORD_ARRAY_SALT_SIZE_BYTES = 2;
    private static final int DECODED_PASSWORD_ARRAY_DIGEST = 3;
    private static final int DECODED_PASSWORD_ARRAY_COUNT = 4;
    private static final Base64 base64 = new Base64();

    PasswordEncoderDecoder() {
    }

    String encode(String algorithm, int iterations, int saltSizeBytes, byte[] digest) {
        Object[] decodedPasswordArray = new Object[]{algorithm, iterations, saltSizeBytes, new String(base64.encode(digest), StandardCharsets.US_ASCII)};
        StringBuilder encodedPassword = new StringBuilder(128).append(MARKER);
        for (int i = 0; i < 3; ++i) {
            encodedPassword.append(decodedPasswordArray[i]);
            encodedPassword.append(PARAM_DELIMITER);
        }
        encodedPassword.append(decodedPasswordArray[3]);
        return encodedPassword.toString();
    }

    DecodedPassword decode(String encodedPassword) {
        if (encodedPassword.startsWith(MARKER)) {
            int saltSizeBytes;
            int iterations;
            String[] decodedPasswordArray = encodedPassword.substring(MARKER.length()).split(QUOTED_PARAM_DELIMITER);
            if (decodedPasswordArray.length != 4) {
                throw new IllegalArgumentException("Unexpected format for Jasypt password: " + encodedPassword.substring(0, MARKER.length()));
            }
            String algorithm = decodedPasswordArray[0];
            try {
                iterations = Integer.parseInt(decodedPasswordArray[1]);
                saltSizeBytes = Integer.parseInt(decodedPasswordArray[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unexpected value in Jasypt password header for iterations and/or salt size: " + encodedPassword);
            }
            byte[] digest = base64.decode(decodedPasswordArray[3].getBytes(StandardCharsets.US_ASCII));
            return new DecodedPassword.Builder().algorithm(algorithm).iterations(iterations).saltSizeBytes(saltSizeBytes).digest(digest).build();
        }
        throw new IllegalArgumentException("Unexpected marker for Jasypt password: " + encodedPassword.substring(0, MARKER.length()));
    }
}

