/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.encryptor.jasypt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasypt.digest.StandardByteDigester;

class StandardByteDigesterPool {
    private final Map<String, Map<Integer, Map<Integer, StandardByteDigester>>> algorithmMap = new ConcurrentHashMap<String, Map<Integer, Map<Integer, StandardByteDigester>>>();

    StandardByteDigesterPool() {
    }

    public StandardByteDigester getStandardByteDigester(String algorithm, int iterations, int saltSizeBytes) {
        Map<Integer, StandardByteDigester> saltSizeBytesMap = StandardByteDigesterPool.getInnerMap(StandardByteDigesterPool.getInnerMap(this.algorithmMap, algorithm), iterations);
        StandardByteDigester standardByteDigester = saltSizeBytesMap.get(saltSizeBytes);
        if (standardByteDigester == null) {
            standardByteDigester = StandardByteDigesterPool.newStandardByteDigester(algorithm, iterations, saltSizeBytes);
            saltSizeBytesMap.put(saltSizeBytes, standardByteDigester);
        }
        return standardByteDigester;
    }

    private static <K, IK, IV> Map<IK, IV> getInnerMap(Map<K, Map<IK, IV>> outerMap, K outerKey) {
        Map<IK, IV> innerMap = outerMap.get(outerKey);
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap<IK, IV>();
            outerMap.put(outerKey, innerMap);
        }
        return innerMap;
    }

    private static StandardByteDigester newStandardByteDigester(String algorithm, int iterations, int saltSizeBytes) {
        StandardByteDigester standardByteDigester = new StandardByteDigester();
        standardByteDigester.setAlgorithm(algorithm);
        standardByteDigester.setIterations(iterations);
        standardByteDigester.setSaltSizeBytes(saltSizeBytes);
        standardByteDigester.initialize();
        return standardByteDigester;
    }
}

