/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.normalizer.icu4j;

import com.acciente.oacc.normalizer.TextNormalizer;
import com.ibm.icu.text.Normalizer;

public class ICU4Jv26TextNormalizer
extends TextNormalizer {
    private static final char ZERO_CHAR = '\u0000';

    private ICU4Jv26TextNormalizer() {
        Normalizer.normalize((String)"", (Normalizer.Mode)Normalizer.NFC, (int)0);
    }

    public static TextNormalizer getInstance() {
        return LazyInitSingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] normalizeToNfc(char[] source) {
        int destBufferSize = 3 * source.length;
        char[] result = null;
        do {
            char[] destBuffer = new char[destBufferSize];
            try {
                int destBufferUsedCount = Normalizer.normalize((char[])source, (char[])destBuffer, (Normalizer.Mode)Normalizer.NFC, (int)0);
                result = this.copyContents(destBuffer, destBufferUsedCount);
            }
            catch (IndexOutOfBoundsException e) {
                destBufferSize += source.length;
            }
            finally {
                this.zeroOut(destBuffer);
            }
        } while (result == null);
        return result;
    }

    private char[] copyContents(char[] source, int countToCopy) {
        char[] copy = new char[countToCopy];
        System.arraycopy(source, 0, copy, 0, countToCopy);
        return copy;
    }

    private void zeroOut(char[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = '\u0000';
        }
    }

    private static class LazyInitSingletonHolder {
        private static final TextNormalizer INSTANCE = new ICU4Jv26TextNormalizer();

        private LazyInitSingletonHolder() {
        }
    }
}

