/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.normalizer.icu4j;

import com.acciente.oacc.normalizer.TextNormalizer;
import com.acciente.oacc.normalizer.icu4j.Normalizer2Factory;
import com.ibm.icu.text.Normalizer2;
import java.nio.CharBuffer;

public class ICU4Jv46TextNormalizer
extends TextNormalizer {
    private static final char ZERO_CHAR = '\u0000';
    private final Normalizer2 nfcNormalizer = Normalizer2Factory.getNFCInstance();

    private ICU4Jv46TextNormalizer() {
    }

    public static TextNormalizer getInstance() {
        return LazyInitSingletonHolder.INSTANCE;
    }

    @Override
    public char[] normalizeToNfc(char[] charArraySource) {
        StringBuilder stringBuilderDest = new StringBuilder(3 * charArraySource.length);
        this.nfcNormalizer.normalize((CharSequence)CharBuffer.wrap(charArraySource), stringBuilderDest);
        char[] charArrayDest = this.copyContents(stringBuilderDest);
        this.zeroOut(stringBuilderDest);
        return charArrayDest;
    }

    private char[] copyContents(StringBuilder source) {
        char[] copy = new char[source.length()];
        source.getChars(0, copy.length, copy, 0);
        return copy;
    }

    private void zeroOut(StringBuilder dest) {
        dest.setLength(dest.capacity());
        for (int i = 0; i < dest.length(); ++i) {
            dest.setCharAt(i, '\u0000');
        }
        dest.setLength(0);
    }

    private static class LazyInitSingletonHolder {
        private static final TextNormalizer INSTANCE = new ICU4Jv46TextNormalizer();

        private LazyInitSingletonHolder() {
        }
    }
}

