/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.sql.internal.encryptor.PasswordEncryptors;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public class SQLAccessControlSystemInitializer {
    private static final String PROP_DbUrl = "-dburl";
    private static final String PROP_DbUser = "-dbuser";
    private static final String PROP_DbPwd = "-dbpwd";
    private static final String PROP_DbSchema = "-dbschema";
    private static final String PROP_PwdEncryptor = "-pwdencryptor";
    private static final String PROP_OACCRootPwd = "-oaccsystempwd";
    private static final String OPT_HELP_SHORT = "-h";
    private static final String OPT_HELP_LONG = "--help";
    private static final String OPT_HELP_QUESTION = "-?";
    private static final String USAGE = "Usage:\n  java com.acciente.oacc.SQLAccessControlSystemInitializer -dburl=<db-url> -pwdencryptor=(" + SQLAccessControlSystemInitializer.join(" | ", PasswordEncryptors.getSupportedEncryptorNames()) + ") " + "-oaccsystempwd" + "=<OACC-system-password> " + "[options]" + "\n\nOptions:" + "\n  " + "-dbuser" + "=<db-user>      Database username." + "\n  " + "-dbpwd" + "=<db-password>   Database password." + "\n  " + "-dbschema" + "=<db-schema>  Database schema." + "\n\nOther:" + "\n  -h, --help, -?         Shows usage info.";

    public static void main(String[] args) throws SQLException, IOException {
        Properties optionArgs = new Properties();
        for (String arg : args) {
            optionArgs.load(new StringReader(arg));
        }
        if (args.length == 0 || optionArgs.containsKey(OPT_HELP_SHORT) || optionArgs.containsKey(OPT_HELP_LONG) || optionArgs.containsKey(OPT_HELP_QUESTION)) {
            System.out.println(USAGE);
            return;
        }
        SQLAccessControlSystemInitializer.verifyOptionArgs(optionArgs);
        SQLAccessControlSystemInitializer.initializeOACC(optionArgs.getProperty(PROP_DbUrl), optionArgs.getProperty(PROP_DbUser), optionArgs.getProperty(PROP_DbPwd), optionArgs.getProperty(PROP_DbSchema), optionArgs.getProperty(PROP_OACCRootPwd).toCharArray(), PasswordEncryptors.getPasswordEncryptor(optionArgs.getProperty(PROP_PwdEncryptor)));
    }

    private static void verifyOptionArgs(Properties optionArgs) {
        if (optionArgs.getProperty(PROP_DbUrl) == null) {
            throw new IllegalArgumentException("-dburl is required!\n" + USAGE);
        }
        if (optionArgs.getProperty(PROP_PwdEncryptor) == null) {
            throw new IllegalArgumentException("-pwdencryptor is required!\n" + USAGE);
        }
        if (optionArgs.getProperty(PROP_OACCRootPwd) == null) {
            throw new IllegalArgumentException("-oaccsystempwd is required!\n" + USAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeOACC(String dbUrl, String dbUser, String dbPwd, String dbSchema, char[] oaccRootPwd, PasswordEncryptor passwordEncryptor) throws SQLException {
        System.out.println("Connecting to OACC database @ " + dbUrl);
        try (Connection connection = DriverManager.getConnection(dbUrl, dbUser, dbPwd);){
            com.acciente.oacc.sql.internal.SQLAccessControlSystemInitializer.initializeOACC(connection, dbSchema, oaccRootPwd, passwordEncryptor);
        }
        finally {
            System.out.println("Disconnecting from OACC database @ " + dbUrl);
        }
        System.out.println("Initialize..OK!");
    }

    public static void initializeOACC(Connection connection, String dbSchema, char[] oaccRootPwd, PasswordEncryptor passwordEncryptor) throws SQLException {
        com.acciente.oacc.sql.internal.SQLAccessControlSystemInitializer.initializeOACC(connection, dbSchema, oaccRootPwd, passwordEncryptor);
    }

    private static String join(String delimiter, List<String> elements) {
        if (elements == null || elements.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(elements.get(0));
        for (String element : elements.subList(1, elements.size())) {
            result.append(delimiter);
            result.append(element);
        }
        return result.toString();
    }
}

