/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal;

import com.acciente.oacc.AccessControlContext;
import com.acciente.oacc.AuthenticationProvider;
import com.acciente.oacc.Credentials;
import com.acciente.oacc.DomainCreatePermission;
import com.acciente.oacc.DomainCreatePermissions;
import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.DomainPermissions;
import com.acciente.oacc.NotAuthenticatedException;
import com.acciente.oacc.NotAuthorizedException;
import com.acciente.oacc.OaccException;
import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourceClassInfo;
import com.acciente.oacc.ResourceCreatePermission;
import com.acciente.oacc.ResourceCreatePermissions;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.Resources;
import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.ResourceClassInternalInfo;
import com.acciente.oacc.sql.internal.SQLPasswordAuthenticationProvider;
import com.acciente.oacc.sql.internal.SchemaNameValidator;
import com.acciente.oacc.sql.internal.persister.DomainPersister;
import com.acciente.oacc.sql.internal.persister.GrantDomainCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantDomainCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantGlobalResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.GrantGlobalResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantResourceCreatePermissionPostCreatePersister;
import com.acciente.oacc.sql.internal.persister.GrantResourceCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantResourceCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.GrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.GrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveDomainPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantDomainCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantDomainCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantGlobalResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantGlobalResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantResourceCreatePermissionPostCreatePersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantResourceCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantResourceCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveGrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursiveResourcePersister;
import com.acciente.oacc.sql.internal.persister.RecursiveDomainPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantDomainCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantDomainCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantGlobalResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantGlobalResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantResourceCreatePermissionPostCreatePersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantResourceCreatePermissionPostCreateSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantResourceCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveGrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.RecursiveResourcePersister;
import com.acciente.oacc.sql.internal.persister.ResourceClassPermissionPersister;
import com.acciente.oacc.sql.internal.persister.ResourceClassPersister;
import com.acciente.oacc.sql.internal.persister.ResourcePersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class SQLAccessControlContext
implements AccessControlContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient DataSource dataSource;
    private transient Connection connection;
    private AuthenticationProvider authenticationProvider;
    private boolean hasDefaultAuthenticationProvider;
    private Resource authenticatedResource;
    private Resource defensiveCopyOfAuthenticatedResource;
    private String authenticatedResourceDomainName;
    private Resource sessionResource;
    private Resource defensiveCopyOfSessionResource;
    private String sessionResourceDomainName;
    private static final Long SYSTEM_RESOURCE_ID = 0L;
    private static final DomainPermission DomainPermission_CREATE_CHILD_DOMAIN = DomainPermissions.getInstance(DomainPermissions.CREATE_CHILD_DOMAIN);
    private static final DomainPermission DomainPermission_CREATE_CHILD_DOMAIN_GRANT = DomainPermissions.getInstanceWithGrantOption(DomainPermissions.CREATE_CHILD_DOMAIN);
    private static final DomainPermission DomainPermission_DELETE = DomainPermissions.getInstance(DomainPermissions.DELETE);
    private static final DomainPermission DomainPermission_DELETE_GRANT = DomainPermissions.getInstanceWithGrantOption(DomainPermissions.DELETE);
    private static final DomainPermission DomainPermission_SUPER_USER = DomainPermissions.getInstance(DomainPermissions.SUPER_USER);
    private static final DomainPermission DomainPermission_SUPER_USER_GRANT = DomainPermissions.getInstanceWithGrantOption(DomainPermissions.SUPER_USER);
    private static final ResourcePermission ResourcePermission_INHERIT = ResourcePermissions.getInstance(ResourcePermissions.INHERIT);
    private static final ResourcePermission ResourcePermission_INHERIT_GRANT = ResourcePermissions.getInstanceWithGrantOption(ResourcePermissions.INHERIT);
    private static final ResourcePermission ResourcePermission_IMPERSONATE = ResourcePermissions.getInstance(ResourcePermissions.IMPERSONATE);
    private static final ResourcePermission ResourcePermission_IMPERSONATE_GRANT = ResourcePermissions.getInstanceWithGrantOption(ResourcePermissions.IMPERSONATE);
    private static final ResourcePermission ResourcePermission_RESET_CREDENTIALS = ResourcePermissions.getInstance(ResourcePermissions.RESET_CREDENTIALS);
    private static final ResourcePermission ResourcePermission_RESET_CREDENTIALS_GRANT = ResourcePermissions.getInstanceWithGrantOption(ResourcePermissions.RESET_CREDENTIALS);
    private static final ResourcePermission ResourcePermission_DELETE = ResourcePermissions.getInstance(ResourcePermissions.DELETE);
    private static final ResourcePermission ResourcePermission_DELETE_GRANT = ResourcePermissions.getInstanceWithGrantOption(ResourcePermissions.DELETE);
    private static final ResourcePermission ResourcePermission_QUERY = ResourcePermissions.getInstance(ResourcePermissions.QUERY);
    private static final ResourcePermission ResourcePermission_QUERY_GRANT = ResourcePermissions.getInstanceWithGrantOption(ResourcePermissions.QUERY);
    private final ResourceClassPersister resourceClassPersister;
    private final ResourceClassPermissionPersister resourceClassPermissionPersister;
    private final DomainPersister domainPersister;
    private final GrantDomainCreatePermissionSysPersister grantDomainCreatePermissionSysPersister;
    private final GrantDomainCreatePermissionPostCreateSysPersister grantDomainCreatePermissionPostCreateSysPersister;
    private final GrantDomainPermissionSysPersister grantDomainPermissionSysPersister;
    private final ResourcePersister resourcePersister;
    private final GrantResourceCreatePermissionSysPersister grantResourceCreatePermissionSysPersister;
    private final GrantResourceCreatePermissionPostCreateSysPersister grantResourceCreatePermissionPostCreateSysPersister;
    private final GrantResourceCreatePermissionPostCreatePersister grantResourceCreatePermissionPostCreatePersister;
    private final GrantResourcePermissionSysPersister grantResourcePermissionSysPersister;
    private final GrantGlobalResourcePermissionSysPersister grantGlobalResourcePermissionSysPersister;
    private final GrantResourcePermissionPersister grantResourcePermissionPersister;
    private final GrantGlobalResourcePermissionPersister grantGlobalResourcePermissionPersister;

    public static AccessControlContext getAccessControlContext(Connection connection, String schemaName, SQLProfile sqlProfile, PasswordEncryptor passwordEncryptor) {
        SQLAccessControlContext.__assertConnectionSpecified(connection);
        return new SQLAccessControlContext(connection, schemaName, sqlProfile, passwordEncryptor);
    }

    public static AccessControlContext getAccessControlContext(DataSource dataSource, String schemaName, SQLProfile sqlProfile, PasswordEncryptor passwordEncryptor) {
        SQLAccessControlContext.__assertDataSourceSpecified(dataSource);
        return new SQLAccessControlContext(dataSource, schemaName, sqlProfile, passwordEncryptor);
    }

    public static AccessControlContext getAccessControlContext(Connection connection, String schemaName, SQLProfile sqlProfile, AuthenticationProvider authenticationProvider) {
        SQLAccessControlContext.__assertConnectionSpecified(connection);
        return new SQLAccessControlContext(connection, schemaName, sqlProfile, authenticationProvider);
    }

    public static AccessControlContext getAccessControlContext(DataSource dataSource, String schemaName, SQLProfile sqlProfile, AuthenticationProvider authenticationProvider) {
        SQLAccessControlContext.__assertDataSourceSpecified(dataSource);
        return new SQLAccessControlContext(dataSource, schemaName, sqlProfile, authenticationProvider);
    }

    public static void postDeserialize(AccessControlContext accessControlContext, Connection connection) {
        if (accessControlContext instanceof SQLAccessControlContext) {
            SQLAccessControlContext sqlAccessControlContext = (SQLAccessControlContext)accessControlContext;
            sqlAccessControlContext.__postDeserialize(connection);
        }
    }

    public static void postDeserialize(AccessControlContext accessControlContext, DataSource dataSource) {
        if (accessControlContext instanceof SQLAccessControlContext) {
            SQLAccessControlContext sqlAccessControlContext = (SQLAccessControlContext)accessControlContext;
            sqlAccessControlContext.__postDeserialize(dataSource);
        }
    }

    private SQLAccessControlContext(Connection connection, String schemaName, SQLProfile sqlProfile, PasswordEncryptor passwordEncryptor) {
        this(schemaName, sqlProfile);
        this.connection = connection;
        this.authenticationProvider = new SQLPasswordAuthenticationProvider(connection, schemaName, passwordEncryptor);
        this.hasDefaultAuthenticationProvider = true;
    }

    private SQLAccessControlContext(Connection connection, String schemaName, SQLProfile sqlProfile, AuthenticationProvider authenticationProvider) {
        this(schemaName, sqlProfile);
        this.connection = connection;
        this.authenticationProvider = authenticationProvider;
        this.hasDefaultAuthenticationProvider = false;
    }

    private SQLAccessControlContext(DataSource dataSource, String schemaName, SQLProfile sqlProfile, PasswordEncryptor passwordEncryptor) {
        this(schemaName, sqlProfile);
        this.dataSource = dataSource;
        this.authenticationProvider = new SQLPasswordAuthenticationProvider(dataSource, schemaName, passwordEncryptor);
        this.hasDefaultAuthenticationProvider = true;
    }

    private SQLAccessControlContext(DataSource dataSource, String schemaName, SQLProfile sqlProfile, AuthenticationProvider authenticationProvider) {
        this(schemaName, sqlProfile);
        this.dataSource = dataSource;
        this.authenticationProvider = authenticationProvider;
        this.hasDefaultAuthenticationProvider = false;
    }

    private SQLAccessControlContext(String schemaName, SQLProfile sqlProfile) {
        SchemaNameValidator.assertValid(schemaName);
        SQLStrings sqlStrings = SQLStrings.getSQLStrings(schemaName, sqlProfile);
        this.resourceClassPersister = new ResourceClassPersister(sqlProfile, sqlStrings);
        this.resourceClassPermissionPersister = new ResourceClassPermissionPersister(sqlProfile, sqlStrings);
        if (sqlProfile.isRecursiveCTEEnabled()) {
            this.grantDomainCreatePermissionSysPersister = new RecursiveGrantDomainCreatePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantDomainCreatePermissionPostCreateSysPersister = new RecursiveGrantDomainCreatePermissionPostCreateSysPersister(sqlProfile, sqlStrings);
            this.grantDomainPermissionSysPersister = new RecursiveGrantDomainPermissionSysPersister(sqlProfile, sqlStrings);
            this.domainPersister = new RecursiveDomainPersister(sqlProfile, sqlStrings);
            this.resourcePersister = new RecursiveResourcePersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionSysPersister = new RecursiveGrantResourceCreatePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionPostCreateSysPersister = new RecursiveGrantResourceCreatePermissionPostCreateSysPersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionPostCreatePersister = new RecursiveGrantResourceCreatePermissionPostCreatePersister(sqlProfile, sqlStrings);
            this.grantResourcePermissionSysPersister = new RecursiveGrantResourcePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantGlobalResourcePermissionSysPersister = new RecursiveGrantGlobalResourcePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantResourcePermissionPersister = new RecursiveGrantResourcePermissionPersister(sqlProfile, sqlStrings);
            this.grantGlobalResourcePermissionPersister = new RecursiveGrantGlobalResourcePermissionPersister(sqlProfile, sqlStrings);
        } else {
            this.grantDomainCreatePermissionSysPersister = new NonRecursiveGrantDomainCreatePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantDomainCreatePermissionPostCreateSysPersister = new NonRecursiveGrantDomainCreatePermissionPostCreateSysPersister(sqlProfile, sqlStrings);
            this.grantDomainPermissionSysPersister = new NonRecursiveGrantDomainPermissionSysPersister(sqlProfile, sqlStrings);
            this.domainPersister = new NonRecursiveDomainPersister(sqlProfile, sqlStrings);
            this.resourcePersister = new NonRecursiveResourcePersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionSysPersister = new NonRecursiveGrantResourceCreatePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionPostCreateSysPersister = new NonRecursiveGrantResourceCreatePermissionPostCreateSysPersister(sqlProfile, sqlStrings);
            this.grantResourceCreatePermissionPostCreatePersister = new NonRecursiveGrantResourceCreatePermissionPostCreatePersister(sqlProfile, sqlStrings);
            this.grantResourcePermissionSysPersister = new NonRecursiveGrantResourcePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantGlobalResourcePermissionSysPersister = new NonRecursiveGrantGlobalResourcePermissionSysPersister(sqlProfile, sqlStrings);
            this.grantResourcePermissionPersister = new NonRecursiveGrantResourcePermissionPersister(sqlProfile, sqlStrings);
            this.grantGlobalResourcePermissionPersister = new NonRecursiveGrantGlobalResourcePermissionPersister(sqlProfile, sqlStrings);
        }
    }

    private void __postDeserialize(DataSource dataSource) {
        if (this.dataSource != null || this.connection != null) {
            throw new IllegalStateException("Cannot re-initialize an already initialized SQLAccessControlContext");
        }
        this.dataSource = dataSource;
        this.connection = null;
        if (this.hasDefaultAuthenticationProvider) {
            ((SQLPasswordAuthenticationProvider)this.authenticationProvider).postDeserialize(dataSource);
        }
    }

    private void __postDeserialize(Connection connection) {
        if (this.dataSource != null || this.connection != null) {
            throw new IllegalStateException("Cannot re-initialize an already initialized SQLAccessControlContext");
        }
        this.dataSource = null;
        this.connection = connection;
        if (this.hasDefaultAuthenticationProvider) {
            ((SQLPasswordAuthenticationProvider)this.authenticationProvider).postDeserialize(connection);
        }
    }

    @Override
    public void authenticate(Resource resource, Credentials credentials) {
        this.__assertResourceSpecified(resource);
        this.__assertCredentialsSpecified(credentials);
        this.__authenticate(resource, credentials);
    }

    @Override
    public void authenticate(Credentials credentials) {
        this.__assertCredentialsSpecified(credentials);
        this.__authenticate(null, credentials);
    }

    @Override
    public void authenticate(Resource resource) {
        this.__assertResourceSpecified(resource);
        this.__authenticate(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __authenticate(Resource resource, Credentials credentials) {
        String resourceDomainForResource;
        boolean resourceSpecified;
        boolean bl = resourceSpecified = resource != null;
        if (!resourceSpecified && (resource = this.authenticationProvider.authenticate(credentials)) == null) {
            throw new IllegalStateException("No resource returned by the authentication provider when using only credentials to authenticate");
        }
        SQLConnection connection = null;
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, resource);
            if (!resourceClassInternalInfo.isAuthenticatable()) {
                throw new IllegalArgumentException("Resource " + resource + " is not of an authenticatable resource class: " + resourceClassInternalInfo.getResourceClassName());
            }
            resourceDomainForResource = this.domainPersister.getResourceDomainNameByResourceId(connection, resource);
        }
        finally {
            this.__closeConnection(connection);
        }
        if (resourceSpecified) {
            if (credentials != null) {
                this.authenticationProvider.authenticate(resource, credentials);
            } else {
                this.authenticationProvider.authenticate(resource);
            }
        }
        this.authenticatedResource = resource;
        this.defensiveCopyOfAuthenticatedResource = null;
        this.authenticatedResourceDomainName = resourceDomainForResource;
        this.sessionResource = this.authenticatedResource;
        this.defensiveCopyOfSessionResource = null;
        this.sessionResourceDomainName = this.authenticatedResourceDomainName;
    }

    @Override
    public void unauthenticate() {
        this.authenticatedResource = null;
        this.sessionResource = null;
        this.defensiveCopyOfAuthenticatedResource = null;
        this.defensiveCopyOfSessionResource = null;
        this.authenticatedResourceDomainName = null;
        this.sessionResourceDomainName = null;
    }

    @Override
    public void impersonate(Resource resource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(resource);
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            this.__assertImpersonatePermission(connection, resource);
            this.sessionResource = resource;
            this.defensiveCopyOfSessionResource = null;
            this.sessionResourceDomainName = this.domainPersister.getResourceDomainNameByResourceId(connection, resource);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __assertImpersonatePermission(SQLConnection connection, Resource resource) {
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, resource);
        if (!resourceClassInternalInfo.isAuthenticatable()) {
            throw new IllegalArgumentException("Resource " + resource + " is not of an authenticatable resource class: " + resourceClassInternalInfo.getResourceClassName());
        }
        boolean impersonatePermissionOK = false;
        Set<ResourcePermission> resourcePermissions = this.__getEffectiveResourcePermissions(connection, this.authenticatedResource, resource);
        if (resourcePermissions.contains(ResourcePermission_IMPERSONATE) || resourcePermissions.contains(ResourcePermission_IMPERSONATE_GRANT)) {
            impersonatePermissionOK = true;
        }
        if (!impersonatePermissionOK) {
            String domainName = this.domainPersister.getResourceDomainNameByResourceId(connection, resource);
            Set<ResourcePermission> globalResourcePermissions = this.__getEffectiveGlobalResourcePermissions(connection, this.authenticatedResource, resourceClassInternalInfo.getResourceClassName(), domainName);
            if (globalResourcePermissions.contains(ResourcePermission_IMPERSONATE) || globalResourcePermissions.contains(ResourcePermission_IMPERSONATE_GRANT)) {
                impersonatePermissionOK = true;
            }
        }
        if (!impersonatePermissionOK && this.__isSuperUserOfResource(connection, this.authenticatedResource, resource)) {
            impersonatePermissionOK = true;
        }
        if (!impersonatePermissionOK) {
            throw NotAuthorizedException.newInstanceForActionOnResource(this.authenticatedResource, "impersonate", resource);
        }
    }

    @Override
    public void unimpersonate() {
        this.sessionResource = this.authenticatedResource;
        this.defensiveCopyOfSessionResource = this.defensiveCopyOfAuthenticatedResource;
        this.sessionResourceDomainName = this.authenticatedResourceDomainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredentials(Resource resource, Credentials newCredentials) {
        String domainName;
        ResourceClassInternalInfo resourceClassInfo;
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(resource);
        if (!this.authenticatedResource.equals(this.sessionResource)) {
            throw new IllegalStateException("Calling setCredentials while impersonating another resource is not valid");
        }
        this.__assertCredentialsSpecified(newCredentials);
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            resourceClassInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, resource);
            if (!resourceClassInfo.isAuthenticatable()) {
                throw new IllegalArgumentException("Calling setCredentials for an unauthenticatable resource is not valid");
            }
            if (this.authenticatedResource.equals(resource)) {
                domainName = this.authenticatedResourceDomainName;
            } else {
                domainName = this.domainPersister.getResourceDomainNameByResourceId(connection, resource);
                this.__assertResetCredentialsResourcePermission(connection, resource, resourceClassInfo.getResourceClassName(), domainName);
            }
        }
        finally {
            this.__closeConnection(connection);
        }
        this.authenticationProvider.validateCredentials(resourceClassInfo.getResourceClassName(), domainName, newCredentials);
        this.authenticationProvider.setCredentials(resource, newCredentials);
    }

    private void __assertResetCredentialsResourcePermission(SQLConnection connection, Resource resource, String resourceClassName, String domainName) {
        Set<ResourcePermission> globalResourcePermissions;
        boolean hasResetCredentialsPermission = false;
        Set<ResourcePermission> resourcePermissions = this.__getEffectiveResourcePermissions(connection, this.authenticatedResource, resource);
        if (resourcePermissions.contains(ResourcePermission_RESET_CREDENTIALS) || resourcePermissions.contains(ResourcePermission_RESET_CREDENTIALS_GRANT)) {
            hasResetCredentialsPermission = true;
        }
        if (!hasResetCredentialsPermission && ((globalResourcePermissions = this.__getEffectiveGlobalResourcePermissions(connection, this.authenticatedResource, resourceClassName, domainName)).contains(ResourcePermission_RESET_CREDENTIALS) || globalResourcePermissions.contains(ResourcePermission_RESET_CREDENTIALS_GRANT))) {
            hasResetCredentialsPermission = true;
        }
        if (!hasResetCredentialsPermission && this.__isSuperUserOfResource(connection, this.authenticatedResource, resource)) {
            hasResetCredentialsPermission = true;
        }
        if (!hasResetCredentialsPermission) {
            throw NotAuthorizedException.newInstanceForActionOnResource(this.authenticatedResource, "reset credentials", resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createResourceClass(String resourceClassName, boolean authenticatable, boolean unauthenticatedCreateAllowed) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertAuthenticatedAsSystemResource();
        this.__assertResourceClassNameValid(resourceClassName);
        try {
            connection = this.__getConnection();
            resourceClassName = resourceClassName.trim();
            if (this.resourceClassPersister.getResourceClassId(connection, resourceClassName) != null) {
                throw new IllegalArgumentException("Duplicate resource class: " + resourceClassName);
            }
            this.resourceClassPersister.addResourceClass(connection, resourceClassName, authenticatable, unauthenticatedCreateAllowed);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createResourcePermission(String resourceClassName, String permissionName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertAuthenticatedAsSystemResource();
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertPermissionNameValid(permissionName);
        try {
            connection = this.__getConnection();
            resourceClassName = resourceClassName.trim();
            permissionName = permissionName.trim();
            Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
            if (resourceClassId == null) {
                throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
            }
            Id<ResourcePermissionId> permissionId = this.resourceClassPermissionPersister.getResourceClassPermissionId(connection, resourceClassId, permissionName);
            if (permissionId != null) {
                throw new IllegalArgumentException("Duplicate permission: " + permissionName + " for resource class: " + resourceClassName);
            }
            this.resourceClassPermissionPersister.addResourceClassPermission(connection, resourceClassId, permissionName);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    @Override
    public void createDomain(String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            domainName = domainName.trim();
            this.__createDomain(connection, domainName, null);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDomain(String domainName, String parentDomainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertDomainSpecified(domainName);
        this.__assertParentDomainSpecified(parentDomainName);
        try {
            connection = this.__getConnection();
            domainName = domainName.trim();
            parentDomainName = parentDomainName.trim();
            this.__createDomain(connection, domainName, parentDomainName);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __createDomain(SQLConnection connection, String domainName, String parentDomainName) {
        Set<DomainCreatePermission> domainCreatePermissions = this.grantDomainCreatePermissionSysPersister.getDomainCreateSysPermissionsIncludeInherited(connection, this.sessionResource);
        if (domainCreatePermissions.isEmpty()) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "create domain");
        }
        Set<DomainPermission> newDomainPermissions = this.__getPostCreateDomainPermissions(this.grantDomainCreatePermissionPostCreateSysPersister.getDomainCreatePostCreateSysPermissionsIncludeInherited(connection, this.sessionResource));
        if (this.domainPersister.getResourceDomainId(connection, domainName) != null) {
            throw new IllegalArgumentException("Duplicate domain: " + domainName);
        }
        if (parentDomainName == null) {
            this.domainPersister.addResourceDomain(connection, domainName);
        } else {
            Id<DomainId> parentDomainId = this.domainPersister.getResourceDomainId(connection, parentDomainName);
            if (parentDomainId == null) {
                throw new IllegalArgumentException("Parent domain: " + parentDomainName + " not found!");
            }
            Set<DomainPermission> parentDomainPermissions = this.__getEffectiveDomainPermissions(connection, this.sessionResource, parentDomainName);
            if (!(parentDomainPermissions.contains(DomainPermission_CREATE_CHILD_DOMAIN) || parentDomainPermissions.contains(DomainPermission_CREATE_CHILD_DOMAIN_GRANT) || parentDomainPermissions.contains(DomainPermission_SUPER_USER) || parentDomainPermissions.contains(DomainPermission_SUPER_USER_GRANT))) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "create child domain in domain: " + parentDomainName);
            }
            this.domainPersister.addResourceDomain(connection, domainName, parentDomainId);
        }
        if (newDomainPermissions.size() > 0) {
            this.__setDirectDomainPermissions(connection, this.sessionResource, domainName, newDomainPermissions, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDomain(String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            boolean bl = this.__deleteDomain(connection, domainName);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __deleteDomain(SQLConnection connection, String domainName) {
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            return false;
        }
        if (!this.__hasDomainPermissions(connection, this.sessionResource, domainName, Collections.singleton(DomainPermission_DELETE))) {
            throw NotAuthorizedException.newInstanceForDomainPermissions(this.sessionResource, domainName, DomainPermission_DELETE, new DomainPermission[0]);
        }
        if (!this.resourcePersister.isDomainEmpty(connection, domainId)) {
            throw new IllegalArgumentException("Deleting a domain (" + domainName + ") that contains resources directly or in a descendant domain is invalid");
        }
        this.grantDomainPermissionSysPersister.removeAllDomainSysPermissions(connection, domainId);
        this.grantResourceCreatePermissionPostCreatePersister.removeAllResourceCreatePostCreatePermissions(connection, domainId);
        this.grantResourceCreatePermissionPostCreateSysPersister.removeAllResourceCreatePostCreateSysPermissions(connection, domainId);
        this.grantResourceCreatePermissionSysPersister.removeAllResourceCreateSysPermissions(connection, domainId);
        this.grantGlobalResourcePermissionPersister.removeAllGlobalResourcePermissions(connection, domainId);
        this.grantGlobalResourcePermissionSysPersister.removeAllGlobalSysPermissions(connection, domainId);
        this.domainPersister.deleteDomain(connection, domainId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource createResource(String resourceClassName, String domainName) {
        SQLConnection connection = null;
        try {
            connection = this.__getConnection();
            Resource resource = this.__createResource(connection, resourceClassName, domainName, null, null);
            return resource;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource createResource(String resourceClassName, String domainName, Credentials credentials) {
        SQLConnection connection = null;
        this.__assertCredentialsSpecified(credentials);
        try {
            connection = this.__getConnection();
            Resource resource = this.__createResource(connection, resourceClassName, domainName, null, credentials);
            return resource;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource createResource(String resourceClassName, String domainName, String externalId) {
        SQLConnection connection = null;
        this.__assertExternalIdSpecified(externalId);
        try {
            connection = this.__getConnection();
            Resource resource = this.__createResource(connection, resourceClassName, domainName, externalId, null);
            return resource;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource createResource(String resourceClassName, String domainName, String externalId, Credentials credentials) {
        SQLConnection connection = null;
        this.__assertExternalIdSpecified(externalId);
        this.__assertCredentialsSpecified(credentials);
        try {
            connection = this.__getConnection();
            Resource resource = this.__createResource(connection, resourceClassName, domainName, externalId, credentials);
            return resource;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Resource __createResource(SQLConnection connection, String resourceClassName, String domainName, String externalId, Credentials credentials) {
        Set<Object> newResourcePermissions;
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        resourceClassName = resourceClassName.trim();
        ResourceClassInternalInfo resourceClassInternalInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        if (!resourceClassInternalInfo.isUnauthenticatedCreateAllowed()) {
            this.__assertAuthenticated();
        }
        if (resourceClassInternalInfo.isAuthenticatable()) {
            this.authenticationProvider.validateCredentials(resourceClassName, domainName, credentials);
        } else {
            this.__assertCredentialsNotSpecified(credentials);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (externalId != null && this.resourcePersister.resolveResourceByExternalId(connection, externalId) != null) {
            throw new IllegalArgumentException("External id is not unique: " + externalId);
        }
        if (this.sessionResource == null) {
            newResourcePermissions = new HashSet();
            for (String permissionName : this.resourceClassPermissionPersister.getPermissionNames(connection, resourceClassName)) {
                newResourcePermissions.add(ResourcePermissions.getInstanceWithGrantOption(permissionName));
            }
            newResourcePermissions.add(ResourcePermission_DELETE_GRANT);
            newResourcePermissions.add(ResourcePermission_QUERY_GRANT);
            if (resourceClassInternalInfo.isAuthenticatable()) {
                newResourcePermissions.add(ResourcePermission_RESET_CREDENTIALS_GRANT);
                newResourcePermissions.add(ResourcePermission_IMPERSONATE_GRANT);
            }
        } else {
            boolean createPermissionOK = false;
            Set<ResourceCreatePermission> resourceCreatePermissions = this.__getEffectiveResourceCreatePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName);
            newResourcePermissions = this.__getPostCreateResourcePermissions(resourceCreatePermissions);
            if (resourceCreatePermissions.size() > 0) {
                createPermissionOK = true;
            }
            if (!createPermissionOK) {
                createPermissionOK = this.__isSuperUserOfDomain(connection, this.sessionResource, domainName);
            }
            if (!createPermissionOK) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "create resource of resource class " + resourceClassName);
            }
        }
        Resource newResource = this.resourcePersister.createResource(connection, Id.from(resourceClassInternalInfo.getResourceClassId()), domainId, externalId);
        if (newResourcePermissions != null && newResourcePermissions.size() > 0) {
            if (this.sessionResource != null) {
                this.__setDirectResourcePermissions(connection, this.sessionResource, newResource, newResourcePermissions, this.sessionResource, true);
            } else {
                this.__setDirectResourcePermissions(connection, newResource, newResource, newResourcePermissions, newResource, true);
            }
        }
        if (credentials != null) {
            this.authenticationProvider.setCredentials(newResource, credentials);
        }
        return newResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource setExternalId(Resource resource, String externalId) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(resource);
        this.__assertExternalIdSpecified(externalId);
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            Resource resource2 = this.__setExternalId(connection, resource, externalId);
            return resource2;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Resource __setExternalId(SQLConnection connection, Resource resource, String externalId) {
        Resource resourceByExternalId = this.resourcePersister.resolveResourceByExternalId(connection, externalId);
        if (resourceByExternalId == null) {
            if (resource.getExternalId() != null) {
                throw new IllegalArgumentException("Could not reset the resource's external id to a different value");
            }
        } else {
            if (resource.getId().equals(resourceByExternalId.getId())) {
                return resource;
            }
            throw new IllegalArgumentException("External id is not unique: " + externalId);
        }
        Id<ResourceClassId> resourceClassId = Id.from(this.resourceClassPersister.getResourceClassInfoByResourceId(connection, resource).getResourceClassId());
        Id<DomainId> domainId = this.resourcePersister.getDomainIdByResource(connection, resource);
        Set<ResourceCreatePermission> resourceCreateSysPermissions = this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissionsIncludeInherited(connection, this.sessionResource, resourceClassId, domainId);
        boolean createPermissionOK = false;
        if (resourceCreateSysPermissions.size() > 0) {
            createPermissionOK = true;
        }
        if (!createPermissionOK) {
            createPermissionOK = this.__isSuperUserOfDomain(connection, this.sessionResource, domainId);
        }
        if (!createPermissionOK) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "set external id of resource " + resource);
        }
        return this.resourcePersister.setExternalId(connection, Id.from(resource.getId()), externalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteResource(Resource obsoleteResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(obsoleteResource);
        try {
            connection = this.__getConnection();
            boolean bl = this.__deleteResource(connection, obsoleteResource);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __deleteResource(SQLConnection connection, Resource obsoleteResource) {
        Set<ResourcePermission> sessionResourcePermissions;
        try {
            obsoleteResource = this.__resolveResource(connection, obsoleteResource);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().toLowerCase().contains("not found")) {
                return false;
            }
            throw e;
        }
        if (!(this.__isSuperUserOfResource(connection, this.sessionResource, obsoleteResource) || (sessionResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, obsoleteResource)).contains(ResourcePermission_DELETE) || sessionResourcePermissions.contains(ResourcePermission_DELETE_GRANT))) {
            throw NotAuthorizedException.newInstanceForActionOnResource(this.sessionResource, "delete", obsoleteResource);
        }
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, obsoleteResource);
        if (resourceClassInternalInfo.isAuthenticatable()) {
            this.authenticationProvider.deleteCredentials(obsoleteResource);
        }
        this.grantDomainCreatePermissionPostCreateSysPersister.removeDomainCreatePostCreateSysPermissions(connection, obsoleteResource);
        this.grantDomainCreatePermissionSysPersister.removeDomainCreateSysPermissions(connection, obsoleteResource);
        this.grantDomainPermissionSysPersister.removeAllDomainSysPermissions(connection, obsoleteResource);
        this.grantResourceCreatePermissionPostCreatePersister.removeAllResourceCreatePostCreatePermissions(connection, obsoleteResource);
        this.grantResourceCreatePermissionPostCreateSysPersister.removeAllResourceCreatePostCreateSysPermissions(connection, obsoleteResource);
        this.grantResourceCreatePermissionSysPersister.removeAllResourceCreateSysPermissions(connection, obsoleteResource);
        this.grantGlobalResourcePermissionPersister.removeAllGlobalResourcePermissions(connection, obsoleteResource);
        this.grantGlobalResourcePermissionSysPersister.removeAllGlobalSysPermissions(connection, obsoleteResource);
        this.grantResourcePermissionPersister.removeAllResourcePermissionsAsAccessorOrAccessed(connection, obsoleteResource);
        this.grantResourcePermissionSysPersister.removeAllResourceSysPermissionsAsAccessorOrAccessed(connection, obsoleteResource);
        this.resourcePersister.deleteResource(connection, obsoleteResource);
        if (this.authenticatedResource.equals(obsoleteResource)) {
            this.unauthenticate();
        } else if (this.sessionResource.equals(obsoleteResource)) {
            this.unimpersonate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> permissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(permissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(permissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__setDirectDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions, false);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __setDirectDomainPermissions(SQLConnection connection, Resource accessorResource, String domainName, Set<DomainPermission> requestedDomainPermissions, boolean newDomainMode) {
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (requestedDomainPermissions == null) {
            throw new IllegalArgumentException("Set of requested domain permissions may not be null");
        }
        if (!newDomainMode) {
            Set<DomainPermission> grantorPermissions = this.__getEffectiveDomainPermissions(connection, this.sessionResource, domainName);
            if (!grantorPermissions.contains(DomainPermission_SUPER_USER) && !grantorPermissions.contains(DomainPermission_SUPER_USER_GRANT)) {
                Set<DomainPermission> unauthorizedRemovePermissions;
                Set<DomainPermission> unauthorizedAddPermissions;
                Set<DomainPermission> directAccessorPermissions = this.__getDirectDomainPermissions(connection, accessorResource, domainId);
                Set<DomainPermission> requestedAddPermissions = this.__subtract(requestedDomainPermissions, directAccessorPermissions);
                if (!requestedAddPermissions.isEmpty() && (unauthorizedAddPermissions = this.__subtractDomainPermissionsIfGrantableFrom(requestedAddPermissions, grantorPermissions)).size() > 0) {
                    throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "add the following domain permission(s): " + unauthorizedAddPermissions);
                }
                Set<DomainPermission> requestedRemovePermissions = this.__subtract(directAccessorPermissions, requestedDomainPermissions);
                if (!requestedRemovePermissions.isEmpty() && (unauthorizedRemovePermissions = this.__subtractDomainPermissionsIfGrantableFrom(requestedRemovePermissions, grantorPermissions)).size() > 0) {
                    throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "remove the following domain permission(s): " + unauthorizedRemovePermissions);
                }
            }
            this.grantDomainPermissionSysPersister.removeDomainSysPermissions(connection, accessorResource, domainId);
        }
        this.grantDomainPermissionSysPersister.addDomainSysPermissions(connection, accessorResource, this.sessionResource, domainId, requestedDomainPermissions);
    }

    private Set<DomainPermission> __getDirectDomainPermissions(SQLConnection connection, Resource accessorResource, Id<DomainId> domainId) {
        return this.grantDomainPermissionSysPersister.getDomainSysPermissions(connection, accessorResource, domainId);
    }

    private Set<DomainPermission> __subtractDomainPermissionsIfGrantableFrom(Set<DomainPermission> candidatePermissionSet, Set<DomainPermission> grantorPermissionSet) {
        HashSet<DomainPermission> differenceSet = new HashSet<DomainPermission>(candidatePermissionSet);
        block0: for (DomainPermission candidatePermission : candidatePermissionSet) {
            for (DomainPermission grantorPermission : grantorPermissionSet) {
                if (!candidatePermission.isGrantableFrom(grantorPermission)) continue;
                differenceSet.remove(candidatePermission);
                continue block0;
            }
        }
        return differenceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(domainPermissions);
        this.__assertPermissionsSetNotEmpty(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(domainPermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDomainPermissions(Resource accessorResource, String domainName, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(domainPermission);
        this.__assertVarargPermissionsSpecified(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainPermission, domainPermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __grantDirectDomainPermissions(SQLConnection connection, Resource accessorResource, String domainName, Set<DomainPermission> requestedDomainPermissions) {
        Set<DomainPermission> unauthorizedPermissions;
        this.__assertUniqueDomainPermissionsNames(requestedDomainPermissions);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (requestedDomainPermissions == null) {
            throw new IllegalArgumentException("Set of requested domain permissions may not be null");
        }
        Set<DomainPermission> grantorPermissions = this.__getEffectiveDomainPermissions(connection, this.sessionResource, domainName);
        if (!grantorPermissions.contains(DomainPermission_SUPER_USER) && !grantorPermissions.contains(DomainPermission_SUPER_USER_GRANT) && (unauthorizedPermissions = this.__subtractDomainPermissionsIfGrantableFrom(requestedDomainPermissions, grantorPermissions)).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "grant the following domain permission(s): " + unauthorizedPermissions);
        }
        Set<DomainPermission> directAccessorPermissions = this.__getDirectDomainPermissions(connection, accessorResource, domainId);
        HashSet<DomainPermission> addPermissions = new HashSet<DomainPermission>(requestedDomainPermissions.size());
        HashSet<DomainPermission> updatePermissions = new HashSet<DomainPermission>(requestedDomainPermissions.size());
        for (DomainPermission requestedPermission : requestedDomainPermissions) {
            boolean existingPermission = false;
            for (DomainPermission existingDirectPermission : directAccessorPermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                if (!requestedPermission.equals(existingDirectPermission) && !requestedPermission.isGrantableFrom(existingDirectPermission)) {
                    updatePermissions.add(requestedPermission);
                }
                existingPermission = true;
                break;
            }
            if (existingPermission) continue;
            addPermissions.add(requestedPermission);
        }
        this.grantDomainPermissionSysPersister.updateDomainSysPermissions(connection, accessorResource, this.sessionResource, domainId, updatePermissions);
        this.grantDomainPermissionSysPersister.addDomainSysPermissions(connection, accessorResource, this.sessionResource, domainId, addPermissions);
    }

    private void __assertUniqueDomainPermissionsNames(Set<DomainPermission> domainPermissions) {
        HashSet<String> uniquePermissionNames = new HashSet<String>(domainPermissions.size());
        for (DomainPermission domainPermissionPermission : domainPermissions) {
            if (uniquePermissionNames.contains(domainPermissionPermission.getPermissionName())) {
                throw new IllegalArgumentException("Duplicate permission: " + domainPermissionPermission.getPermissionName() + " that only differs in 'withGrant' option");
            }
            uniquePermissionNames.add(domainPermissionPermission.getPermissionName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(domainPermissions);
        this.__assertPermissionsSetNotEmpty(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(domainPermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDomainPermissions(Resource accessorResource, String domainName, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(domainPermission);
        this.__assertVarargPermissionsSpecified(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainPermission, domainPermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __revokeDirectDomainPermissions(SQLConnection connection, Resource accessorResource, String domainName, Set<DomainPermission> requestedDomainPermissions) {
        Set<DomainPermission> unauthorizedPermissions;
        this.__assertUniqueDomainPermissionsNames(requestedDomainPermissions);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (requestedDomainPermissions == null) {
            throw new IllegalArgumentException("Set of requested domain permissions to be revoked may not be null");
        }
        Set<DomainPermission> grantorPermissions = this.__getEffectiveDomainPermissions(connection, this.sessionResource, domainName);
        if (!grantorPermissions.contains(DomainPermission_SUPER_USER) && !grantorPermissions.contains(DomainPermission_SUPER_USER_GRANT) && (unauthorizedPermissions = this.__subtractDomainPermissionsIfGrantableFrom(requestedDomainPermissions, grantorPermissions)).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "revoke the following domain permission(s): " + unauthorizedPermissions);
        }
        Set<DomainPermission> directAccessorPermissions = this.__getDirectDomainPermissions(connection, accessorResource, domainId);
        HashSet<DomainPermission> removePermissions = new HashSet<DomainPermission>(requestedDomainPermissions.size());
        block0: for (DomainPermission requestedPermission : requestedDomainPermissions) {
            for (DomainPermission existingDirectPermission : directAccessorPermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                removePermissions.add(requestedPermission);
                continue block0;
            }
        }
        this.grantDomainPermissionSysPersister.removeDomainSysPermissions(connection, accessorResource, domainId, removePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DomainPermission> getDomainPermissions(Resource accessorResource, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
            if (domainId == null) {
                throw new IllegalArgumentException("Could not find domain: " + domainName);
            }
            Set<DomainPermission> set = this.__getDirectDomainPermissions(connection, accessorResource, domainId);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<DomainPermission>> getDomainPermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Set<DomainPermission>> map = this.__collapseDomainPermissions(this.grantDomainPermissionSysPersister.getDomainSysPermissions(connection, accessorResource));
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DomainPermission> getEffectiveDomainPermissions(Resource accessorResource, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Set<DomainPermission> set = this.__getEffectiveDomainPermissions(connection, accessorResource, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<DomainPermission> __getEffectiveDomainPermissions(SQLConnection connection, Resource accessorResource, String domainName) {
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        return this.__getEffectiveDomainPermissions(connection, accessorResource, domainId);
    }

    private Set<DomainPermission> __getEffectiveDomainPermissions(SQLConnection connection, Resource accessorResource, Id<DomainId> domainId) {
        Set<DomainPermission> domainSysPermissionsIncludingInherited = this.grantDomainPermissionSysPersister.getDomainSysPermissionsIncludeInherited(connection, accessorResource, domainId);
        for (DomainPermission permission : domainSysPermissionsIncludingInherited) {
            if (!DomainPermissions.SUPER_USER.equals(permission.getPermissionName())) continue;
            return SQLAccessControlContext.__getApplicableDomainPermissions();
        }
        return this.__collapseDomainPermissions(domainSysPermissionsIncludingInherited);
    }

    private Set<DomainPermission> __collapseDomainPermissions(Set<DomainPermission> domainPermissions) {
        HashSet<DomainPermission> collapsedPermissions = new HashSet<DomainPermission>(domainPermissions);
        block0: for (DomainPermission permission : domainPermissions) {
            for (DomainPermission grantEquivalentPermission : domainPermissions) {
                if (!permission.isGrantableFrom(grantEquivalentPermission) || permission.equals(grantEquivalentPermission)) continue;
                collapsedPermissions.remove(permission);
                continue block0;
            }
        }
        return collapsedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<DomainPermission>> getEffectiveDomainPermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Set<DomainPermission>> map = this.__getEffectiveDomainPermissionsMap(connection, accessorResource);
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Map<String, Set<DomainPermission>> __getEffectiveDomainPermissionsMap(SQLConnection connection, Resource accessorResource) {
        Map<String, Set<DomainPermission>> domainSysPermissionsIncludingInherited = this.grantDomainPermissionSysPersister.getDomainSysPermissionsIncludeInherited(connection, accessorResource);
        for (Map.Entry<String, Set<DomainPermission>> domainPermissionsByDomainEntry : domainSysPermissionsIncludingInherited.entrySet()) {
            Set<DomainPermission> domainPermissions = domainPermissionsByDomainEntry.getValue();
            if (!domainPermissions.contains(DomainPermission_SUPER_USER) && !domainPermissions.contains(DomainPermission_SUPER_USER_GRANT)) continue;
            domainSysPermissionsIncludingInherited.put(domainPermissionsByDomainEntry.getKey(), SQLAccessControlContext.__getApplicableDomainPermissions());
        }
        return this.__collapseDomainPermissions(domainSysPermissionsIncludingInherited);
    }

    private static Set<DomainPermission> __getApplicableDomainPermissions() {
        HashSet<DomainPermission> superDomainPermissions = new HashSet<DomainPermission>(3);
        superDomainPermissions.add(DomainPermission_SUPER_USER_GRANT);
        superDomainPermissions.add(DomainPermission_CREATE_CHILD_DOMAIN_GRANT);
        superDomainPermissions.add(DomainPermission_DELETE_GRANT);
        return superDomainPermissions;
    }

    private Map<String, Set<DomainPermission>> __collapseDomainPermissions(Map<String, Set<DomainPermission>> domainPermissionsMap) {
        HashMap<String, Set<DomainPermission>> collapsedDomainPermissionsMap = new HashMap<String, Set<DomainPermission>>(domainPermissionsMap.size());
        for (Map.Entry<String, Set<DomainPermission>> domainPermissionsByDomainEntry : domainPermissionsMap.entrySet()) {
            collapsedDomainPermissionsMap.put(domainPermissionsByDomainEntry.getKey(), this.__collapseDomainPermissions(domainPermissionsByDomainEntry.getValue()));
        }
        return collapsedDomainPermissionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionsSpecified(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(domainCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__setDirectDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __setDirectDomainCreatePermissions(SQLConnection connection, Resource accessorResource, Set<DomainCreatePermission> requestedDomainCreatePermissions) {
        Set<DomainCreatePermission> unauthorizedRemovePermissions;
        Set<DomainCreatePermission> unauthorizedAddPermissions;
        this.__assertSetContainsDomainCreateSystemPermission(requestedDomainCreatePermissions);
        this.__assertUniqueSystemOrPostCreateDomainPermissionNames(requestedDomainCreatePermissions);
        Set<DomainCreatePermission> grantorPermissions = this.__getEffectiveDomainCreatePermissions(connection, this.sessionResource);
        Set<DomainCreatePermission> directAccessorPermissions = this.__getDirectDomainCreatePermissions(connection, accessorResource);
        Set<DomainCreatePermission> requestedAddPermissions = this.__subtract(requestedDomainCreatePermissions, directAccessorPermissions);
        if (!requestedAddPermissions.isEmpty() && (unauthorizedAddPermissions = this.__subtractDomainCreatePermissionsIfGrantableFrom(requestedAddPermissions, grantorPermissions)).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "add the following domain create permission(s): " + unauthorizedAddPermissions);
        }
        Set<DomainCreatePermission> requestedRemovePermissions = this.__subtract(directAccessorPermissions, requestedDomainCreatePermissions);
        if (!requestedRemovePermissions.isEmpty() && (unauthorizedRemovePermissions = this.__subtractDomainCreatePermissionsIfGrantableFrom(requestedRemovePermissions, grantorPermissions)).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "remove the following domain create permission(s): " + unauthorizedRemovePermissions);
        }
        this.grantDomainCreatePermissionSysPersister.removeDomainCreateSysPermissions(connection, accessorResource);
        this.grantDomainCreatePermissionPostCreateSysPersister.removeDomainCreatePostCreateSysPermissions(connection, accessorResource);
        this.grantDomainCreatePermissionSysPersister.addDomainCreateSysPermissions(connection, accessorResource, this.sessionResource, requestedDomainCreatePermissions);
        this.grantDomainCreatePermissionPostCreateSysPersister.addDomainCreatePostCreateSysPermissions(connection, accessorResource, this.sessionResource, requestedDomainCreatePermissions);
    }

    private void __assertSetContainsDomainCreateSystemPermission(Set<DomainCreatePermission> domainCreatePermissions) {
        if (!domainCreatePermissions.isEmpty() && !this.__setContainsDomainCreateSystemPermission(domainCreatePermissions)) {
            throw new IllegalArgumentException("Domain create permission *CREATE must be specified");
        }
    }

    private boolean __setContainsDomainCreateSystemPermission(Set<DomainCreatePermission> domainCreatePermissions) {
        for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
            if (!domainCreatePermission.isSystemPermission() || !DomainCreatePermissions.CREATE.equals(domainCreatePermission.getPermissionName())) continue;
            return true;
        }
        return false;
    }

    private Set<DomainCreatePermission> __getDirectDomainCreatePermissions(SQLConnection connection, Resource accessorResource) {
        HashSet<DomainCreatePermission> domainCreatePermissions = new HashSet<DomainCreatePermission>();
        domainCreatePermissions.addAll(this.grantDomainCreatePermissionSysPersister.getDomainCreateSysPermissions(connection, accessorResource));
        domainCreatePermissions.addAll(this.grantDomainCreatePermissionPostCreateSysPersister.getDomainCreatePostCreateSysPermissions(connection, accessorResource));
        return domainCreatePermissions;
    }

    private Set<DomainCreatePermission> __subtractDomainCreatePermissionsIfGrantableFrom(Set<DomainCreatePermission> candidatePermissionSet, Set<DomainCreatePermission> grantorPermissionSet) {
        HashSet<DomainCreatePermission> differenceSet = new HashSet<DomainCreatePermission>(candidatePermissionSet);
        block0: for (DomainCreatePermission candidatePermission : candidatePermissionSet) {
            for (DomainCreatePermission grantorPermission : grantorPermissionSet) {
                if (!candidatePermission.isGrantableFrom(grantorPermission)) continue;
                differenceSet.remove(candidatePermission);
                continue block0;
            }
        }
        return differenceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionsSpecified(domainCreatePermissions);
        this.__assertPermissionsSetNotEmpty(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(domainCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDomainCreatePermissions(Resource accessorResource, DomainCreatePermission domainCreatePermission, DomainCreatePermission ... domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionSpecified(domainCreatePermission);
        this.__assertVarargPermissionsSpecified(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainCreatePermission, domainCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __grantDirectDomainCreatePermissions(SQLConnection connection, Resource accessorResource, Set<DomainCreatePermission> requestedDomainCreatePermissions) {
        this.__assertUniqueSystemOrPostCreateDomainPermissionNames(requestedDomainCreatePermissions);
        Set<DomainCreatePermission> grantorPermissions = this.__getEffectiveDomainCreatePermissions(connection, this.sessionResource);
        Set<DomainCreatePermission> unauthorizedPermissions = this.__subtractDomainCreatePermissionsIfGrantableFrom(requestedDomainCreatePermissions, grantorPermissions);
        if (unauthorizedPermissions.size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "grant the following domain create permission(s): " + unauthorizedPermissions);
        }
        Set<DomainCreatePermission> directAccessorPermissions = this.__getDirectDomainCreatePermissions(connection, accessorResource);
        if (directAccessorPermissions.isEmpty()) {
            this.__assertSetContainsDomainCreateSystemPermission(requestedDomainCreatePermissions);
        }
        HashSet<DomainCreatePermission> addPermissions = new HashSet<DomainCreatePermission>(requestedDomainCreatePermissions.size());
        HashSet<DomainCreatePermission> updatePermissions = new HashSet<DomainCreatePermission>(requestedDomainCreatePermissions.size());
        for (DomainCreatePermission requestedPermission : requestedDomainCreatePermissions) {
            boolean existingPermission = false;
            if (requestedPermission.isSystemPermission()) {
                for (DomainCreatePermission existingDirectPermission : directAccessorPermissions) {
                    if (!existingDirectPermission.isSystemPermission() || requestedPermission.getSystemPermissionId() != existingDirectPermission.getSystemPermissionId()) continue;
                    if (!requestedPermission.equals(existingDirectPermission) && !requestedPermission.isGrantableFrom(existingDirectPermission)) {
                        updatePermissions.add(requestedPermission);
                    }
                    existingPermission = true;
                    break;
                }
            } else {
                DomainPermission requestedPostCreateDomainPermission = requestedPermission.getPostCreateDomainPermission();
                for (DomainCreatePermission existingDirectPermission : directAccessorPermissions) {
                    DomainPermission existingPostCreateDomainPermission;
                    if (existingDirectPermission.isSystemPermission() || !requestedPostCreateDomainPermission.equalsIgnoreGrantOption(existingPostCreateDomainPermission = existingDirectPermission.getPostCreateDomainPermission())) continue;
                    if (requestedPermission.isWithGrantOption() != requestedPostCreateDomainPermission.isWithGrantOption() && existingDirectPermission.isWithGrantOption() != existingPostCreateDomainPermission.isWithGrantOption() && requestedPermission.isWithGrantOption() != existingDirectPermission.isWithGrantOption()) {
                        throw new IllegalArgumentException("Requested create permissions " + requestedDomainCreatePermissions + " are incompatible with existing create permissions " + directAccessorPermissions);
                    }
                    if (!requestedPermission.equals(existingDirectPermission) && (requestedPermission.isWithGrantOption() && requestedPostCreateDomainPermission.isWithGrantOption() || !existingDirectPermission.isWithGrantOption() && !existingPostCreateDomainPermission.isWithGrantOption())) {
                        updatePermissions.add(requestedPermission);
                    }
                    existingPermission = true;
                    break;
                }
            }
            if (existingPermission) continue;
            addPermissions.add(requestedPermission);
        }
        this.grantDomainCreatePermissionSysPersister.updateDomainCreateSysPermissions(connection, accessorResource, this.sessionResource, updatePermissions);
        this.grantDomainCreatePermissionPostCreateSysPersister.updateDomainCreatePostCreateSysPermissions(connection, accessorResource, this.sessionResource, updatePermissions);
        this.grantDomainCreatePermissionSysPersister.addDomainCreateSysPermissions(connection, accessorResource, this.sessionResource, addPermissions);
        this.grantDomainCreatePermissionPostCreateSysPersister.addDomainCreatePostCreateSysPermissions(connection, accessorResource, this.sessionResource, addPermissions);
    }

    private void __assertUniqueSystemOrPostCreateDomainPermissionNames(Set<DomainCreatePermission> domainCreatePermissions) {
        HashSet<String> uniqueSystemPermissionNames = new HashSet<String>(domainCreatePermissions.size());
        HashSet<String> uniquePostCreatePermissionNames = new HashSet<String>(domainCreatePermissions.size());
        for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
            if (domainCreatePermission.isSystemPermission()) {
                if (uniqueSystemPermissionNames.contains(domainCreatePermission.getPermissionName())) {
                    throw new IllegalArgumentException("Duplicate permission: " + domainCreatePermission.getPermissionName() + " that only differs in 'withGrant' option");
                }
                uniqueSystemPermissionNames.add(domainCreatePermission.getPermissionName());
                continue;
            }
            DomainPermission postCreateDomainPermission = domainCreatePermission.getPostCreateDomainPermission();
            if (uniquePostCreatePermissionNames.contains(postCreateDomainPermission.getPermissionName())) {
                throw new IllegalArgumentException("Duplicate permission: " + postCreateDomainPermission.getPermissionName() + " that only differs in 'withGrant' option");
            }
            uniquePostCreatePermissionNames.add(postCreateDomainPermission.getPermissionName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionsSpecified(domainCreatePermissions);
        this.__assertPermissionsSetNotEmpty(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(domainCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeDomainCreatePermissions(Resource accessorResource, DomainCreatePermission domainCreatePermission, DomainCreatePermission ... domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionSpecified(domainCreatePermission);
        this.__assertVarargPermissionsSpecified(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainCreatePermission, domainCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __revokeDirectDomainCreatePermissions(SQLConnection connection, Resource accessorResource, Set<DomainCreatePermission> requestedDomainCreatePermissions) {
        this.__assertUniqueSystemOrPostCreateDomainPermissionNames(requestedDomainCreatePermissions);
        Set<DomainCreatePermission> grantorPermissions = this.__getEffectiveDomainCreatePermissions(connection, this.sessionResource);
        Set<DomainCreatePermission> unauthorizedPermissions = this.__subtractDomainCreatePermissionsIfGrantableFrom(requestedDomainCreatePermissions, grantorPermissions);
        if (unauthorizedPermissions.size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "revoke the following domain create permission(s): " + unauthorizedPermissions);
        }
        Set<DomainCreatePermission> directAccessorPermissions = this.__getDirectDomainCreatePermissions(connection, accessorResource);
        if (directAccessorPermissions.size() > requestedDomainCreatePermissions.size() && this.__setContainsDomainCreateSystemPermission(requestedDomainCreatePermissions)) {
            throw new IllegalArgumentException("Attempt to revoke a subset of domain create permissions that includes the *CREATE system permission: " + requestedDomainCreatePermissions);
        }
        HashSet<DomainCreatePermission> removePermissions = new HashSet<DomainCreatePermission>(requestedDomainCreatePermissions.size());
        block0: for (DomainCreatePermission requestedPermission : requestedDomainCreatePermissions) {
            if (requestedPermission.isSystemPermission()) {
                for (DomainCreatePermission existingDirectPermission : directAccessorPermissions) {
                    if (!existingDirectPermission.isSystemPermission() || requestedPermission.getSystemPermissionId() != existingDirectPermission.getSystemPermissionId()) continue;
                    removePermissions.add(requestedPermission);
                    continue block0;
                }
                continue;
            }
            DomainPermission requestedPostCreateDomainPermission = requestedPermission.getPostCreateDomainPermission();
            for (DomainCreatePermission existingDirectPermission : directAccessorPermissions) {
                if (existingDirectPermission.isSystemPermission() || !requestedPostCreateDomainPermission.equalsIgnoreGrantOption(existingDirectPermission.getPostCreateDomainPermission())) continue;
                removePermissions.add(requestedPermission);
                continue block0;
            }
        }
        this.grantDomainCreatePermissionSysPersister.removeDomainCreateSysPermissions(connection, accessorResource, removePermissions);
        this.grantDomainCreatePermissionPostCreateSysPersister.removeDomainCreatePostCreateSysPermissions(connection, accessorResource, removePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DomainCreatePermission> getDomainCreatePermissions(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Set<DomainCreatePermission> set = this.__getDirectDomainCreatePermissions(connection, accessorResource);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DomainCreatePermission> getEffectiveDomainCreatePermissions(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Set<DomainCreatePermission> set = this.__getEffectiveDomainCreatePermissions(connection, accessorResource);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<DomainCreatePermission> __getEffectiveDomainCreatePermissions(SQLConnection connection, Resource accessorResource) {
        HashSet<DomainCreatePermission> domainCreatePermissions = new HashSet<DomainCreatePermission>();
        domainCreatePermissions.addAll(this.grantDomainCreatePermissionSysPersister.getDomainCreateSysPermissionsIncludeInherited(connection, accessorResource));
        domainCreatePermissions.addAll(this.grantDomainCreatePermissionPostCreateSysPersister.getDomainCreatePostCreateSysPermissionsIncludeInherited(connection, accessorResource));
        return this.__collapseDomainCreatePermissions(domainCreatePermissions);
    }

    private Set<DomainCreatePermission> __collapseDomainCreatePermissions(Set<DomainCreatePermission> domainCreatePermissions) {
        HashSet<DomainCreatePermission> collapsedPermissions = new HashSet<DomainCreatePermission>(domainCreatePermissions);
        block0: for (DomainCreatePermission permission : domainCreatePermissions) {
            for (DomainCreatePermission grantEquivalentPermission : domainCreatePermissions) {
                if (!permission.isGrantableFrom(grantEquivalentPermission) || permission.equals(grantEquivalentPermission)) continue;
                collapsedPermissions.remove(permission);
                continue block0;
            }
        }
        return collapsedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(resourceCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__setDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __setDirectResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> requestedResourceCreatePermissions) {
        ResourceClassInternalInfo resourceClassInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<ResourceClassId> resourceClassId = Id.from(resourceClassInfo.getResourceClassId());
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertSetContainsResourceCreateSystemPermission(requestedResourceCreatePermissions);
        this.__assertUniquePostCreatePermissionsNamesForResourceClass(connection, requestedResourceCreatePermissions, resourceClassInfo);
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName)) {
            Set<ResourceCreatePermission> unauthorizedRemovePermissions;
            Set<ResourceCreatePermission> unauthorizedAddPermissions;
            Set<ResourceCreatePermission> grantorPermissions = this.__getEffectiveResourceCreatePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName);
            Set<ResourceCreatePermission> directAccessorPermissions = this.__getDirectResourceCreatePermissions(connection, accessorResource, resourceClassId, domainId);
            Set<ResourceCreatePermission> requestedAddPermissions = this.__subtract(requestedResourceCreatePermissions, directAccessorPermissions);
            if (!requestedAddPermissions.isEmpty() && (unauthorizedAddPermissions = this.__subtractResourceCreatePermissionsIfGrantableFrom(requestedAddPermissions, grantorPermissions)).size() > 0) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "add the following permission(s): " + unauthorizedAddPermissions);
            }
            Set<ResourceCreatePermission> requestedRemovePermissions = this.__subtract(directAccessorPermissions, requestedResourceCreatePermissions);
            if (!requestedRemovePermissions.isEmpty() && (unauthorizedRemovePermissions = this.__subtractResourceCreatePermissionsIfGrantableFrom(requestedRemovePermissions, grantorPermissions)).size() > 0) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "remove the following permission(s): " + unauthorizedRemovePermissions);
            }
        }
        this.grantResourceCreatePermissionSysPersister.removeResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId);
        this.grantResourceCreatePermissionPostCreateSysPersister.removeResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId);
        this.grantResourceCreatePermissionPostCreatePersister.removeResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId);
        this.grantResourceCreatePermissionSysPersister.addResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, requestedResourceCreatePermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreateSysPersister.addResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, requestedResourceCreatePermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreatePersister.addResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId, requestedResourceCreatePermissions, this.sessionResource);
    }

    private void __assertSetContainsResourceCreateSystemPermission(Set<ResourceCreatePermission> resourceCreatePermissions) {
        if (!resourceCreatePermissions.isEmpty()) {
            boolean createSysPermissionFound = false;
            for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
                if (!resourceCreatePermission.isSystemPermission() || !ResourceCreatePermissions.CREATE.equals(resourceCreatePermission.getPermissionName())) continue;
                createSysPermissionFound = true;
                break;
            }
            if (!createSysPermissionFound) {
                throw new IllegalArgumentException("Permission: *CREATE must be specified");
            }
        }
    }

    private void __assertUniquePostCreatePermissionsNamesForResourceClass(SQLConnection connection, Set<ResourceCreatePermission> resourceCreatePermissions, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> validPermissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassInternalInfo);
        HashSet<String> uniqueSystemPermissionNames = new HashSet<String>(resourceCreatePermissions.size());
        HashSet<String> uniquePostCreatePermissionNames = new HashSet<String>(resourceCreatePermissions.size());
        for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
            if (resourceCreatePermission.isSystemPermission()) {
                if (uniqueSystemPermissionNames.contains(resourceCreatePermission.getPermissionName())) {
                    throw new IllegalArgumentException("Duplicate permission: " + resourceCreatePermission.getPermissionName() + " that only differs in 'withGrant' option");
                }
                uniqueSystemPermissionNames.add(resourceCreatePermission.getPermissionName());
                continue;
            }
            ResourcePermission postCreateResourcePermission = resourceCreatePermission.getPostCreateResourcePermission();
            if (!validPermissionNames.contains(postCreateResourcePermission.getPermissionName())) {
                if (postCreateResourcePermission.isSystemPermission()) {
                    throw new IllegalArgumentException("Permission: " + postCreateResourcePermission.getPermissionName() + ", not valid for unauthenticatable resource");
                }
                throw new IllegalArgumentException("Permission: " + postCreateResourcePermission.getPermissionName() + " is not defined for resource class: " + resourceClassInternalInfo.getResourceClassName());
            }
            if (uniquePostCreatePermissionNames.contains(postCreateResourcePermission.getPermissionName())) {
                throw new IllegalArgumentException("Duplicate permission: " + postCreateResourcePermission.getPermissionName() + " that only differs in 'withGrant' option");
            }
            uniquePostCreatePermissionNames.add(postCreateResourcePermission.getPermissionName());
        }
    }

    private Set<ResourceCreatePermission> __subtractResourceCreatePermissionsIfGrantableFrom(Set<ResourceCreatePermission> candidatePermissionSet, Set<ResourceCreatePermission> grantorPermissionSet) {
        HashSet<ResourceCreatePermission> differenceSet = new HashSet<ResourceCreatePermission>(candidatePermissionSet);
        block0: for (ResourceCreatePermission candidatePermission : candidatePermissionSet) {
            for (ResourceCreatePermission grantorPermission : grantorPermissionSet) {
                if (!candidatePermission.isGrantableFrom(grantorPermission)) continue;
                differenceSet.remove(candidatePermission);
                continue block0;
            }
        }
        return differenceSet;
    }

    private <T> Set<T> __subtract(Set<T> minuendSet, Set<T> subtrahendSet) {
        HashSet<T> differenceSet = new HashSet<T>(minuendSet);
        differenceSet.removeAll(subtrahendSet);
        return differenceSet;
    }

    private Set<ResourceCreatePermission> __getDirectResourceCreatePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> domainId) {
        HashSet<ResourceCreatePermission> resourceCreatePermissions = new HashSet<ResourceCreatePermission>();
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreateSysPersister.getResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreatePersister.getResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId));
        return resourceCreatePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourceCreatePermissions);
        this.__assertPermissionsSetNotEmpty(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(resourceCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourceCreatePermission resourceCreatePermission, ResourceCreatePermission ... resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourceCreatePermission);
        this.__assertVarargPermissionsSpecified(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourceCreatePermission, resourceCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__grantDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __grantDirectResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> requestedResourceCreatePermissions) {
        Set<ResourceCreatePermission> grantorPermissions;
        Set<ResourceCreatePermission> unauthorizedAddPermissions;
        ResourceClassInternalInfo resourceClassInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<ResourceClassId> resourceClassId = Id.from(resourceClassInfo.getResourceClassId());
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertUniquePostCreatePermissionsNamesForResourceClass(connection, requestedResourceCreatePermissions, resourceClassInfo);
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName) && (unauthorizedAddPermissions = this.__subtractResourceCreatePermissionsIfGrantableFrom(requestedResourceCreatePermissions, grantorPermissions = this.__getEffectiveResourceCreatePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "grant the following permission(s): " + unauthorizedAddPermissions);
        }
        Set<ResourceCreatePermission> directAccessorPermissions = this.__getDirectResourceCreatePermissions(connection, accessorResource, resourceClassId, domainId);
        if (directAccessorPermissions.isEmpty()) {
            this.__assertSetContainsResourceCreateSystemPermission(requestedResourceCreatePermissions);
        }
        HashSet<ResourceCreatePermission> addPermissions = new HashSet<ResourceCreatePermission>(requestedResourceCreatePermissions.size());
        HashSet<ResourceCreatePermission> updatePermissions = new HashSet<ResourceCreatePermission>(requestedResourceCreatePermissions.size());
        for (ResourceCreatePermission requestedPermission : requestedResourceCreatePermissions) {
            boolean existingPermission = false;
            if (requestedPermission.isSystemPermission()) {
                for (ResourceCreatePermission existingDirectPermission : directAccessorPermissions) {
                    if (!existingDirectPermission.isSystemPermission() || requestedPermission.getSystemPermissionId() != existingDirectPermission.getSystemPermissionId()) continue;
                    if (!requestedPermission.equals(existingDirectPermission) && !requestedPermission.isGrantableFrom(existingDirectPermission)) {
                        updatePermissions.add(requestedPermission);
                    }
                    existingPermission = true;
                    break;
                }
            } else {
                ResourcePermission requestedPostCreateResourcePermission = requestedPermission.getPostCreateResourcePermission();
                for (ResourceCreatePermission existingDirectPermission : directAccessorPermissions) {
                    ResourcePermission existingPostCreateResourcePermission;
                    if (existingDirectPermission.isSystemPermission() || !requestedPostCreateResourcePermission.equalsIgnoreGrantOption(existingPostCreateResourcePermission = existingDirectPermission.getPostCreateResourcePermission())) continue;
                    if (requestedPermission.isWithGrantOption() != requestedPostCreateResourcePermission.isWithGrantOption() && existingDirectPermission.isWithGrantOption() != existingPostCreateResourcePermission.isWithGrantOption() && requestedPermission.isWithGrantOption() != existingDirectPermission.isWithGrantOption()) {
                        throw new IllegalArgumentException("Requested create permissions " + requestedResourceCreatePermissions + " are incompatible with existing create permissions " + directAccessorPermissions);
                    }
                    if (!requestedPermission.equals(existingDirectPermission) && (requestedPermission.isWithGrantOption() && requestedPostCreateResourcePermission.isWithGrantOption() || !existingDirectPermission.isWithGrantOption() && !existingPostCreateResourcePermission.isWithGrantOption())) {
                        updatePermissions.add(requestedPermission);
                    }
                    existingPermission = true;
                    break;
                }
            }
            if (existingPermission) continue;
            addPermissions.add(requestedPermission);
        }
        this.grantResourceCreatePermissionSysPersister.updateResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, updatePermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreateSysPersister.updateResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, updatePermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreatePersister.updateResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId, updatePermissions, this.sessionResource);
        this.grantResourceCreatePermissionSysPersister.addResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, addPermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreateSysPersister.addResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, addPermissions, this.sessionResource);
        this.grantResourceCreatePermissionPostCreatePersister.addResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId, addPermissions, this.sessionResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourceCreatePermissions);
        this.__assertPermissionsSetNotEmpty(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(resourceCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourceCreatePermission resourceCreatePermission, ResourceCreatePermission ... resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourceCreatePermission);
        this.__assertVarargPermissionsSpecified(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourceCreatePermission, resourceCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__revokeDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __revokeDirectResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> requestedResourceCreatePermissions) {
        Set<ResourceCreatePermission> grantorPermissions;
        Set<ResourceCreatePermission> unauthorizedPermissions;
        ResourceClassInternalInfo resourceClassInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<ResourceClassId> resourceClassId = Id.from(resourceClassInfo.getResourceClassId());
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertUniquePostCreatePermissionsNamesForResourceClass(connection, requestedResourceCreatePermissions, resourceClassInfo);
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName) && (unauthorizedPermissions = this.__subtractResourceCreatePermissionsIfGrantableFrom(requestedResourceCreatePermissions, grantorPermissions = this.__getEffectiveResourceCreatePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "revoke the following permission(s): " + unauthorizedPermissions);
        }
        Set<ResourceCreatePermission> directAccessorPermissions = this.__getDirectResourceCreatePermissions(connection, accessorResource, resourceClassId, domainId);
        if (directAccessorPermissions.size() > requestedResourceCreatePermissions.size() && this.__setContainsResourceCreateSystemPermission(requestedResourceCreatePermissions)) {
            throw new IllegalArgumentException("Attempt to revoke a subset of resource create permissions that includes the *CREATE system permission: " + requestedResourceCreatePermissions);
        }
        HashSet<ResourceCreatePermission> removePermissions = new HashSet<ResourceCreatePermission>(requestedResourceCreatePermissions.size());
        block0: for (ResourceCreatePermission requestedPermission : requestedResourceCreatePermissions) {
            if (requestedPermission.isSystemPermission()) {
                for (ResourceCreatePermission existingDirectPermission : directAccessorPermissions) {
                    if (!existingDirectPermission.isSystemPermission() || requestedPermission.getSystemPermissionId() != existingDirectPermission.getSystemPermissionId()) continue;
                    removePermissions.add(requestedPermission);
                    continue block0;
                }
                continue;
            }
            ResourcePermission requestedPostCreateResourcePermission = requestedPermission.getPostCreateResourcePermission();
            for (ResourceCreatePermission existingDirectPermission : directAccessorPermissions) {
                if (existingDirectPermission.isSystemPermission() || !requestedPostCreateResourcePermission.equalsIgnoreGrantOption(existingDirectPermission.getPostCreateResourcePermission())) continue;
                removePermissions.add(requestedPermission);
                continue block0;
            }
        }
        this.grantResourceCreatePermissionSysPersister.removeResourceCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, removePermissions);
        this.grantResourceCreatePermissionPostCreateSysPersister.removeResourceCreatePostCreateSysPermissions(connection, accessorResource, resourceClassId, domainId, removePermissions);
        this.grantResourceCreatePermissionPostCreatePersister.removeResourceCreatePostCreatePermissions(connection, accessorResource, resourceClassId, domainId, removePermissions);
    }

    private boolean __setContainsResourceCreateSystemPermission(Set<ResourceCreatePermission> resourceCreatePermissions) {
        for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
            if (!resourceCreatePermission.isSystemPermission() || !ResourceCreatePermissions.CREATE.equals(resourceCreatePermission.getPermissionName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourceCreatePermission> getResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            Set<ResourceCreatePermission> set = this.__getDirectResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourceCreatePermission> __getDirectResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        return this.__getDirectResourceCreatePermissions(connection, accessorResource, resourceClassId, domainId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Set<ResourceCreatePermission>>> getResourceCreatePermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Map<String, Set<ResourceCreatePermission>>> map = this.__getDirectResourceCreatePermissionsMap(connection, accessorResource);
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Map<String, Map<String, Set<ResourceCreatePermission>>> __getDirectResourceCreatePermissionsMap(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourceCreatePermission>>> allResourceCreatePermissionsMap = new HashMap<String, Map<String, Set<ResourceCreatePermission>>>();
        allResourceCreatePermissionsMap.putAll(this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissions(connection, accessorResource));
        this.__mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(this.grantResourceCreatePermissionPostCreateSysPersister.getResourceCreatePostCreateSysPermissions(connection, accessorResource), allResourceCreatePermissionsMap);
        this.__mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(this.grantResourceCreatePermissionPostCreatePersister.getResourceCreatePostCreatePermissions(connection, accessorResource), allResourceCreatePermissionsMap);
        return this.__collapseResourceCreatePermissions(allResourceCreatePermissionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourceCreatePermission> getEffectiveResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            Set<ResourceCreatePermission> set = this.__getEffectiveResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourceCreatePermission> __getEffectiveResourceCreatePermissionsIgnoringSuperUserPrivileges(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        HashSet<ResourceCreatePermission> resourceCreatePermissions = new HashSet<ResourceCreatePermission>();
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreateSysPersister.getResourceCreatePostCreateSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreatePersister.getResourceCreatePostCreatePermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        return this.__collapseResourceCreatePermissions(resourceCreatePermissions);
    }

    private Set<ResourceCreatePermission> __getEffectiveResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        ResourceClassInternalInfo resourceClassInternalInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (this.__isSuperUserOfDomain(connection, accessorResource, domainName)) {
            return this.__getApplicableResourceCreatePermissions(connection, resourceClassInternalInfo);
        }
        Id<ResourceClassId> resourceClassId = Id.from(resourceClassInternalInfo.getResourceClassId());
        HashSet<ResourceCreatePermission> resourceCreatePermissions = new HashSet<ResourceCreatePermission>();
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreateSysPersister.getResourceCreatePostCreateSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourceCreatePermissions.addAll(this.grantResourceCreatePermissionPostCreatePersister.getResourceCreatePostCreatePermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        return this.__collapseResourceCreatePermissions(resourceCreatePermissions);
    }

    private Set<ResourceCreatePermission> __collapseResourceCreatePermissions(Set<ResourceCreatePermission> resourceCreatePermissions) {
        HashSet<ResourceCreatePermission> collapsedPermissions = new HashSet<ResourceCreatePermission>(resourceCreatePermissions);
        block0: for (ResourceCreatePermission permission : resourceCreatePermissions) {
            for (ResourceCreatePermission grantEquivalentPermission : resourceCreatePermissions) {
                if (!permission.isGrantableFrom(grantEquivalentPermission) || permission.equals(grantEquivalentPermission)) continue;
                collapsedPermissions.remove(permission);
                continue block0;
            }
        }
        return collapsedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Set<ResourceCreatePermission>>> getEffectiveResourceCreatePermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Map<String, Set<ResourceCreatePermission>>> map = this.__getEffectiveResourceCreatePermissionsMap(connection, accessorResource);
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Map<String, Map<String, Set<ResourceCreatePermission>>> __getEffectiveResourceCreatePermissionsMap(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourceCreatePermission>>> allResourceCreatePermissionsMap = new HashMap<String, Map<String, Set<ResourceCreatePermission>>>();
        allResourceCreatePermissionsMap.putAll(this.grantResourceCreatePermissionSysPersister.getResourceCreateSysPermissionsIncludeInherited(connection, accessorResource));
        this.__mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(this.grantResourceCreatePermissionPostCreateSysPersister.getResourceCreatePostCreateSysPermissionsIncludeInherited(connection, accessorResource), allResourceCreatePermissionsMap);
        this.__mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(this.grantResourceCreatePermissionPostCreatePersister.getResourceCreatePostCreatePermissionsIncludeInherited(connection, accessorResource), allResourceCreatePermissionsMap);
        HashMap<String, Map<String, Set<ResourceCreatePermission>>> allSuperResourceCreatePermissionsMap = new HashMap<String, Map<String, Set<ResourceCreatePermission>>>();
        HashMap<String, Set<ResourceCreatePermission>> superResourceCreatePermissionsMap = null;
        Map<String, Set<DomainPermission>> effectiveDomainPermissionsMap = this.__getEffectiveDomainPermissionsMap(connection, accessorResource);
        for (Map.Entry<String, Set<DomainPermission>> effectiveDomainPermissionsByDomainEntry : effectiveDomainPermissionsMap.entrySet()) {
            Set<DomainPermission> effectiveDomainPermissions = effectiveDomainPermissionsByDomainEntry.getValue();
            if (!effectiveDomainPermissions.contains(DomainPermission_SUPER_USER) && !effectiveDomainPermissions.contains(DomainPermission_SUPER_USER_GRANT)) continue;
            if (superResourceCreatePermissionsMap == null) {
                List<String> resourceClassNames = this.resourceClassPersister.getResourceClassNames(connection);
                superResourceCreatePermissionsMap = new HashMap<String, Set<ResourceCreatePermission>>(resourceClassNames.size());
                for (String resourceClassName : resourceClassNames) {
                    Set<ResourceCreatePermission> applicableResourceCreatePermissions = this.__getApplicableResourceCreatePermissions(connection, this.__getResourceClassInternalInfo(connection, resourceClassName));
                    superResourceCreatePermissionsMap.put(resourceClassName, applicableResourceCreatePermissions);
                }
            }
            allSuperResourceCreatePermissionsMap.put(effectiveDomainPermissionsByDomainEntry.getKey(), superResourceCreatePermissionsMap);
        }
        this.__mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(allSuperResourceCreatePermissionsMap, allResourceCreatePermissionsMap);
        return this.__collapseResourceCreatePermissions(allResourceCreatePermissionsMap);
    }

    private void __mergeSourceCreatePermissionsMapIntoTargetCreatePermissionsMap(Map<String, Map<String, Set<ResourceCreatePermission>>> sourceCreatePermissionsMap, Map<String, Map<String, Set<ResourceCreatePermission>>> targetCreatePermissionsMap) {
        for (Map.Entry<String, Map<String, Set<ResourceCreatePermission>>> sourcePermissionsMapByDomainEntry : sourceCreatePermissionsMap.entrySet()) {
            String domainName = sourcePermissionsMapByDomainEntry.getKey();
            Map<String, Set<ResourceCreatePermission>> targetCreatePermsForDomainMap = targetCreatePermissionsMap.get(domainName);
            if (targetCreatePermsForDomainMap == null) {
                targetCreatePermsForDomainMap = new HashMap<String, Set<ResourceCreatePermission>>();
                targetCreatePermissionsMap.put(domainName, targetCreatePermsForDomainMap);
            }
            for (Map.Entry<String, Set<ResourceCreatePermission>> sourcePermissionsByResourceClassEntry : sourcePermissionsMapByDomainEntry.getValue().entrySet()) {
                String resourceClassName = sourcePermissionsByResourceClassEntry.getKey();
                Set<ResourceCreatePermission> targetCreatePermsForClassSet = targetCreatePermsForDomainMap.get(resourceClassName);
                if (targetCreatePermsForClassSet == null) {
                    targetCreatePermsForClassSet = new HashSet<ResourceCreatePermission>();
                    targetCreatePermsForDomainMap.put(resourceClassName, targetCreatePermsForClassSet);
                }
                targetCreatePermsForClassSet.addAll((Collection<ResourceCreatePermission>)sourcePermissionsByResourceClassEntry.getValue());
            }
        }
    }

    private Map<String, Map<String, Set<ResourceCreatePermission>>> __collapseResourceCreatePermissions(Map<String, Map<String, Set<ResourceCreatePermission>>> resourceCreatePermissionsMap) {
        for (Map.Entry<String, Map<String, Set<ResourceCreatePermission>>> createPermissionsByDomainEntry : resourceCreatePermissionsMap.entrySet()) {
            Map<String, Set<ResourceCreatePermission>> createPermissionsByResourceClassMap = createPermissionsByDomainEntry.getValue();
            for (Map.Entry<String, Set<ResourceCreatePermission>> createPermissionsByResourceClassEntry : createPermissionsByResourceClassMap.entrySet()) {
                createPermissionsByResourceClassMap.put(createPermissionsByResourceClassEntry.getKey(), this.__collapseResourceCreatePermissions(createPermissionsByResourceClassEntry.getValue()));
            }
        }
        return resourceCreatePermissionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__setDirectResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions, this.sessionResource, false);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __setDirectResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource, boolean newResourceMode) {
        ResourceClassInternalInfo accessedResourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource);
        this.__assertUniqueResourcePermissionsNamesForResourceClass(connection, requestedResourcePermissions, accessedResourceClassInternalInfo);
        if (!newResourceMode) {
            Set<ResourcePermission> reversePathResourcePermissions;
            if (!this.__isSuperUserOfResource(connection, grantorResource, accessedResource)) {
                Set<ResourcePermission> unauthorizedRemovePermissions;
                Set<ResourcePermission> unauthorizedAddPermissions;
                Set<ResourcePermission> grantorResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, grantorResource, accessedResource);
                Set<ResourcePermission> directAccessorResourcePermissions = this.__getDirectResourcePermissions(connection, accessorResource, accessedResource);
                Set<ResourcePermission> requestedAddPermissions = this.__subtract(requestedResourcePermissions, directAccessorResourcePermissions);
                if (requestedAddPermissions.size() > 0 && (unauthorizedAddPermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedAddPermissions, grantorResourcePermissions)).size() > 0) {
                    throw NotAuthorizedException.newInstanceForAction(grantorResource, "add the following permission(s): " + unauthorizedAddPermissions);
                }
                Set<ResourcePermission> requestedRemovePermissions = this.__subtract(directAccessorResourcePermissions, requestedResourcePermissions);
                if (requestedRemovePermissions.size() > 0 && (unauthorizedRemovePermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedRemovePermissions, grantorResourcePermissions)).size() > 0) {
                    throw NotAuthorizedException.newInstanceForAction(grantorResource, "remove the following permission(s): " + unauthorizedRemovePermissions);
                }
            }
            if ((requestedResourcePermissions.contains(ResourcePermission_INHERIT) || requestedResourcePermissions.contains(ResourcePermission_INHERIT_GRANT)) && ((reversePathResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, accessedResource, accessorResource)).contains(ResourcePermission_INHERIT) || reversePathResourcePermissions.contains(ResourcePermission_INHERIT_GRANT) || accessorResource.equals(accessedResource))) {
                throw new OaccException("Granting the requested permission(s): " + requestedResourcePermissions + " will cause a cycle between: " + accessorResource + " and: " + accessedResource);
            }
            this.grantResourcePermissionSysPersister.removeResourceSysPermissions(connection, accessorResource, accessedResource);
            this.grantResourcePermissionPersister.removeResourcePermissions(connection, accessorResource, accessedResource);
        }
        this.grantResourcePermissionSysPersister.addResourceSysPermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), requestedResourcePermissions, grantorResource);
        this.grantResourcePermissionPersister.addResourcePermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), requestedResourcePermissions, grantorResource);
    }

    private void __assertUniqueResourcePermissionsNamesForResourceClass(SQLConnection connection, Set<ResourcePermission> resourcePermissions, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> validPermissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassInternalInfo);
        HashSet<String> uniquePermissionNames = new HashSet<String>(resourcePermissions.size());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!validPermissionNames.contains(resourcePermission.getPermissionName())) {
                if (resourcePermission.isSystemPermission()) {
                    throw new IllegalArgumentException("Permission: " + resourcePermission.getPermissionName() + ", not valid for unauthenticatable resource");
                }
                throw new IllegalArgumentException("Permission: " + resourcePermission.getPermissionName() + " is not defined for resource class: " + resourceClassInternalInfo.getResourceClassName());
            }
            if (uniquePermissionNames.contains(resourcePermission.getPermissionName())) {
                throw new IllegalArgumentException("Duplicate permission: " + resourcePermission.getPermissionName() + " that only differs in 'withGrant' option");
            }
            uniquePermissionNames.add(resourcePermission.getPermissionName());
        }
    }

    private Set<ResourcePermission> __subtractResourcePermissionsIfGrantableFrom(Set<ResourcePermission> candidatePermissionSet, Set<ResourcePermission> grantorPermissionSet) {
        HashSet<ResourcePermission> differenceSet = new HashSet<ResourcePermission>(candidatePermissionSet);
        block0: for (ResourcePermission candidatePermission : candidatePermissionSet) {
            for (ResourcePermission grantorPermission : grantorPermissionSet) {
                if (!candidatePermission.isGrantableFrom(grantorPermission)) continue;
                differenceSet.remove(candidatePermission);
                continue block0;
            }
        }
        return differenceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__grantDirectResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantResourcePermissions(Resource accessorResource, Resource accessedResource, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__grantDirectResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __grantDirectResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Set<ResourcePermission> requestedResourcePermissions) {
        Set<ResourcePermission> reversePathResourcePermissions;
        Set<ResourcePermission> grantorResourcePermissions;
        Set<ResourcePermission> unauthorizedPermissions;
        ResourceClassInternalInfo accessedResourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource);
        this.__assertUniqueResourcePermissionsNamesForResourceClass(connection, requestedResourcePermissions, accessedResourceClassInternalInfo);
        if (!this.__isSuperUserOfResource(connection, this.sessionResource, accessedResource) && (unauthorizedPermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedResourcePermissions, grantorResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, accessedResource))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "grant the following permission(s): " + unauthorizedPermissions);
        }
        Set<ResourcePermission> directAccessorResourcePermissions = this.__getDirectResourcePermissions(connection, accessorResource, accessedResource);
        HashSet<ResourcePermission> addPermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
        HashSet<ResourcePermission> updatePermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
        for (ResourcePermission requestedPermission : requestedResourcePermissions) {
            boolean existingPermission = false;
            for (ResourcePermission existingDirectPermission : directAccessorResourcePermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                if (!requestedPermission.equals(existingDirectPermission) && !requestedPermission.isGrantableFrom(existingDirectPermission)) {
                    updatePermissions.add(requestedPermission);
                }
                existingPermission = true;
                break;
            }
            if (existingPermission) continue;
            addPermissions.add(requestedPermission);
        }
        if ((addPermissions.contains(ResourcePermission_INHERIT) || addPermissions.contains(ResourcePermission_INHERIT_GRANT)) && ((reversePathResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, accessedResource, accessorResource)).contains(ResourcePermission_INHERIT) || reversePathResourcePermissions.contains(ResourcePermission_INHERIT_GRANT) || accessorResource.equals(accessedResource))) {
            throw new OaccException("Granting the requested permission(s): " + requestedResourcePermissions + " will cause a cycle between: " + accessorResource + " and: " + accessedResource);
        }
        this.grantResourcePermissionSysPersister.updateResourceSysPermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), updatePermissions, this.sessionResource);
        this.grantResourcePermissionPersister.updateResourcePermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), updatePermissions, this.sessionResource);
        this.grantResourcePermissionSysPersister.addResourceSysPermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), addPermissions, this.sessionResource);
        this.grantResourcePermissionPersister.addResourcePermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), addPermissions, this.sessionResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__revokeDirectResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeResourcePermissions(Resource accessorResource, Resource accessedResource, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__revokeDirectResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __revokeDirectResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Set<ResourcePermission> obsoleteResourcePermissions) {
        Set<ResourcePermission> grantorResourcePermissions;
        Set<ResourcePermission> unauthorizedPermissions;
        ResourceClassInternalInfo accessedResourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource);
        this.__assertUniqueResourcePermissionsNamesForResourceClass(connection, obsoleteResourcePermissions, accessedResourceClassInternalInfo);
        if (!this.__isSuperUserOfResource(connection, this.sessionResource, accessedResource) && (unauthorizedPermissions = this.__subtractResourcePermissionsIfGrantableFrom(obsoleteResourcePermissions, grantorResourcePermissions = this.__getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, accessedResource))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "revoke the following permission(s): " + unauthorizedPermissions);
        }
        Set<ResourcePermission> directAccessorResourcePermissions = this.__getDirectResourcePermissions(connection, accessorResource, accessedResource);
        HashSet<ResourcePermission> removePermissions = new HashSet<ResourcePermission>(obsoleteResourcePermissions.size());
        block0: for (ResourcePermission requestedPermission : obsoleteResourcePermissions) {
            for (ResourcePermission existingDirectPermission : directAccessorResourcePermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                removePermissions.add(requestedPermission);
                continue block0;
            }
        }
        this.grantResourcePermissionSysPersister.removeResourceSysPermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), removePermissions);
        this.grantResourcePermissionPersister.removeResourcePermissions(connection, accessorResource, accessedResource, Id.from(accessedResourceClassInternalInfo.getResourceClassId()), removePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePermission> getResourcePermissions(Resource accessorResource, Resource accessedResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Set<ResourcePermission> set = this.__getDirectResourcePermissions(connection, accessorResource, accessedResource);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourcePermission> __getDirectResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        resourcePermissions.addAll(this.grantResourcePermissionSysPersister.getResourceSysPermissions(connection, accessorResource, accessedResource));
        resourcePermissions.addAll(this.grantResourcePermissionPersister.getResourcePermissions(connection, accessorResource, accessedResource));
        return resourcePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePermission> getEffectiveResourcePermissions(Resource accessorResource, Resource accessedResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Set<ResourcePermission> set = this.__getEffectiveResourcePermissions(connection, accessorResource, accessedResource);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourcePermission> __getEffectiveResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        Id<DomainId> accessedDomainId = this.resourcePersister.getDomainIdByResource(connection, accessedResource);
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource);
        if (this.__isSuperUserOfDomain(connection, accessorResource, accessedDomainId)) {
            return this.__getApplicableResourcePermissions(connection, resourceClassInternalInfo);
        }
        resourcePermissions.addAll(this.grantResourcePermissionSysPersister.getResourceSysPermissionsIncludeInherited(connection, accessorResource, accessedResource));
        resourcePermissions.addAll(this.grantResourcePermissionPersister.getResourcePermissionsIncludeInherited(connection, accessorResource, accessedResource));
        Id<ResourceClassId> accessedResourceClassId = Id.from(resourceClassInternalInfo.getResourceClassId());
        resourcePermissions.addAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissionsIncludeInherited(connection, accessorResource, accessedResourceClassId, accessedDomainId));
        resourcePermissions.addAll(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissionsIncludeInherited(connection, accessorResource, accessedResourceClassId, accessedDomainId));
        return this.__collapseResourcePermissions(resourcePermissions);
    }

    private Set<ResourcePermission> __getEffectiveResourcePermissionsIgnoringSuperUserPrivileges(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        resourcePermissions.addAll(this.grantResourcePermissionSysPersister.getResourceSysPermissionsIncludeInherited(connection, accessorResource, accessedResource));
        resourcePermissions.addAll(this.grantResourcePermissionPersister.getResourcePermissionsIncludeInherited(connection, accessorResource, accessedResource));
        Id<DomainId> accessedDomainId = this.resourcePersister.getDomainIdByResource(connection, accessedResource);
        Id<ResourceClassId> accessedResourceClassId = Id.from(this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource).getResourceClassId());
        resourcePermissions.addAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissionsIncludeInherited(connection, accessorResource, accessedResourceClassId, accessedDomainId));
        resourcePermissions.addAll(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissionsIncludeInherited(connection, accessorResource, accessedResourceClassId, accessedDomainId));
        return this.__collapseResourcePermissions(resourcePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            this.__setDirectGlobalPermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __setDirectGlobalPermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfo(connection, resourceClassName);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertUniqueGlobalResourcePermissionNamesForResourceClass(connection, requestedResourcePermissions, resourceClassInternalInfo);
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName)) {
            Set<ResourcePermission> unauthorizedRemovePermissions;
            Set<ResourcePermission> unauthorizedAddPermissions;
            Set<ResourcePermission> grantorPermissions = this.__getEffectiveGlobalResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName);
            Set<ResourcePermission> directAccessorPermissions = this.__getDirectGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId);
            Set<ResourcePermission> requestedAddPermissions = this.__subtract(requestedResourcePermissions, directAccessorPermissions);
            if (!requestedAddPermissions.isEmpty() && (unauthorizedAddPermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedAddPermissions, grantorPermissions)).size() > 0) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "add the following global permission(s): " + unauthorizedAddPermissions);
            }
            Set<ResourcePermission> requestedRemovePermissions = this.__subtract(directAccessorPermissions, requestedResourcePermissions);
            if (!requestedRemovePermissions.isEmpty() && (unauthorizedRemovePermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedRemovePermissions, grantorPermissions)).size() > 0) {
                throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "remove the following global permission(s): " + unauthorizedRemovePermissions);
            }
        }
        this.grantGlobalResourcePermissionSysPersister.removeGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId);
        this.grantGlobalResourcePermissionPersister.removeGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId);
        this.grantGlobalResourcePermissionSysPersister.addGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId, requestedResourcePermissions, this.sessionResource);
        this.grantGlobalResourcePermissionPersister.addGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId, requestedResourcePermissions, this.sessionResource);
    }

    private Set<ResourcePermission> __getDirectGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> domainId) {
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        resourcePermissions.addAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId));
        resourcePermissions.addAll(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId));
        return resourcePermissions;
    }

    private void __assertUniqueGlobalResourcePermissionNamesForResourceClass(SQLConnection connection, Set<ResourcePermission> requestedResourcePermissions, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> validPermissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassInternalInfo);
        HashSet<String> uniquePermissionNames = new HashSet<String>(requestedResourcePermissions.size());
        for (ResourcePermission resourcePermission : requestedResourcePermissions) {
            if (resourcePermission.isSystemPermission() && ResourcePermission_INHERIT.equals(resourcePermission)) {
                throw new IllegalArgumentException("Permission: " + String.valueOf(resourcePermission) + ", not valid in this context");
            }
            if (!validPermissionNames.contains(resourcePermission.getPermissionName())) {
                if (resourcePermission.isSystemPermission()) {
                    throw new IllegalArgumentException("Permission " + resourcePermission.getPermissionName() + " not valid for unauthenticatable resource of class " + resourceClassInternalInfo.getResourceClassName());
                }
                throw new IllegalArgumentException("Permission: " + resourcePermission.getPermissionName() + " is not defined for resource class: " + resourceClassInternalInfo.getResourceClassName());
            }
            if (uniquePermissionNames.contains(resourcePermission.getPermissionName())) {
                throw new IllegalArgumentException("Duplicate permission: " + resourcePermission.getPermissionName() + " that only differs in 'withGrant' option");
            }
            uniquePermissionNames.add(resourcePermission.getPermissionName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            this.__grantDirectGlobalPermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            this.__grantDirectGlobalPermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __grantDirectGlobalPermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        Set<ResourcePermission> grantorPermissions;
        Set<ResourcePermission> unauthorizedPermissions;
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfo(connection, resourceClassName);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertUniqueGlobalResourcePermissionNamesForResourceClass(connection, requestedResourcePermissions, resourceClassInternalInfo);
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName) && (unauthorizedPermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedResourcePermissions, grantorPermissions = this.__getEffectiveGlobalResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "grant the following global permission(s): " + unauthorizedPermissions);
        }
        Set<ResourcePermission> directAccessorPermissions = this.__getDirectGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId);
        HashSet<ResourcePermission> addPermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
        HashSet<ResourcePermission> updatePermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
        for (ResourcePermission requestedPermission : requestedResourcePermissions) {
            boolean existingPermission = false;
            for (ResourcePermission existingDirectPermission : directAccessorPermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                if (!requestedPermission.equals(existingDirectPermission) && !requestedPermission.isGrantableFrom(existingDirectPermission)) {
                    updatePermissions.add(requestedPermission);
                }
                existingPermission = true;
                break;
            }
            if (existingPermission) continue;
            addPermissions.add(requestedPermission);
        }
        this.grantGlobalResourcePermissionSysPersister.updateGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId, updatePermissions, this.sessionResource);
        this.grantGlobalResourcePermissionPersister.updateGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId, updatePermissions, this.sessionResource);
        this.grantGlobalResourcePermissionSysPersister.addGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId, addPermissions, this.sessionResource);
        this.grantGlobalResourcePermissionPersister.addGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId, addPermissions, this.sessionResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            this.__revokeDirectGlobalPermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            this.__revokeDirectGlobalPermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private void __revokeDirectGlobalPermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        Set<ResourcePermission> grantorPermissions;
        Set<ResourcePermission> unauthorizedPermissions;
        ResourceClassInternalInfo resourceClassInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        this.__assertUniqueResourcePermissionsNamesForResourceClass(connection, requestedResourcePermissions, resourceClassInfo);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (!this.__isSuperUserOfDomain(connection, this.sessionResource, domainName) && (unauthorizedPermissions = this.__subtractResourcePermissionsIfGrantableFrom(requestedResourcePermissions, grantorPermissions = this.__getEffectiveGlobalResourcePermissionsIgnoringSuperUserPrivileges(connection, this.sessionResource, resourceClassName, domainName))).size() > 0) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "revoke the following global permission(s): " + unauthorizedPermissions);
        }
        Set<ResourcePermission> directAccessorPermissions = this.__getDirectGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId);
        HashSet<ResourcePermission> removePermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
        block0: for (ResourcePermission requestedPermission : requestedResourcePermissions) {
            for (ResourcePermission existingDirectPermission : directAccessorPermissions) {
                if (!requestedPermission.equalsIgnoreGrantOption(existingDirectPermission)) continue;
                removePermissions.add(requestedPermission);
                continue block0;
            }
        }
        this.grantGlobalResourcePermissionSysPersister.removeGlobalSysPermissions(connection, accessorResource, resourceClassId, domainId, removePermissions);
        this.grantGlobalResourcePermissionPersister.removeGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId, removePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePermission> getGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            Set<ResourcePermission> set = this.__getDirectGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourcePermission> __getDirectGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        return this.__getDirectGlobalResourcePermissions(connection, accessorResource, resourceClassId, domainId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePermission> getEffectiveGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            Set<ResourcePermission> set = this.__getEffectiveGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<ResourcePermission> __getEffectiveGlobalResourcePermissionsIgnoringSuperUserPrivileges(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        resourcePermissions.addAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourcePermissions.addAll(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        return this.__collapseResourcePermissions(resourcePermissions);
    }

    private Set<ResourcePermission> __getEffectiveGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName) {
        ResourceClassInternalInfo resourceClassInternalInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        if (this.__isSuperUserOfDomain(connection, accessorResource, domainName)) {
            return this.__getApplicableResourcePermissions(connection, resourceClassInternalInfo);
        }
        Id<ResourceClassId> resourceClassId = Id.from(resourceClassInternalInfo.getResourceClassId());
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        resourcePermissions.addAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        resourcePermissions.addAll(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissionsIncludeInherited(connection, accessorResource, resourceClassId, domainId));
        return this.__collapseResourcePermissions(resourcePermissions);
    }

    private Set<ResourcePermission> __getApplicableResourcePermissions(SQLConnection connection, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> resourcePermissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassInternalInfo);
        HashSet<ResourcePermission> superResourcePermissions = new HashSet<ResourcePermission>(resourcePermissionNames.size());
        for (String permissionName : resourcePermissionNames) {
            superResourcePermissions.add(ResourcePermissions.getInstanceWithGrantOption(permissionName));
        }
        return superResourcePermissions;
    }

    private Set<ResourceCreatePermission> __getApplicableResourceCreatePermissions(SQLConnection connection, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> resourcePermissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassInternalInfo);
        HashSet<ResourceCreatePermission> superResourceCreatePermissions = new HashSet<ResourceCreatePermission>(resourcePermissionNames.size() + 1);
        superResourceCreatePermissions.add(ResourceCreatePermissions.getInstanceWithGrantOption(ResourceCreatePermissions.CREATE));
        for (String permissionName : resourcePermissionNames) {
            superResourceCreatePermissions.add(ResourceCreatePermissions.getInstanceWithGrantOption(ResourcePermissions.getInstanceWithGrantOption(permissionName)));
        }
        return superResourceCreatePermissions;
    }

    private Set<ResourcePermission> __collapseResourcePermissions(Set<ResourcePermission> resourcePermissions) {
        HashSet<ResourcePermission> collapsedPermissions = new HashSet<ResourcePermission>(resourcePermissions);
        block0: for (ResourcePermission permission : resourcePermissions) {
            for (ResourcePermission grantEquivalentPermission : resourcePermissions) {
                if (!permission.isGrantableFrom(grantEquivalentPermission) || permission.equals(grantEquivalentPermission)) continue;
                collapsedPermissions.remove(permission);
                continue block0;
            }
        }
        return collapsedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getGlobalResourcePermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Map<String, Set<ResourcePermission>>> map = this.__getDirectGlobalResourcePermissionsMap(connection, accessorResource);
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Map<String, Map<String, Set<ResourcePermission>>> __getDirectGlobalResourcePermissionsMap(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourcePermission>>> globalALLPermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
        globalALLPermissionsMap.putAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissions(connection, accessorResource));
        this.__mergeSourcePermissionsMapIntoTargetPermissionsMap(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissions(connection, accessorResource), globalALLPermissionsMap);
        return this.__collapseResourcePermissions(globalALLPermissionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getEffectiveGlobalResourcePermissionsMap(Resource accessorResource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            Map<String, Map<String, Set<ResourcePermission>>> map = this.__getEffectiveGlobalResourcePermissionsMap(connection, accessorResource);
            return map;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Map<String, Map<String, Set<ResourcePermission>>> __getEffectiveGlobalResourcePermissionsMap(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourcePermission>>> globalALLPermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
        globalALLPermissionsMap.putAll(this.grantGlobalResourcePermissionSysPersister.getGlobalSysPermissionsIncludeInherited(connection, accessorResource));
        this.__mergeSourcePermissionsMapIntoTargetPermissionsMap(this.grantGlobalResourcePermissionPersister.getGlobalResourcePermissionsIncludeInherited(connection, accessorResource), globalALLPermissionsMap);
        HashMap<String, Map<String, Set<ResourcePermission>>> superGlobalResourcePermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
        HashMap<String, Set<ResourcePermission>> superResourcePermissionsMap = null;
        Map<String, Set<DomainPermission>> effectiveDomainPermissionsMap = this.__getEffectiveDomainPermissionsMap(connection, accessorResource);
        for (Map.Entry<String, Set<DomainPermission>> effectiveDomainPermissionsByDomainEntry : effectiveDomainPermissionsMap.entrySet()) {
            Set<DomainPermission> effectiveDomainPermissions = effectiveDomainPermissionsByDomainEntry.getValue();
            if (!effectiveDomainPermissions.contains(DomainPermission_SUPER_USER) && !effectiveDomainPermissions.contains(DomainPermission_SUPER_USER_GRANT)) continue;
            if (superResourcePermissionsMap == null) {
                List<String> resourceClassNames = this.resourceClassPersister.getResourceClassNames(connection);
                superResourcePermissionsMap = new HashMap<String, Set<ResourcePermission>>(resourceClassNames.size());
                for (String resourceClassName : resourceClassNames) {
                    Set<ResourcePermission> applicableResourcePermissions = this.__getApplicableResourcePermissions(connection, this.__getResourceClassInternalInfo(connection, resourceClassName));
                    superResourcePermissionsMap.put(resourceClassName, applicableResourcePermissions);
                }
            }
            superGlobalResourcePermissionsMap.put(effectiveDomainPermissionsByDomainEntry.getKey(), superResourcePermissionsMap);
        }
        this.__mergeSourcePermissionsMapIntoTargetPermissionsMap(superGlobalResourcePermissionsMap, globalALLPermissionsMap);
        return this.__collapseResourcePermissions(globalALLPermissionsMap);
    }

    private void __mergeSourcePermissionsMapIntoTargetPermissionsMap(Map<String, Map<String, Set<ResourcePermission>>> sourcePermissionsMap, Map<String, Map<String, Set<ResourcePermission>>> targetPermissionsMap) {
        for (Map.Entry<String, Map<String, Set<ResourcePermission>>> sourcePermissionsMapByDomainEntry : sourcePermissionsMap.entrySet()) {
            String domainName = sourcePermissionsMapByDomainEntry.getKey();
            Map<String, Set<ResourcePermission>> targetPermsForDomainMap = targetPermissionsMap.get(domainName);
            if (targetPermsForDomainMap == null) {
                targetPermsForDomainMap = new HashMap<String, Set<ResourcePermission>>();
                targetPermissionsMap.put(domainName, targetPermsForDomainMap);
            }
            for (Map.Entry<String, Set<ResourcePermission>> sourcePermissionsByResourceClassEntry : sourcePermissionsMapByDomainEntry.getValue().entrySet()) {
                String resourceClassName = sourcePermissionsByResourceClassEntry.getKey();
                Set<ResourcePermission> targetPermsForClassSet = targetPermsForDomainMap.get(resourceClassName);
                if (targetPermsForClassSet == null) {
                    targetPermsForClassSet = new HashSet<ResourcePermission>();
                    targetPermsForDomainMap.put(resourceClassName, targetPermsForClassSet);
                }
                targetPermsForClassSet.addAll((Collection<ResourcePermission>)sourcePermissionsByResourceClassEntry.getValue());
            }
        }
    }

    private Map<String, Map<String, Set<ResourcePermission>>> __collapseResourcePermissions(Map<String, Map<String, Set<ResourcePermission>>> resourcePermissionsMap) {
        for (Map.Entry<String, Map<String, Set<ResourcePermission>>> resourcePermissionsMapByDomainEntry : resourcePermissionsMap.entrySet()) {
            Map<String, Set<ResourcePermission>> resourcePermissionsByResourceClassMap = resourcePermissionsMapByDomainEntry.getValue();
            for (Map.Entry<String, Set<ResourcePermission>> resourcePermissionsByResourceClassEntry : resourcePermissionsByResourceClassMap.entrySet()) {
                resourcePermissionsByResourceClassMap.put(resourcePermissionsByResourceClassEntry.getKey(), this.__collapseResourcePermissions(resourcePermissionsByResourceClassEntry.getValue()));
            }
        }
        return resourcePermissionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDomainNameByResource(Resource resource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(resource);
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            if (this.sessionResource.equals(resource)) {
                String string = this.sessionResourceDomainName;
                return string;
            }
            if (this.authenticatedResource.equals(resource)) {
                String string = this.authenticatedResourceDomainName;
                return string;
            }
            String string = this.domainPersister.getResourceDomainNameByResourceId(connection, resource);
            return string;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDomainDescendants(String domainName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertDomainSpecified(domainName);
        try {
            connection = this.__getConnection();
            domainName = domainName.trim();
            Set<String> set = this.domainPersister.getResourceDomainNameDescendants(connection, domainName);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceClassInfo getResourceClassInfo(String resourceClassName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceClassSpecified(resourceClassName);
        try {
            connection = this.__getConnection();
            ResourceClassInternalInfo resourceClassInternalInfo = this.__getResourceClassInternalInfo(connection, resourceClassName);
            ResourceClassInfo resourceClassInfo = new ResourceClassInfo(resourceClassInternalInfo.getResourceClassName(), resourceClassInternalInfo.isAuthenticatable(), resourceClassInternalInfo.isUnauthenticatedCreateAllowed());
            return resourceClassInfo;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceClassInfo getResourceClassInfoByResource(Resource resource) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(resource);
        try {
            connection = this.__getConnection();
            resource = this.__resolveResource(connection, resource);
            ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, resource);
            ResourceClassInfo resourceClassInfo = new ResourceClassInfo(resourceClassInternalInfo.getResourceClassName(), resourceClassInternalInfo.isAuthenticatable(), resourceClassInternalInfo.isUnauthenticatedCreateAllowed());
            return resourceClassInfo;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    @Override
    public Resource getAuthenticatedResource() {
        this.__assertAuthenticated();
        if (this.defensiveCopyOfAuthenticatedResource == null || !SQLAccessControlContext.__isEqual(this.defensiveCopyOfAuthenticatedResource, this.authenticatedResource)) {
            this.defensiveCopyOfAuthenticatedResource = Resources.getInstance(this.authenticatedResource.getId(), this.authenticatedResource.getExternalId());
        }
        return this.defensiveCopyOfAuthenticatedResource;
    }

    @Override
    public Resource getSessionResource() {
        this.__assertAuthenticated();
        if (this.defensiveCopyOfSessionResource == null || !SQLAccessControlContext.__isEqual(this.defensiveCopyOfSessionResource, this.sessionResource)) {
            this.defensiveCopyOfSessionResource = Resources.getInstance(this.sessionResource.getId(), this.sessionResource.getExternalId());
        }
        return this.defensiveCopyOfSessionResource;
    }

    @Override
    public void assertPostCreateDomainPermissions(Resource accessorResource, Set<DomainPermission> domainPermissions) {
        if (!this.hasPostCreateDomainPermissions(accessorResource, domainPermissions)) {
            throw NotAuthorizedException.newInstanceForPostCreateDomainPermissions(accessorResource, domainPermissions);
        }
    }

    @Override
    public void assertPostCreateDomainPermissions(Resource accessorResource, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        if (!this.hasPostCreateDomainPermissions(accessorResource, domainPermission, domainPermissions)) {
            throw NotAuthorizedException.newInstanceForPostCreateDomainPermissions(accessorResource, domainPermission, domainPermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPostCreateDomainPermissions(Resource accessorResource, Set<DomainPermission> domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionsSpecified(domainPermissions);
        this.__assertPermissionsSetNotEmpty(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(domainPermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasPostCreateDomainPermissions(connection, accessorResource, normalizedDomainPermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPostCreateDomainPermissions(Resource accessorResource, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionSpecified(domainPermission);
        this.__assertVarargPermissionsSpecified(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainPermission, domainPermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasPostCreateDomainPermissions(connection, accessorResource, normalizedDomainPermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasPostCreateDomainPermissions(SQLConnection connection, Resource accessorResource, Set<DomainPermission> requestedDomainPermissions) {
        this.__assertQueryAuthorization(connection, accessorResource);
        boolean hasPermission = false;
        Set<DomainCreatePermission> effectiveDomainCreatePermissions = this.__getEffectiveDomainCreatePermissions(connection, accessorResource);
        for (DomainCreatePermission domainCreatePermission : effectiveDomainCreatePermissions) {
            if (!domainCreatePermission.isSystemPermission() || !DomainCreatePermissions.CREATE.equals(domainCreatePermission.getPermissionName())) continue;
            hasPermission = true;
            break;
        }
        if (hasPermission) {
            Set<DomainPermission> postCreateDomainPermissions = this.__getPostCreateDomainPermissions(effectiveDomainCreatePermissions);
            for (DomainPermission requestedDomainPermission : requestedDomainPermissions) {
                if (this.__isPermissible(requestedDomainPermission, postCreateDomainPermissions)) continue;
                hasPermission = false;
                break;
            }
            if (!hasPermission) {
                hasPermission = postCreateDomainPermissions.contains(DomainPermission_SUPER_USER) || postCreateDomainPermissions.contains(DomainPermission_SUPER_USER_GRANT);
            }
        }
        return hasPermission;
    }

    private boolean __isPermissible(DomainPermission queriedDomainPermission, Set<DomainPermission> domainPermissions) {
        for (DomainPermission domainPermission : domainPermissions) {
            if (!queriedDomainPermission.equals(domainPermission) && !queriedDomainPermission.isGrantableFrom(domainPermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> domainPermissions) {
        if (!this.hasDomainPermissions(accessorResource, domainName, domainPermissions)) {
            throw NotAuthorizedException.newInstanceForDomainPermissions(accessorResource, domainName, domainPermissions);
        }
    }

    @Override
    public void assertDomainPermissions(Resource accessorResource, String domainName, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        if (!this.hasDomainPermissions(accessorResource, domainName, domainPermission, domainPermissions)) {
            throw NotAuthorizedException.newInstanceForDomainPermissions(accessorResource, domainName, domainPermission, domainPermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDomainPermissions(Resource accessorResource, String domainName, Set<DomainPermission> domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(domainPermissions);
        this.__assertPermissionsSetNotEmpty(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(domainPermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDomainPermissions(Resource accessorResource, String domainName, DomainPermission domainPermission, DomainPermission ... domainPermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(domainPermission);
        this.__assertVarargPermissionsSpecified(domainPermissions);
        Set<DomainPermission> normalizedDomainPermissions = SQLAccessControlContext.__normalizeDomainPermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainPermission, domainPermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasDomainPermissions(connection, accessorResource, domainName, normalizedDomainPermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasDomainPermissions(SQLConnection connection, Resource accessorResource, String domainName, Set<DomainPermission> requestedDomainPermissions) {
        this.__assertQueryAuthorization(connection, accessorResource);
        Set<DomainPermission> effectiveDomainPermissions = this.__getEffectiveDomainPermissions(connection, accessorResource, domainName);
        boolean hasPermission = true;
        for (DomainPermission domainPermission : requestedDomainPermissions) {
            if (this.__isPermissible(domainPermission, effectiveDomainPermissions)) continue;
            hasPermission = false;
            break;
        }
        if (!hasPermission) {
            hasPermission = this.__isSuperUserOfDomain(connection, accessorResource, domainName);
        }
        return hasPermission;
    }

    @Override
    public void assertDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        if (!this.hasDomainCreatePermissions(accessorResource, domainCreatePermissions)) {
            throw NotAuthorizedException.newInstanceForDomainCreatePermissions(accessorResource, domainCreatePermissions);
        }
    }

    @Override
    public void assertDomainCreatePermissions(Resource accessorResource, DomainCreatePermission domainCreatePermission, DomainCreatePermission ... domainCreatePermissions) {
        if (!this.hasDomainCreatePermissions(accessorResource, domainCreatePermission, domainCreatePermissions)) {
            throw NotAuthorizedException.newInstanceForDomainCreatePermissions(accessorResource, domainCreatePermission, domainCreatePermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDomainCreatePermissions(Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionsSpecified(domainCreatePermissions);
        this.__assertPermissionsSetNotEmpty(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(domainCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDomainCreatePermissions(Resource accessorResource, DomainCreatePermission domainCreatePermission, DomainCreatePermission ... domainCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertPermissionSpecified(domainCreatePermission);
        this.__assertVarargPermissionsSpecified(domainCreatePermissions);
        Set<DomainCreatePermission> normalizedDomainCreatePermissions = SQLAccessControlContext.__normalizeDomainCreatePermissions(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(domainCreatePermission, domainCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            boolean bl = this.__hasDomainCreatePermissions(connection, accessorResource, normalizedDomainCreatePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasDomainCreatePermissions(SQLConnection connection, Resource accessorResource, Set<DomainCreatePermission> queriedDomainCreatePermissions) {
        this.__assertQueryAuthorization(connection, accessorResource);
        Set<DomainCreatePermission> effectiveDomainCreatePermissions = this.__getEffectiveDomainCreatePermissions(connection, accessorResource);
        for (DomainCreatePermission domainCreatePermission : queriedDomainCreatePermissions) {
            if (this.__isPermissible(domainCreatePermission, effectiveDomainCreatePermissions)) continue;
            return false;
        }
        return true;
    }

    private boolean __isPermissible(DomainCreatePermission queriedDomainCreatePermission, Set<DomainCreatePermission> domainCreatePermissions) {
        for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
            if (!queriedDomainCreatePermission.equals(domainCreatePermission) && !queriedDomainCreatePermission.isGrantableFrom(domainCreatePermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        if (!this.hasPostCreateResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForPostCreateResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermissions);
        }
    }

    @Override
    public void assertPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        if (!this.hasPostCreateResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermission, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForPostCreateResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermission, resourcePermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasPostCreateResourcePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPostCreateResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasPostCreateResourcePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasPostCreateResourcePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        this.__assertPermissionsValid(connection, resourceClassName, requestedResourcePermissions);
        this.__assertQueryAuthorization(connection, accessorResource);
        boolean hasPermission = false;
        Set<ResourceCreatePermission> effectiveResourceCreatePermissions = this.__getEffectiveResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName);
        for (ResourceCreatePermission resourceCreatePermission : effectiveResourceCreatePermissions) {
            if (!resourceCreatePermission.isSystemPermission() || !ResourceCreatePermissions.CREATE.equals(resourceCreatePermission.getPermissionName())) continue;
            hasPermission = true;
            break;
        }
        if (hasPermission) {
            Set<ResourcePermission> postCreateResourcePermissions = this.__getPostCreateResourcePermissions(effectiveResourceCreatePermissions);
            HashSet<ResourcePermission> nonPostCreateResourcePermissions = new HashSet<ResourcePermission>(requestedResourcePermissions.size());
            for (ResourcePermission requestedResourcePermission : requestedResourcePermissions) {
                if (this.__isPermissible(requestedResourcePermission, postCreateResourcePermissions)) continue;
                nonPostCreateResourcePermissions.add(requestedResourcePermission);
            }
            if (!nonPostCreateResourcePermissions.isEmpty()) {
                Set<ResourcePermission> globalResourcePermissions = this.__getEffectiveGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName);
                for (ResourcePermission requestedResourcePermission : nonPostCreateResourcePermissions) {
                    if (this.__isPermissible(requestedResourcePermission, globalResourcePermissions)) continue;
                    hasPermission = false;
                    break;
                }
            }
        }
        if (!hasPermission) {
            hasPermission = this.__isSuperUserOfDomain(connection, accessorResource, domainName);
        }
        return hasPermission;
    }

    private boolean __isPermissible(ResourcePermission queriedResourcePermission, Set<ResourcePermission> resourcePermissions) {
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!queriedResourcePermission.equals(resourcePermission) && !queriedResourcePermission.isGrantableFrom(resourcePermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        if (!this.hasGlobalResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForGlobalResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermissions);
        }
    }

    @Override
    public void assertGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        if (!this.hasGlobalResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermission, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForGlobalResourcePermissions(accessorResource, resourceClassName, domainName, resourcePermission, resourcePermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGlobalResourcePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        this.__assertPermissionsValid(connection, resourceClassName, requestedResourcePermissions);
        this.__assertQueryAuthorization(connection, accessorResource);
        Set<ResourcePermission> globalResourcePermissions = this.__getEffectiveGlobalResourcePermissions(connection, accessorResource, resourceClassName, domainName);
        boolean hasPermission = true;
        for (ResourcePermission requestedResourcePermission : requestedResourcePermissions) {
            if (this.__isPermissible(requestedResourcePermission, globalResourcePermissions)) continue;
            hasPermission = false;
            break;
        }
        if (!hasPermission) {
            hasPermission = this.__isSuperUserOfDomain(connection, accessorResource, domainName);
        }
        return hasPermission;
    }

    @Override
    public void assertResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        if (!this.hasResourcePermissions(accessorResource, accessedResource, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForResourcePermissions(accessorResource, accessedResource, resourcePermissions);
        }
    }

    @Override
    public void assertResourcePermissions(Resource accessorResource, Resource accessedResource, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        if (!this.hasResourcePermissions(accessorResource, accessedResource, resourcePermission, resourcePermissions)) {
            throw NotAuthorizedException.newInstanceForResourcePermissions(accessorResource, accessedResource, resourcePermission, resourcePermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResourcePermissions(Resource accessorResource, Resource accessedResource, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            boolean bl = this.__hasResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResourcePermissions(Resource accessorResource, Resource accessedResource, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceSpecified(accessedResource);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            accessedResource = this.__resolveResource(connection, accessedResource);
            boolean bl = this.__hasResourcePermissions(connection, accessorResource, accessedResource, normalizedResourcePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Set<ResourcePermission> requestedResourcePermissions) {
        this.__assertQueryAuthorization(connection, accessorResource);
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfoByResourceId(connection, accessedResource);
        this.__assertPermissionsValid(connection, resourceClassInternalInfo.getResourceClassName(), requestedResourcePermissions);
        Set<ResourcePermission> effectiveResourcePermissions = this.__getEffectiveResourcePermissions(connection, accessorResource, accessedResource);
        boolean hasPermission = true;
        for (ResourcePermission requestedResourcePermission : requestedResourcePermissions) {
            if (this.__isPermissible(requestedResourcePermission, effectiveResourcePermissions)) continue;
            hasPermission = false;
            break;
        }
        if (!hasPermission) {
            String domainName = this.domainPersister.getResourceDomainNameByResourceId(connection, accessedResource);
            hasPermission = this.__isSuperUserOfDomain(connection, accessorResource, domainName);
        }
        return hasPermission;
    }

    @Override
    public void assertResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> resourceCreatePermissions) {
        if (!this.hasResourceCreatePermissions(accessorResource, resourceClassName, domainName, resourceCreatePermissions)) {
            throw NotAuthorizedException.newInstanceForResourceCreatePermissions(accessorResource, resourceCreatePermissions);
        }
    }

    @Override
    public void assertResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourceCreatePermission resourceCreatePermission, ResourceCreatePermission ... resourceCreatePermissions) {
        if (!this.hasResourceCreatePermissions(accessorResource, resourceClassName, domainName, resourceCreatePermission, resourceCreatePermissions)) {
            throw NotAuthorizedException.newInstanceForResourceCreatePermissions(accessorResource, resourceCreatePermission, resourceCreatePermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourceCreatePermissions);
        this.__assertPermissionsSetNotEmpty(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(resourceCreatePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResourceCreatePermissions(Resource accessorResource, String resourceClassName, String domainName, ResourceCreatePermission resourceCreatePermission, ResourceCreatePermission ... resourceCreatePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourceCreatePermission);
        this.__assertVarargPermissionsSpecified(resourceCreatePermissions);
        Set<ResourceCreatePermission> normalizedResourceCreatePermissions = SQLAccessControlContext.__normalizeResourceCreatePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourceCreatePermission, resourceCreatePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            domainName = domainName.trim();
            boolean bl = this.__hasResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName, normalizedResourceCreatePermissions);
            return bl;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private boolean __hasResourceCreatePermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourceCreatePermission> requestedResourceCreatePermissions) {
        this.__assertPermissionsValid(connection, resourceClassName, this.__getPostCreateResourcePermissions(requestedResourceCreatePermissions));
        this.__assertQueryAuthorization(connection, accessorResource);
        Set<ResourceCreatePermission> effectiveResourceCreatePermissions = this.__getEffectiveResourceCreatePermissions(connection, accessorResource, resourceClassName, domainName);
        boolean hasPermission = true;
        for (ResourceCreatePermission resourceCreatePermission : requestedResourceCreatePermissions) {
            if (this.__isPermissible(resourceCreatePermission, effectiveResourceCreatePermissions)) continue;
            hasPermission = false;
            break;
        }
        if (!hasPermission) {
            hasPermission = this.__isSuperUserOfDomain(connection, accessorResource, domainName);
        }
        return hasPermission;
    }

    private boolean __isPermissible(ResourceCreatePermission queriedResourceCreatePermission, Set<ResourceCreatePermission> resourceCreatePermissions) {
        for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
            if (!queriedResourceCreatePermission.equals(resourceCreatePermission) && !queriedResourceCreatePermission.isGrantableFrom(resourceCreatePermission)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getResourcesByResourcePermissions(Resource accessorResource, String resourceClassName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getResourcesByPermissions(connection, accessorResource, resourceClassName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getResourcesByResourcePermissions(Resource accessorResource, String resourceClassName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getResourcesByPermissions(connection, accessorResource, resourceClassName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<Resource> __getResourcesByPermissions(SQLConnection connection, Resource accessorResource, String resourceClassName, Set<ResourcePermission> requestedResourcePermissions) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        this.__assertPermissionsValid(connection, resourceClassName, requestedResourcePermissions);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ResourcePermission resourcePermission : requestedResourcePermissions) {
            HashSet<Resource> currentResources = new HashSet<Resource>();
            if (resourcePermission.isSystemPermission()) {
                currentResources.addAll(this.grantResourcePermissionSysPersister.getResourcesByResourceSysPermission(connection, accessorResource, resourceClassId, resourcePermission));
                currentResources.addAll(this.grantGlobalResourcePermissionSysPersister.getResourcesByGlobalSysPermission(connection, accessorResource, resourceClassId, resourcePermission));
            } else {
                Id<ResourcePermissionId> permissionId = this.resourceClassPermissionPersister.getResourceClassPermissionId(connection, resourceClassId, resourcePermission.getPermissionName());
                if (permissionId == null) {
                    throw new IllegalArgumentException("Permission: " + resourcePermission + " is not defined for resource class: " + resourceClassName);
                }
                currentResources.addAll(this.grantResourcePermissionPersister.getResourcesByResourcePermission(connection, accessorResource, resourceClassId, resourcePermission, permissionId));
                currentResources.addAll(this.grantGlobalResourcePermissionPersister.getResourcesByGlobalResourcePermission(connection, accessorResource, resourceClassId, resourcePermission, permissionId));
            }
            if (currentResources.isEmpty()) {
                resources = currentResources;
                break;
            }
            if (resources.isEmpty()) {
                resources = currentResources;
                continue;
            }
            resources.retainAll(currentResources);
            if (!resources.isEmpty()) continue;
            break;
        }
        resources.addAll(this.grantDomainPermissionSysPersister.getResourcesByDomainSuperUserPermission(connection, accessorResource, resourceClassId));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getResourcesByResourcePermissionsAndDomain(Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getResourcesByPermissionsAndDomain(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getResourcesByResourcePermissionsAndDomain(Resource accessorResource, String resourceClassName, String domainName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessorResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertDomainSpecified(domainName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessorResource = this.__resolveResource(connection, accessorResource);
            this.__assertQueryAuthorization(connection, accessorResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getResourcesByPermissionsAndDomain(connection, accessorResource, resourceClassName, domainName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<Resource> __getResourcesByPermissionsAndDomain(SQLConnection connection, Resource accessorResource, String resourceClassName, String domainName, Set<ResourcePermission> requestedResourcePermissions) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        Id<DomainId> domainId = this.domainPersister.getResourceDomainId(connection, domainName);
        if (domainId == null) {
            throw new IllegalArgumentException("Could not find domain: " + domainName);
        }
        this.__assertPermissionsValid(connection, resourceClassName, requestedResourcePermissions);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ResourcePermission resourcePermission : requestedResourcePermissions) {
            HashSet<Resource> currentResources = new HashSet<Resource>();
            if (resourcePermission.isSystemPermission()) {
                currentResources.addAll(this.grantResourcePermissionSysPersister.getResourcesByResourceSysPermission(connection, accessorResource, resourceClassId, domainId, resourcePermission));
                currentResources.addAll(this.grantGlobalResourcePermissionSysPersister.getResourcesByGlobalSysPermission(connection, accessorResource, resourceClassId, domainId, resourcePermission));
            } else {
                Id<ResourcePermissionId> permissionId = this.resourceClassPermissionPersister.getResourceClassPermissionId(connection, resourceClassId, resourcePermission.getPermissionName());
                if (permissionId == null) {
                    throw new IllegalArgumentException("Permission: " + resourcePermission + " is not defined for resource class: " + resourceClassName);
                }
                currentResources.addAll(this.grantResourcePermissionPersister.getResourcesByResourcePermission(connection, accessorResource, resourceClassId, domainId, resourcePermission, permissionId));
                currentResources.addAll(this.grantGlobalResourcePermissionPersister.getResourcesByGlobalResourcePermission(connection, accessorResource, resourceClassId, domainId, resourcePermission, permissionId));
            }
            if (currentResources.isEmpty()) {
                resources = currentResources;
                break;
            }
            if (resources.isEmpty()) {
                resources = currentResources;
                continue;
            }
            resources.retainAll(currentResources);
            if (!resources.isEmpty()) continue;
            break;
        }
        resources.addAll(this.grantDomainPermissionSysPersister.getResourcesByDomainSuperUserPermission(connection, accessorResource, resourceClassId, domainId));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getAccessorResourcesByResourcePermissions(Resource accessedResource, String resourceClassName, Set<ResourcePermission> resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessedResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertPermissionsSpecified(resourcePermissions);
        this.__assertPermissionsSetNotEmpty(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(resourcePermissions);
        try {
            connection = this.__getConnection();
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__assertQueryAuthorization(connection, accessedResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getAccessorResourcesByResourcePermissions(connection, accessedResource, resourceClassName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Resource> getAccessorResourcesByResourcePermissions(Resource accessedResource, String resourceClassName, ResourcePermission resourcePermission, ResourcePermission ... resourcePermissions) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceSpecified(accessedResource);
        this.__assertResourceClassSpecified(resourceClassName);
        this.__assertPermissionSpecified(resourcePermission);
        this.__assertVarargPermissionsSpecified(resourcePermissions);
        Set<ResourcePermission> normalizedResourcePermissions = SQLAccessControlContext.__normalizeResourcePermission(SQLAccessControlContext.__getSetWithoutNullsOrDuplicates(resourcePermission, resourcePermissions));
        try {
            connection = this.__getConnection();
            accessedResource = this.__resolveResource(connection, accessedResource);
            this.__assertQueryAuthorization(connection, accessedResource);
            resourceClassName = resourceClassName.trim();
            Set<Resource> set = this.__getAccessorResourcesByResourcePermissions(connection, accessedResource, resourceClassName, normalizedResourcePermissions);
            return set;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private Set<Resource> __getAccessorResourcesByResourcePermissions(SQLConnection connection, Resource accessedResource, String resourceClassName, Set<ResourcePermission> requestedResourcePermissions) {
        Id<ResourceClassId> resourceClassId = this.resourceClassPersister.getResourceClassId(connection, resourceClassName);
        if (resourceClassId == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        this.__assertPermissionsValid(connection, resourceClassName, requestedResourcePermissions);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ResourcePermission resourcePermission : requestedResourcePermissions) {
            HashSet<Resource> currentResources = new HashSet<Resource>();
            if (resourcePermission.isSystemPermission()) {
                currentResources.addAll(this.grantResourcePermissionSysPersister.getAccessorResourcesByResourceSysPermission(connection, accessedResource, resourceClassId, resourcePermission));
            } else {
                Id<ResourcePermissionId> permissionId = this.resourceClassPermissionPersister.getResourceClassPermissionId(connection, resourceClassId, resourcePermission.getPermissionName());
                if (permissionId == null) {
                    throw new IllegalArgumentException("Permission: " + resourcePermission + " is not defined for resource class: " + resourceClassName);
                }
                currentResources.addAll(this.grantResourcePermissionPersister.getAccessorResourcesByResourcePermission(connection, accessedResource, resourceClassId, resourcePermission, permissionId));
            }
            if (currentResources.isEmpty()) {
                resources = currentResources;
                break;
            }
            if (resources.isEmpty()) {
                resources = currentResources;
                continue;
            }
            resources.retainAll(currentResources);
            if (!resources.isEmpty()) continue;
            break;
        }
        return resources;
    }

    @Override
    public List<String> getResourceClassNames() {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        try {
            connection = this.__getConnection();
            List<String> list = this.resourceClassPersister.getResourceClassNames(connection);
            return list;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getResourcePermissionNames(String resourceClassName) {
        SQLConnection connection = null;
        this.__assertAuthenticated();
        this.__assertResourceClassSpecified(resourceClassName);
        try {
            connection = this.__getConnection();
            resourceClassName = resourceClassName.trim();
            List<String> list = this.__getApplicableResourcePermissionNames(connection, resourceClassName);
            return list;
        }
        finally {
            this.__closeConnection(connection);
        }
    }

    private static Set<DomainPermission> __normalizeDomainPermissions(Set<DomainPermission> domainPermissions) {
        HashSet<DomainPermission> normalizedPermissions = new HashSet<DomainPermission>(domainPermissions.size());
        for (DomainPermission domainPermission : domainPermissions) {
            normalizedPermissions.add(DomainPermissions.getInstance(domainPermission));
        }
        return normalizedPermissions;
    }

    private static Set<DomainCreatePermission> __normalizeDomainCreatePermissions(Set<DomainCreatePermission> domainCreatePermissions) {
        HashSet<DomainCreatePermission> normalizedPermissions = new HashSet<DomainCreatePermission>(domainCreatePermissions.size());
        for (DomainCreatePermission permission : domainCreatePermissions) {
            normalizedPermissions.add(DomainCreatePermissions.getInstance(permission));
        }
        return normalizedPermissions;
    }

    private static Set<ResourcePermission> __normalizeResourcePermission(Set<ResourcePermission> resourcePermissions) {
        HashSet<ResourcePermission> normalizedPermissions = new HashSet<ResourcePermission>(resourcePermissions.size());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            normalizedPermissions.add(ResourcePermissions.getInstance(resourcePermission));
        }
        return normalizedPermissions;
    }

    private static Set<ResourceCreatePermission> __normalizeResourceCreatePermission(Set<ResourceCreatePermission> resourceCreatePermissions) {
        HashSet<ResourceCreatePermission> normalizedPermissions = new HashSet<ResourceCreatePermission>(resourceCreatePermissions.size());
        for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
            normalizedPermissions.add(ResourceCreatePermissions.getInstance(resourceCreatePermission));
        }
        return normalizedPermissions;
    }

    private Resource __resolveResource(SQLConnection connection, Resource resource) {
        Resource resolvedResource;
        if (SQLAccessControlContext.__isEqual(this.sessionResource, resource)) {
            return this.sessionResource;
        }
        if (SQLAccessControlContext.__isEqual(this.authenticatedResource, resource)) {
            return this.authenticatedResource;
        }
        if (resource.getId() != null) {
            if (resource.getExternalId() != null) {
                resolvedResource = this.resourcePersister.resolveResourceByExternalId(connection, resource.getExternalId());
                if (resolvedResource == null || !resource.equals(resolvedResource)) {
                    throw new IllegalArgumentException("Resource " + resource + "'s id does not resolve to the specified externalId!");
                }
            } else {
                resolvedResource = this.resourcePersister.resolveResourceByResourceId(connection, resource);
                if (resolvedResource == null) {
                    throw new IllegalArgumentException("Resource " + resource + " not found!");
                }
            }
        } else if (resource.getExternalId() != null) {
            resolvedResource = this.resourcePersister.resolveResourceByExternalId(connection, resource.getExternalId());
            if (resolvedResource == null) {
                throw new IllegalArgumentException("Resource " + resource + " not found!");
            }
        } else {
            throw new IllegalArgumentException("A resource id and/or external id is required, but neither was specified");
        }
        return resolvedResource;
    }

    private static boolean __isEqual(Resource resource1, Resource resource2) {
        if (resource1 == resource2) {
            return true;
        }
        if (resource1 == null) {
            return false;
        }
        return SQLAccessControlContext.__isEqual(resource1.getId(), resource2.getId()) && SQLAccessControlContext.__isEqual(resource1.getExternalId(), resource2.getExternalId());
    }

    private static boolean __isEqual(Long long1, Long long2) {
        if (long1 == long2) {
            return true;
        }
        if (long1 == null) {
            return false;
        }
        return long1.equals(long2);
    }

    private static boolean __isEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private List<String> __getApplicableResourcePermissionNames(SQLConnection connection, String resourceClassName) {
        return this.__getApplicableResourcePermissionNames(connection, this.__getResourceClassInternalInfo(connection, resourceClassName));
    }

    private List<String> __getApplicableResourcePermissionNames(SQLConnection connection, ResourceClassInternalInfo resourceClassInternalInfo) {
        List<String> permissionNames = this.resourceClassPermissionPersister.getPermissionNames(connection, resourceClassInternalInfo.getResourceClassName());
        permissionNames.add(ResourcePermissions.INHERIT);
        permissionNames.add(ResourcePermissions.DELETE);
        permissionNames.add(ResourcePermissions.QUERY);
        if (resourceClassInternalInfo.isAuthenticatable()) {
            permissionNames.add(ResourcePermissions.IMPERSONATE);
            permissionNames.add(ResourcePermissions.RESET_CREDENTIALS);
        }
        return permissionNames;
    }

    private ResourceClassInternalInfo __getResourceClassInternalInfo(SQLConnection connection, String resourceClassName) {
        ResourceClassInternalInfo resourceClassInternalInfo = this.resourceClassPersister.getResourceClassInfo(connection, resourceClassName);
        if (resourceClassInternalInfo == null) {
            throw new IllegalArgumentException("Could not find resource class: " + resourceClassName);
        }
        return resourceClassInternalInfo;
    }

    private boolean __isSuperUserOfResource(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        return this.__isSuperUserOfDomain(connection, accessorResource, this.domainPersister.getResourceDomainNameByResourceId(connection, accessedResource));
    }

    private boolean __isSuperUserOfDomain(SQLConnection connection, Resource accessorResource, String queriedDomain) {
        Set<DomainPermission> domainPermissions = this.__getEffectiveDomainPermissions(connection, accessorResource, queriedDomain);
        return domainPermissions.contains(DomainPermission_SUPER_USER) || domainPermissions.contains(DomainPermission_SUPER_USER_GRANT);
    }

    private boolean __isSuperUserOfDomain(SQLConnection connection, Resource accessorResource, Id<DomainId> queriedDomainId) {
        Set<DomainPermission> domainPermissions = this.__getEffectiveDomainPermissions(connection, accessorResource, queriedDomainId);
        return domainPermissions.contains(DomainPermission_SUPER_USER) || domainPermissions.contains(DomainPermission_SUPER_USER_GRANT);
    }

    private Set<DomainPermission> __getPostCreateDomainPermissions(Set<DomainCreatePermission> domainCreatePermissions) {
        HashSet<DomainPermission> domainPermissions = new HashSet<DomainPermission>();
        for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
            if (domainCreatePermission.isSystemPermission()) continue;
            domainPermissions.add(domainCreatePermission.getPostCreateDomainPermission());
        }
        return domainPermissions;
    }

    private Set<ResourcePermission> __getPostCreateResourcePermissions(Set<ResourceCreatePermission> resourceCreatePermissions) {
        HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
        for (ResourceCreatePermission resourceCreatePermission : resourceCreatePermissions) {
            if (resourceCreatePermission.isSystemPermission()) continue;
            resourcePermissions.add(resourceCreatePermission.getPostCreateResourcePermission());
        }
        return resourcePermissions;
    }

    private static void __assertConnectionSpecified(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection required, none specified");
        }
    }

    private static void __assertDataSourceSpecified(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource required, none specified");
        }
    }

    private void __assertResourceSpecified(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Resource required, none specified");
        }
    }

    private void __assertCredentialsSpecified(Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("Credentials required, none specified");
        }
    }

    private void __assertCredentialsNotSpecified(Credentials credentials) {
        if (credentials != null) {
            throw new IllegalArgumentException("Credentials not supported, but specified for unauthenticatable resource class");
        }
    }

    private void __assertExternalIdSpecified(String externalId) {
        if (externalId == null) {
            throw new NullPointerException("External id required, none specified");
        }
        if (externalId.trim().isEmpty()) {
            throw new IllegalArgumentException("External id required, none specified");
        }
    }

    private void __assertDomainSpecified(String domainName) {
        if (domainName == null) {
            throw new NullPointerException("Domain required, none specified");
        }
        if (domainName.trim().isEmpty()) {
            throw new IllegalArgumentException("Domain required, none specified");
        }
    }

    private void __assertParentDomainSpecified(String domainName) {
        if (domainName == null) {
            throw new NullPointerException("Parent domain required, none specified");
        }
        if (domainName.trim().isEmpty()) {
            throw new IllegalArgumentException("Parent domain required, none specified");
        }
    }

    private void __assertAuthenticatedAsSystemResource() {
        if (this.sessionResource == null || !SYSTEM_RESOURCE_ID.equals(this.sessionResource.getId())) {
            throw NotAuthorizedException.newInstanceForAction(this.sessionResource, "perform operation reserved for the system resource");
        }
    }

    private void __assertAuthenticated() {
        if (this.sessionResource == null) {
            throw new NotAuthenticatedException("Session not authenticated");
        }
    }

    private void __assertResourceClassSpecified(String resourceClassName) {
        if (resourceClassName == null) {
            throw new NullPointerException("Resource class required, none specified");
        }
        if (resourceClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource class required, none specified");
        }
    }

    private void __assertPermissionSpecified(ResourcePermission resourcePermission) {
        if (resourcePermission == null) {
            throw new NullPointerException("Resource permission required, none specified");
        }
    }

    private void __assertVarargPermissionsSpecified(ResourcePermission ... resourcePermissions) {
        if (resourcePermissions == null) {
            throw new NullPointerException("An array or a sequence of resource permissions are required, but the null value was specified");
        }
    }

    private void __assertPermissionSpecified(ResourceCreatePermission resourceCreatePermission) {
        if (resourceCreatePermission == null) {
            throw new NullPointerException("Resource create permission required, none specified");
        }
    }

    private void __assertVarargPermissionsSpecified(ResourceCreatePermission ... resourceCreatePermissions) {
        if (resourceCreatePermissions == null) {
            throw new NullPointerException("An array or a sequence of resource create permissions are required, but the null value was specified");
        }
    }

    private void __assertPermissionSpecified(DomainCreatePermission domainCreatePermission) {
        if (domainCreatePermission == null) {
            throw new NullPointerException("Domain create permission required, none specified");
        }
    }

    private void __assertVarargPermissionsSpecified(DomainCreatePermission ... domainCreatePermissions) {
        if (domainCreatePermissions == null) {
            throw new NullPointerException("An array or a sequence of domain create permissions are required, but the null value was specified");
        }
    }

    private void __assertPermissionSpecified(DomainPermission domainPermission) {
        if (domainPermission == null) {
            throw new NullPointerException("Domain permission required, none specified");
        }
    }

    private void __assertVarargPermissionsSpecified(DomainPermission ... domainPermissions) {
        if (domainPermissions == null) {
            throw new NullPointerException("An array or a sequence of domain permissions are required, but the null value was specified");
        }
    }

    private void __assertPermissionsSpecified(Set permissionSet) {
        if (permissionSet == null) {
            throw new NullPointerException("Set of permissions required, none specified");
        }
        if (permissionSet.contains(null)) {
            throw new NullPointerException("Set of permissions contains null element");
        }
    }

    private void __assertPermissionsSetNotEmpty(Set permissionSet) {
        if (permissionSet.isEmpty()) {
            throw new IllegalArgumentException("Set of permissions required, empty set specified");
        }
    }

    private void __assertPermissionNameValid(String permissionName) {
        if (permissionName == null) {
            throw new NullPointerException("Permission name may not be null");
        }
        if (permissionName.trim().isEmpty()) {
            throw new IllegalArgumentException("Permission name may not be blank");
        }
        if (permissionName.trim().startsWith("*")) {
            throw new IllegalArgumentException("Permission name may not start with asterisk '*'");
        }
    }

    private void __assertResourceClassNameValid(String resourceClassName) {
        if (resourceClassName == null) {
            throw new NullPointerException("Resource class name may not be null");
        }
        if (resourceClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource class name may not be blank");
        }
    }

    private void __assertPermissionsValid(SQLConnection connection, String resourceClassName, Set<ResourcePermission> resourcePermissions) {
        List<String> permissionNames = this.__getApplicableResourcePermissionNames(connection, resourceClassName);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (permissionNames.contains(resourcePermission.getPermissionName())) continue;
            if (resourcePermission.isSystemPermission()) {
                throw new IllegalArgumentException("Permission " + resourcePermission.getPermissionName() + " not valid for unauthenticatable resource class " + resourceClassName);
            }
            throw new IllegalArgumentException("Permission: " + resourcePermission.getPermissionName() + " is not defined for resource class: " + resourceClassName);
        }
    }

    private void __assertQueryAuthorization(SQLConnection connection, Resource accessorResource) {
        Set<ResourcePermission> effectiveResourcePermissions;
        if (!(this.sessionResource.equals(accessorResource) || (effectiveResourcePermissions = this.__getEffectiveResourcePermissions(connection, this.sessionResource, accessorResource)).contains(ResourcePermission_QUERY) || effectiveResourcePermissions.contains(ResourcePermission_QUERY_GRANT) || effectiveResourcePermissions.contains(ResourcePermission_IMPERSONATE) || effectiveResourcePermissions.contains(ResourcePermission_IMPERSONATE_GRANT))) {
            throw NotAuthorizedException.newInstanceForActionOnResource(this.sessionResource, "query", accessorResource);
        }
    }

    @SafeVarargs
    private static <T> Set<T> __getSetWithoutNullsOrDuplicates(T firstElement, T ... elements) {
        if (elements == null) {
            throw new NullPointerException("An array or a sequence of arguments are required, but none were specified");
        }
        HashSet<T> resultSet = new HashSet<T>(elements.length + 1);
        resultSet.add(firstElement);
        for (T element : elements) {
            if (element == null) {
                throw new NullPointerException("A " + elements.getClass().getSimpleName() + " argument (or sequence of varargs) without null elements is required, but received: " + Arrays.asList(elements));
            }
            if (resultSet.add(element)) continue;
            throw new IllegalArgumentException("Duplicate element: " + element);
        }
        return resultSet;
    }

    private SQLConnection __getConnection() {
        if (this.dataSource != null) {
            try {
                return new SQLConnection(this.dataSource.getConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.connection != null) {
            return new SQLConnection(this.connection);
        }
        throw new IllegalStateException("Not initialized! No data source or connection, perhaps missing call to postDeserialize()?");
    }

    private void __closeConnection(SQLConnection connection) {
        if (this.dataSource != null && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

