/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal;

import com.acciente.oacc.AuthenticationProvider;
import com.acciente.oacc.Credentials;
import com.acciente.oacc.DomainCreatePermissions;
import com.acciente.oacc.DomainPermissions;
import com.acciente.oacc.PasswordCredentials;
import com.acciente.oacc.Resources;
import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.sql.internal.SQLPasswordAuthenticationProvider;
import com.acciente.oacc.sql.internal.SchemaNameValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLAccessControlSystemInitializer {
    public static void initializeOACC(Connection connection, String dbSchema, char[] oaccRootPwd, PasswordEncryptor passwordEncryptor) throws SQLException {
        SQLAccessControlSystemInitializer.initializeOACC(connection, dbSchema, oaccRootPwd, passwordEncryptor, false);
    }

    public static void initializeOACC(Connection connection, String dbSchema, char[] oaccRootPwd, PasswordEncryptor passwordEncryptor, boolean isSilent) throws SQLException {
        SQLPasswordAuthenticationProvider authProvider = new SQLPasswordAuthenticationProvider(connection, dbSchema, passwordEncryptor);
        PasswordCredentials oaccRootCredentials = PasswordCredentials.newInstance(oaccRootPwd);
        SQLAccessControlSystemInitializer.initializeOACC(connection, dbSchema, oaccRootCredentials, authProvider, isSilent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeOACC(Connection connection, String dbSchema, Credentials oaccRootCredentials, AuthenticationProvider authProvider, boolean isSilent) throws SQLException {
        String schemaNameAndTablePrefix;
        SchemaNameValidator.assertValid(dbSchema);
        String string = schemaNameAndTablePrefix = dbSchema != null ? dbSchema + ".OAC_" : "OAC_";
        if (!isSilent) {
            System.out.println("Checking database...needs empty tables");
        }
        try (Statement statement = null;){
            statement = connection.prepareStatement("SELECT  DomainId FROM " + schemaNameAndTablePrefix + "Domain WHERE DomainId = 0");
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                if (!isSilent) {
                    System.out.println("Cannot initialize, likely that this OACC is already initialized! (check: found a system domain)");
                }
                resultSet.close();
                return;
            }
            statement.close();
            if (!isSilent) {
                System.out.println("Initializing database...assuming empty tables (will fail safely if tables have data)");
            }
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "Domain( DomainId, DomainName ) VALUES ( 0, ? )");
            statement.setString(1, "SYSDOMAIN");
            statement.executeUpdate();
            statement.close();
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "ResourceClass( ResourceClassId, ResourceClassName, IsAuthenticatable, IsUnauthenticatedCreateAllowed ) VALUES ( 0, ?, 1, 0 )");
            statement.setString(1, "SYSOBJECT");
            statement.executeUpdate();
            statement.close();
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "Resource( ResourceId, ResourceClassId, DomainId ) VALUES ( 0, 0, 0 )");
            statement.executeUpdate();
            statement.close();
            authProvider.setCredentials(Resources.getInstance(0L), oaccRootCredentials);
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "Grant_DomPerm_Sys( AccessorResourceId, GrantorResourceId, AccessedDomainId, SysPermissionId, IsWithGrant )" + " VALUES ( 0, 0, 0, ?, 1 )");
            statement.setLong(1, DomainPermissions.getInstance(DomainPermissions.SUPER_USER).getSystemPermissionId());
            statement.executeUpdate();
            statement.close();
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "Grant_DomCrPerm_Sys( AccessorResourceId, GrantorResourceId, SysPermissionId, IsWithGrant )" + " VALUES ( 0, 0, ?, 1 )");
            statement.setLong(1, DomainCreatePermissions.getInstance(DomainCreatePermissions.CREATE).getSystemPermissionId());
            statement.executeUpdate();
            statement.close();
            statement = connection.prepareStatement("INSERT INTO " + schemaNameAndTablePrefix + "Grant_DomCrPerm_PostCr_Sys( AccessorResourceId, GrantorResourceId, PostCreateSysPermissionId, PostCreateIsWithGrant, IsWithGrant )" + " VALUES ( 0, 0, ?, 1, 1 )");
            statement.setLong(1, DomainPermissions.getInstance(DomainPermissions.SUPER_USER).getSystemPermissionId());
            statement.executeUpdate();
            statement.setLong(1, DomainPermissions.getInstance(DomainPermissions.CREATE_CHILD_DOMAIN).getSystemPermissionId());
            statement.executeUpdate();
            statement.setLong(1, DomainPermissions.getInstance(DomainPermissions.DELETE).getSystemPermissionId());
            statement.executeUpdate();
            statement.close();
        }
    }
}

