/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal;

import com.acciente.oacc.AuthenticationProvider;
import com.acciente.oacc.Credentials;
import com.acciente.oacc.IncorrectCredentialsException;
import com.acciente.oacc.InvalidCredentialsException;
import com.acciente.oacc.PasswordCredentials;
import com.acciente.oacc.Resource;
import com.acciente.oacc.UnsupportedCredentialsException;
import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.sql.internal.PasswordUtils;
import com.acciente.oacc.sql.internal.persister.ResourcePasswordPersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLPasswordStrings;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SQLPasswordAuthenticationProvider
implements AuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 2L;
    private transient DataSource dataSource;
    private transient Connection connection;
    private final PasswordEncryptor passwordEncryptor;
    private final ResourcePasswordPersister resourcePasswordPersister;

    protected SQLPasswordAuthenticationProvider(Connection connection, String schemaName, PasswordEncryptor passwordEncryptor) {
        this(schemaName, passwordEncryptor);
        this.connection = connection;
    }

    protected SQLPasswordAuthenticationProvider(DataSource dataSource, String schemaName, PasswordEncryptor passwordEncryptor) {
        this(schemaName, passwordEncryptor);
        this.dataSource = dataSource;
    }

    private SQLPasswordAuthenticationProvider(String schemaName, PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
        SQLPasswordStrings sqlPasswordStrings = SQLPasswordStrings.getSQLPasswordStrings(schemaName);
        this.resourcePasswordPersister = new ResourcePasswordPersister(sqlPasswordStrings);
    }

    protected void postDeserialize(DataSource dataSource) {
        if (this.dataSource != null || this.connection != null) {
            throw new IllegalStateException("Cannot re-initialize an already initialized SQLPasswordAuthenticationProvider");
        }
        this.dataSource = dataSource;
        this.connection = null;
    }

    protected void postDeserialize(Connection connection) {
        if (this.dataSource != null || this.connection != null) {
            throw new IllegalStateException("Cannot re-initialize an already initialized SQLPasswordAuthenticationProvider");
        }
        this.dataSource = null;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(Resource resource, Credentials credentials) {
        this.assertCredentialSpecified(credentials);
        this.assertSupportedCredentials(credentials);
        PasswordCredentials passwordCredentials = (PasswordCredentials)credentials;
        if (passwordCredentials.getPassword() == null) {
            throw new InvalidCredentialsException("Password required, none specified");
        }
        SQLConnection connection = null;
        try {
            connection = this.getConnection();
            this.__authenticate(connection, resource, passwordCredentials.getPassword());
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    public void authenticate(Resource resource) {
        throw new UnsupportedOperationException("The built-in password authentication provider does not support authentication without credentials");
    }

    @Override
    public Resource authenticate(Credentials credentials) {
        throw new UnsupportedOperationException("The built-in password authentication provider does not support authentication using *only* credentials");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __authenticate(SQLConnection connection, Resource resource, char[] password) {
        String encryptedBoundPassword = this.resourcePasswordPersister.getEncryptedBoundPasswordByResourceId(connection, resource);
        char[] plainBoundPassword = null;
        try {
            plainBoundPassword = PasswordUtils.computeBoundPassword(resource, password);
            if (!this.passwordEncryptor.checkPassword(plainBoundPassword, encryptedBoundPassword)) {
                throw new IncorrectCredentialsException("Invalid password for resource " + resource);
            }
        }
        finally {
            PasswordUtils.cleanPassword(plainBoundPassword);
        }
    }

    @Override
    public void validateCredentials(String resourceClassName, String domainName, Credentials credentials) {
        if (credentials == null) {
            throw new InvalidCredentialsException("Credentials required, none specified");
        }
        this.assertSupportedCredentials(credentials);
        char[] password = ((PasswordCredentials)credentials).getPassword();
        if (password == null) {
            throw new InvalidCredentialsException("Password required, none specified");
        }
        if (password.length == 0) {
            throw new InvalidCredentialsException("Password cannot be zero length");
        }
        if (this.isBlank(password)) {
            throw new InvalidCredentialsException("Password cannot be blank");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredentials(Resource resource, Credentials credentials) {
        this.assertCredentialSpecified(credentials);
        this.assertSupportedCredentials(credentials);
        PasswordCredentials passwordCredentials = (PasswordCredentials)credentials;
        SQLConnection connection = null;
        try {
            connection = this.getConnection();
            this.__setResourcePassword(connection, resource, passwordCredentials.getPassword());
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    public void deleteCredentials(Resource resource) {
        SQLConnection connection = null;
        try {
            connection = this.getConnection();
            this.resourcePasswordPersister.removeEncryptedBoundPasswordByResourceId(connection, resource);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __setResourcePassword(SQLConnection connection, Resource resource, char[] newPassword) {
        char[] newBoundPassword = null;
        try {
            newBoundPassword = PasswordUtils.computeBoundPassword(resource, newPassword);
            String newEncryptedBoundPassword = this.passwordEncryptor.encryptPassword(newBoundPassword);
            this.resourcePasswordPersister.setEncryptedBoundPasswordByResourceId(connection, resource, newEncryptedBoundPassword);
        }
        finally {
            PasswordUtils.cleanPassword(newBoundPassword);
        }
    }

    private void assertCredentialSpecified(Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("Credentials required, none specified");
        }
    }

    private void assertSupportedCredentials(Credentials credentials) {
        if (!(credentials instanceof PasswordCredentials)) {
            throw new UnsupportedCredentialsException(credentials.getClass());
        }
    }

    private boolean isBlank(char[] charArray) {
        for (char c : charArray) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private SQLConnection getConnection() {
        if (this.dataSource != null) {
            try {
                return new SQLConnection(this.dataSource.getConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.connection != null) {
            return new SQLConnection(this.connection);
        }
        throw new IllegalStateException("Not initialized! No data source or connection - don't forget to re-initialize after deserialization!");
    }

    private void closeConnection(SQLConnection connection) {
        if (this.dataSource != null && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

