/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal;

import java.util.regex.Pattern;

public class SchemaNameValidator {
    public static final String OPTIONALLY_DELIMITED_UNICODE_WORD_REGEX = "(?U)^\\w+|^\"\\w+\"|^'\\w+'|^\\[\\w+\\]|^`\\w+`";
    public static final Pattern OPTIONALLY_DELIMITED_UNICODE_WORD_PATTERN = Pattern.compile("(?U)^\\w+|^\"\\w+\"|^'\\w+'|^\\[\\w+\\]|^`\\w+`");

    public static boolean isValid(String schemaName) {
        return schemaName == null || OPTIONALLY_DELIMITED_UNICODE_WORD_PATTERN.matcher(schemaName).matches();
    }

    public static void assertValid(String schemaName) {
        if (!SchemaNameValidator.isValid(schemaName)) {
            throw new IllegalArgumentException("Invalid database schema name - it can only consist of (optionally delimited) unicode word characters, or be null, but it was: " + schemaName);
        }
    }
}

