/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.encryptor;

import com.acciente.oacc.encryptor.PasswordEncryptor;
import com.acciente.oacc.encryptor.bcrypt.BCryptPasswordEncryptor;
import com.acciente.oacc.encryptor.jasypt.JasyptPasswordEncryptor;
import java.util.Arrays;
import java.util.List;

public class PasswordEncryptors {
    private static final int BCRYPT_MIN_COST_FACTOR = 10;
    private static final String JASYPT_ALGORITHM = "SHA-256";
    private static final int JASYPT_ITERATIONS = 100000;
    private static final int JASYPT_SALT_SIZE_BYTES = 16;

    public static PasswordEncryptor getPasswordEncryptor(String encryptorName) {
        if (encryptorName == null) {
            throw new IllegalArgumentException("Encryptor name cannot be null");
        }
        if (encryptorName.equalsIgnoreCase("bcrypt")) {
            return BCryptPasswordEncryptor.newInstance(10);
        }
        if (encryptorName.equalsIgnoreCase("jasypt")) {
            return JasyptPasswordEncryptor.newInstance(JASYPT_ALGORITHM, 100000, 16);
        }
        throw new IllegalArgumentException("Encryptor name " + encryptorName + " not recognized");
    }

    public static List<String> getSupportedEncryptorNames() {
        return Arrays.asList("bcrypt", "jasypt");
    }
}

