/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.DomainPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Set;

public abstract class CommonDomainPersister
extends Persister
implements DomainPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonDomainPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public Id<DomainId> getResourceDomainId(SQLConnection connection, String resourceDomainName) {
        Id<DomainId> id;
        SQLStatement statement = null;
        if (resourceDomainName == null) {
            throw new IllegalArgumentException("Domain name must not be null");
        }
        try {
            Id<DomainId> resourceDomainId = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DomainID_BY_ResourceDomainName);
            statement.setString(1, resourceDomainName.trim());
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resourceDomainId = resultSet.getResourceDomainId("DomainId");
            }
            id = resourceDomainId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonDomainPersister.closeStatement(statement);
        return id;
    }

    @Override
    public String getResourceDomainNameByResourceId(SQLConnection connection, Resource resource) {
        String string;
        SQLStatement statement = null;
        try {
            String resourceDomainName = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_ResourceDomainName_BY_ResourceID);
            statement.setResourceId(1, resource);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resourceDomainName = resultSet.getString("DomainName");
            }
            if (resourceDomainName == null) {
                throw new IllegalArgumentException("Could not determine domain for resource: " + resource);
            }
            string = resourceDomainName;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonDomainPersister.closeStatement(statement);
        return string;
    }

    @Override
    public abstract Set<String> getResourceDomainNameDescendants(SQLConnection var1, String var2);

    @Override
    public void addResourceDomain(SQLConnection connection, String resourceDomainName) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInDomain_WITH_ResourceDomainName);
            statement.setString(1, resourceDomainName);
            this.assertOneRowInserted(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonDomainPersister.closeStatement(statement);
    }

    @Override
    public void addResourceDomain(SQLConnection connection, String resourceDomainName, Id<DomainId> parentResourceDomainId) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInDomain_WITH_ResourceDomainName_ParentDomainID);
            statement.setString(1, resourceDomainName);
            statement.setResourceDomainId(2, parentResourceDomainId);
            this.assertOneRowInserted(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonDomainPersister.closeStatement(statement);
    }

    @Override
    public abstract void deleteDomain(SQLConnection var1, Id<DomainId> var2);
}

