/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.DomainCreatePermission;
import com.acciente.oacc.DomainCreatePermissions;
import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantDomainCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class CommonGrantDomainCreatePermissionSysPersister
extends Persister
implements GrantDomainCreatePermissionSysPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantDomainCreatePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<DomainCreatePermission> getDomainCreateSysPermissionsIncludeInherited(SQLConnection var1, Resource var2);

    @Override
    public Set<DomainCreatePermission> getDomainCreateSysPermissions(SQLConnection connection, Resource accessorResource) {
        HashSet<DomainCreatePermission> hashSet;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainCreatePermissionSys_withoutInheritance_SysPermissionID_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            HashSet<DomainCreatePermission> domainCreatePermissions = new HashSet<DomainCreatePermission>();
            while (resultSet.next()) {
                domainCreatePermissions.add(CommonGrantDomainCreatePermissionSysPersister.getDomainCreateSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = domainCreatePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    protected static DomainCreatePermission getDomainCreateSysPermission(SQLResult resultSet) throws SQLException {
        String sysPermissionName = resultSet.getDomainCreateSysPermissionName("SysPermissionId");
        if (resultSet.getBoolean("IsWithGrant")) {
            return DomainCreatePermissions.getInstanceWithGrantOption(sysPermissionName);
        }
        return DomainCreatePermissions.getInstance(sysPermissionName);
    }

    @Override
    public void addDomainCreateSysPermissions(SQLConnection connection, Resource accessorResource, Resource grantorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantDomainCreatePermissionSys_WITH_AccessorID_GrantorID_IsWithGrant_SysPermissionID);
            for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
                if (!domainCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setBoolean(3, domainCreatePermission.isWithGrantOption());
                statement.setDomainCreateSystemPermissionId(4, domainCreatePermission.getSystemPermissionId());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void updateDomainCreateSysPermissions(SQLConnection connection, Resource accessorResource, Resource grantorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantDomainCreatePermissionSys_SET_GrantorID_IsWithGrant_BY_AccessorID_SysPermissionID);
            for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
                if (!domainCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, domainCreatePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setDomainCreateSystemPermissionId(4, domainCreatePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeDomainCreateSysPermissions(SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainCreatePermissionSys_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeDomainCreateSysPermissions(SQLConnection connection, Resource accessorResource, Set<DomainCreatePermission> domainCreatePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainCreatePermissionSys_BY_AccessorID_SysPermissionID);
            for (DomainCreatePermission domainCreatePermission : domainCreatePermissions) {
                if (!domainCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setDomainCreateSystemPermissionId(2, domainCreatePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainCreatePermissionSysPersister.closeStatement(statement);
    }
}

