/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.DomainPermission;
import com.acciente.oacc.DomainPermissions;
import com.acciente.oacc.Resource;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantDomainPermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonGrantDomainPermissionSysPersister
extends Persister
implements GrantDomainPermissionSysPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;
    public static final DomainPermission DOMAIN_PERMISSION_SUPER_USER = DomainPermissions.getInstance(DomainPermissions.SUPER_USER);

    public CommonGrantDomainPermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3);

    @Override
    public abstract Set<Resource> getResourcesByDomainSuperUserPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4);

    @Override
    public abstract Set<DomainPermission> getDomainSysPermissionsIncludeInherited(SQLConnection var1, Resource var2, Id<DomainId> var3);

    @Override
    public Set<DomainPermission> getDomainSysPermissions(SQLConnection connection, Resource accessorResource, Id<DomainId> resourceDomainId) {
        HashSet<DomainPermission> hashSet;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_SysPermissionID_IsWithGrant_BY_AccessorID_DomainID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            SQLResult resultSet = statement.executeQuery();
            HashSet<DomainPermission> domainPermissions = new HashSet<DomainPermission>();
            while (resultSet.next()) {
                domainPermissions.add(CommonGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = domainPermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public abstract Map<String, Set<DomainPermission>> getDomainSysPermissionsIncludeInherited(SQLConnection var1, Resource var2);

    @Override
    public Map<String, Set<DomainPermission>> getDomainSysPermissions(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Set<DomainPermission>> hashMap;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantDomainPermissionSys_withoutInheritance_ResourceDomainName_SysPermissionID_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            HashMap<String, Set<DomainPermission>> domainPermissionsMap = new HashMap<String, Set<DomainPermission>>();
            while (resultSet.next()) {
                String resourceDomainName = resultSet.getString("DomainName");
                HashSet<DomainPermission> domainPermissions = (HashSet<DomainPermission>)domainPermissionsMap.get(resourceDomainName);
                if (domainPermissions == null) {
                    domainPermissions = new HashSet<DomainPermission>();
                    domainPermissionsMap.put(resourceDomainName, domainPermissions);
                }
                domainPermissions.add(CommonGrantDomainPermissionSysPersister.getDomainSysPermission(resultSet));
            }
            resultSet.close();
            hashMap = domainPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    protected static DomainPermission getDomainSysPermission(SQLResult resultSet) throws SQLException {
        String sysPermissionName = resultSet.getDomainSysPermissionName("SysPermissionId");
        if (resultSet.getBoolean("IsWithGrant")) {
            return DomainPermissions.getInstanceWithGrantOption(sysPermissionName);
        }
        return DomainPermissions.getInstance(sysPermissionName);
    }

    @Override
    public void addDomainSysPermissions(SQLConnection connection, Resource accessorResource, Resource grantorResource, Id<DomainId> resourceDomainId, Set<DomainPermission> requestedDomainPermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantDomainPermissionSys_WITH_AccessorID_GrantorID_AccessedDomainID_IsWithGrant_SysPermissionID);
            for (DomainPermission domainPermission : requestedDomainPermissions) {
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceDomainId(3, resourceDomainId);
                statement.setBoolean(4, domainPermission.isWithGrantOption());
                statement.setDomainSystemPermissionId(5, domainPermission.getSystemPermissionId());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void updateDomainSysPermissions(SQLConnection connection, Resource accessorResource, Resource grantorResource, Id<DomainId> resourceDomainId, Set<DomainPermission> requestedDomainPermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantDomainPermissionSys_SET_GrantorID_IsWithGrant_BY_AccessorID_AccessedDomainID_SysPermissionID);
            for (DomainPermission domainPermission : requestedDomainPermissions) {
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, domainPermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceDomainId(4, resourceDomainId);
                statement.setDomainSystemPermissionId(5, domainPermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeAllDomainSysPermissions(SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
    }

    @Override
    public abstract void removeAllDomainSysPermissions(SQLConnection var1, Id<DomainId> var2);

    @Override
    public void removeDomainSysPermissions(SQLConnection connection, Resource accessorResource, Id<DomainId> resourceDomainId) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_BY_AccessorID_AccessedDomainID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeDomainSysPermissions(SQLConnection connection, Resource accessorResource, Id<DomainId> resourceDomainId, Set<DomainPermission> requestedDomainPermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantDomainPermissionSys_BY_AccessorID_AccessedDomainID_SysPermissionID);
            for (DomainPermission domainPermission : requestedDomainPermissions) {
                statement.setResourceId(1, accessorResource);
                statement.setResourceDomainId(2, resourceDomainId);
                statement.setDomainSystemPermissionId(3, domainPermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantDomainPermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantDomainPermissionSysPersister.closeStatement(statement);
    }
}

