/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantGlobalResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonGrantGlobalResourcePermissionPersister
extends Persister
implements GrantGlobalResourcePermissionPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantGlobalResourcePermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<Resource> getResourcesByGlobalResourcePermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, ResourcePermission var4, Id<ResourcePermissionId> var5);

    @Override
    public abstract Set<Resource> getResourcesByGlobalResourcePermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4, ResourcePermission var5, Id<ResourcePermissionId> var6);

    @Override
    public abstract Set<ResourcePermission> getGlobalResourcePermissionsIncludeInherited(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4);

    @Override
    public Set<ResourcePermission> getGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_withoutInheritance_PermissionName_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(CommonGrantGlobalResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    protected static ResourcePermission getResourcePermission(SQLResult resultSet) throws SQLException {
        String permissionName = resultSet.getString("PermissionName");
        if (resultSet.getBoolean("IsWithGrant")) {
            return ResourcePermissions.getInstanceWithGrantOption(permissionName);
        }
        return ResourcePermissions.getInstance(permissionName);
    }

    @Override
    public abstract Map<String, Map<String, Set<ResourcePermission>>> getGlobalResourcePermissionsIncludeInherited(SQLConnection var1, Resource var2);

    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getGlobalResourcePermissions(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourcePermission>>> hashMap;
        SQLStatement statement = null;
        try {
            HashMap<String, Map<String, Set<ResourcePermission>>> globalPermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermission_withoutInheritance_ResourceDomainName_ResourceClassName_PermissionName_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashSet<ResourcePermission> resourcePermissionsForResourceClass;
                String resourceDomainName = resultSet.getString("DomainName");
                String resourceClassName = resultSet.getString("ResourceClassName");
                HashMap<String, HashSet<ResourcePermission>> permissionsForResourceDomain = (HashMap<String, HashSet<ResourcePermission>>)globalPermissionsMap.get(resourceDomainName);
                if (permissionsForResourceDomain == null) {
                    permissionsForResourceDomain = new HashMap<String, HashSet<ResourcePermission>>();
                    globalPermissionsMap.put(resourceDomainName, permissionsForResourceDomain);
                }
                if ((resourcePermissionsForResourceClass = (HashSet<ResourcePermission>)permissionsForResourceDomain.get(resourceClassName)) == null) {
                    resourcePermissionsForResourceClass = new HashSet<ResourcePermission>();
                    permissionsForResourceDomain.put(resourceClassName, resourcePermissionsForResourceClass);
                }
                resourcePermissionsForResourceClass.add(CommonGrantGlobalResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashMap = globalPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void addGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantGlobalResourcePermission_WITH_AccessorID_GrantorID_AccessedDomainID_IsWithGrant_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceDomainId(3, accessedResourceDomainId);
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setString(6, resourcePermission.getPermissionName());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void updateGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantGlobalResourcePermission_SET_GrantorID_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, resourcePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceDomainId(4, accessedResourceDomainId);
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setString(6, resourcePermission.getPermissionName());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void removeAllGlobalResourcePermissions(SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermission_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public abstract void removeAllGlobalResourcePermissions(SQLConnection var1, Id<DomainId> var2);

    @Override
    public void removeGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermission_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, accessedResourceDomainId);
            statement.setResourceClassId(3, accessedResourceClassId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void removeGlobalResourcePermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermission_BY_AccessorID_AccessedDomainID_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceDomainId(2, accessedResourceDomainId);
                statement.setResourceClassId(3, accessedResourceClassId);
                statement.setString(4, resourcePermission.getPermissionName());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionPersister.closeStatement(statement);
    }
}

