/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantGlobalResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonGrantGlobalResourcePermissionSysPersister
extends Persister
implements GrantGlobalResourcePermissionSysPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantGlobalResourcePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<Resource> getResourcesByGlobalSysPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, ResourcePermission var4);

    @Override
    public abstract Set<Resource> getResourcesByGlobalSysPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4, ResourcePermission var5);

    @Override
    public abstract Set<ResourcePermission> getGlobalSysPermissionsIncludeInherited(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4);

    @Override
    public Set<ResourcePermission> getGlobalSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_SysPermissionID_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(CommonGrantGlobalResourcePermissionSysPersister.getResourceSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    protected static ResourcePermission getResourceSysPermission(SQLResult resultSet) throws SQLException {
        String sysPermissionName = resultSet.getResourceSysPermissionName("SysPermissionId");
        if (resultSet.getBoolean("IsWithGrant")) {
            return ResourcePermissions.getInstanceWithGrantOption(sysPermissionName);
        }
        return ResourcePermissions.getInstance(sysPermissionName);
    }

    @Override
    public abstract Map<String, Map<String, Set<ResourcePermission>>> getGlobalSysPermissionsIncludeInherited(SQLConnection var1, Resource var2);

    @Override
    public Map<String, Map<String, Set<ResourcePermission>>> getGlobalSysPermissions(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourcePermission>>> hashMap;
        SQLStatement statement = null;
        try {
            HashMap<String, Map<String, Set<ResourcePermission>>> globalSysPermissionsMap = new HashMap<String, Map<String, Set<ResourcePermission>>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantGlobalResourcePermissionSys_withoutInheritance_ResourceDomainName_ResourceClassName_SysPermissionID_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashSet<ResourcePermission> resourcePermissionsForResourceClass;
                String resourceDomainName = resultSet.getString("DomainName");
                String resourceClassName = resultSet.getString("ResourceClassName");
                HashMap<String, HashSet<ResourcePermission>> permissionsForResourceDomain = (HashMap<String, HashSet<ResourcePermission>>)globalSysPermissionsMap.get(resourceDomainName);
                if (permissionsForResourceDomain == null) {
                    permissionsForResourceDomain = new HashMap<String, HashSet<ResourcePermission>>();
                    globalSysPermissionsMap.put(resourceDomainName, permissionsForResourceDomain);
                }
                if ((resourcePermissionsForResourceClass = (HashSet<ResourcePermission>)permissionsForResourceDomain.get(resourceClassName)) == null) {
                    resourcePermissionsForResourceClass = new HashSet<ResourcePermission>();
                    permissionsForResourceDomain.put(resourceClassName, resourcePermissionsForResourceClass);
                }
                resourcePermissionsForResourceClass.add(CommonGrantGlobalResourcePermissionSysPersister.getResourceSysPermission(resultSet));
            }
            resultSet.close();
            hashMap = globalSysPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    @Override
    public void addGlobalSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantGlobalResourcePermissionSys_WITH_AccessorID_GrantorID_AccessedDomainID_IsWithGrant_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceDomainId(3, accessedResourceDomainId);
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceSystemPermissionId(6, resourcePermission.getSystemPermissionId());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void updateGlobalSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantGlobalResourcePermissionSys_SET_GrantorID_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, resourcePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceDomainId(4, accessedResourceDomainId);
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceSystemPermissionId(6, resourcePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeAllGlobalSysPermissions(SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermissionSys_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public abstract void removeAllGlobalSysPermissions(SQLConnection var1, Id<DomainId> var2);

    @Override
    public void removeGlobalSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermissionSys_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, accessedResourceDomainId);
            statement.setResourceClassId(3, accessedResourceClassId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeGlobalSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourcePermission> requestedResourcePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantGlobalResourcePermissionSys_BY_AccessorID_AccessedDomainID_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceDomainId(2, accessedResourceDomainId);
                statement.setResourceClassId(3, accessedResourceClassId);
                statement.setResourceSystemPermissionId(4, resourcePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantGlobalResourcePermissionSysPersister.closeStatement(statement);
    }
}

