/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourceCreatePermission;
import com.acciente.oacc.ResourceCreatePermissions;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantResourceCreatePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonGrantResourceCreatePermissionSysPersister
extends Persister
implements GrantResourceCreatePermissionSysPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantResourceCreatePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<ResourceCreatePermission> getResourceCreateSysPermissionsIncludeInherited(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4);

    @Override
    public abstract Map<String, Map<String, Set<ResourceCreatePermission>>> getResourceCreateSysPermissionsIncludeInherited(SQLConnection var1, Resource var2);

    @Override
    public Map<String, Map<String, Set<ResourceCreatePermission>>> getResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource) {
        HashMap<String, Map<String, Set<ResourceCreatePermission>>> hashMap;
        SQLStatement statement = null;
        try {
            HashMap<String, Map<String, Set<ResourceCreatePermission>>> createSysPermissionsMap = new HashMap<String, Map<String, Set<ResourceCreatePermission>>>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourceCreatePermissionSys_withoutInheritance_ResourceDomainName_ResourceClassName_SysPermissionId_IsWithGrant_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashSet<ResourceCreatePermission> permissionsForResourceClass;
                String resourceDomainName = resultSet.getString("DomainName");
                String resourceClassName = resultSet.getString("ResourceClassName");
                HashMap<String, HashSet<ResourceCreatePermission>> permissionsForResourceDomain = (HashMap<String, HashSet<ResourceCreatePermission>>)createSysPermissionsMap.get(resourceDomainName);
                if (permissionsForResourceDomain == null) {
                    permissionsForResourceDomain = new HashMap<String, HashSet<ResourceCreatePermission>>();
                    createSysPermissionsMap.put(resourceDomainName, permissionsForResourceDomain);
                }
                if ((permissionsForResourceClass = (HashSet<ResourceCreatePermission>)permissionsForResourceDomain.get(resourceClassName)) == null) {
                    permissionsForResourceClass = new HashSet<ResourceCreatePermission>();
                    permissionsForResourceDomain.put(resourceClassName, permissionsForResourceClass);
                }
                permissionsForResourceClass.add(CommonGrantResourceCreatePermissionSysPersister.getResourceCreateSysPermission(resultSet));
            }
            resultSet.close();
            hashMap = createSysPermissionsMap;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
        return hashMap;
    }

    protected static ResourceCreatePermission getResourceCreateSysPermission(SQLResult resultSet) throws SQLException {
        String sysPermissionName = resultSet.getResourceCreateSysPermissionName("SysPermissionId");
        if (resultSet.getBoolean("IsWithGrant")) {
            return ResourceCreatePermissions.getInstanceWithGrantOption(sysPermissionName);
        }
        return ResourceCreatePermissions.getInstance(sysPermissionName);
    }

    @Override
    public Set<ResourceCreatePermission> getResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId) {
        HashSet<ResourceCreatePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourceCreatePermission> resourceCreatePermissions = new HashSet<ResourceCreatePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourceCreatePermissionSys_withoutInheritance_SysPermissionId_IsWithGrant_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, resourceDomainId);
            statement.setResourceClassId(3, resourceClassId);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourceCreatePermissions.add(CommonGrantResourceCreatePermissionSysPersister.getResourceCreateSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = resourceCreatePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public void addResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourceCreatePermission> requestedResourceCreatePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantResourceCreatePermissionSys_WITH_AccessorID_GrantorID_AccessedDomainID_IsWithGrant_ResourceClassID_SysPermissionId);
            for (ResourceCreatePermission resourceCreatePermission : requestedResourceCreatePermissions) {
                if (!resourceCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceDomainId(3, accessedResourceDomainId);
                statement.setBoolean(4, resourceCreatePermission.isWithGrantOption());
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceCreateSystemPermissionId(6, resourceCreatePermission.getSystemPermissionId());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void updateResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourceCreatePermission> requestedResourceCreatePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantResourceCreatePermissionSys_SET_GrantorID_IsWithGrant_BY__AccessorID_AccessedDomainID_ResourceClassID_SysPermissionId);
            for (ResourceCreatePermission resourceCreatePermission : requestedResourceCreatePermissions) {
                if (!resourceCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, resourceCreatePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceDomainId(4, accessedResourceDomainId);
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceCreateSystemPermissionId(6, resourceCreatePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeAllResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourceCreatePermissionSys_BY_AccessorID);
            statement.setResourceId(1, accessorResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public abstract void removeAllResourceCreateSysPermissions(SQLConnection var1, Id<DomainId> var2);

    @Override
    public void removeResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourceCreatePermissionSys_BY_AccessorID_AccessedDomainID_ResourceClassID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceDomainId(2, accessedResourceDomainId);
            statement.setResourceClassId(3, accessedResourceClassId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeResourceCreateSysPermissions(SQLConnection connection, Resource accessorResource, Id<ResourceClassId> accessedResourceClassId, Id<DomainId> accessedResourceDomainId, Set<ResourceCreatePermission> requestedResourceCreatePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourceCreatePermissionSys_BY_AccessorID_AccessedDomainID_ResourceClassID_SysPermissionID);
            for (ResourceCreatePermission resourceCreatePermission : requestedResourceCreatePermissions) {
                if (!resourceCreatePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceDomainId(2, accessedResourceDomainId);
                statement.setResourceClassId(3, accessedResourceClassId);
                statement.setResourceCreateSystemPermissionId(4, resourceCreatePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourceCreatePermissionSysPersister.closeStatement(statement);
    }
}

