/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantResourcePermissionPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourcePermissionId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class CommonGrantResourcePermissionPersister
extends Persister
implements GrantResourcePermissionPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantResourcePermissionPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<Resource> getResourcesByResourcePermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, ResourcePermission var4, Id<ResourcePermissionId> var5);

    @Override
    public abstract Set<Resource> getResourcesByResourcePermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4, ResourcePermission var5, Id<ResourcePermissionId> var6);

    @Override
    public Set<Resource> getAccessorResourcesByResourcePermission(SQLConnection connection, Resource accessedResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission, Id<ResourcePermissionId> resourcePermissionId) {
        HashSet<Resource> hashSet;
        if (resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a non-system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_ResourceID_ExternalID_BY_AccessedID_ResourceClassID_PermissionID_IsWithGrant);
            statement.setResourceId(1, accessedResource);
            statement.setResourceClassId(2, resourceClassId);
            statement.setResourcePermissionId(3, resourcePermissionId);
            statement.setBoolean(4, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public abstract Set<ResourcePermission> getResourcePermissionsIncludeInherited(SQLConnection var1, Resource var2, Resource var3);

    @Override
    public Set<ResourcePermission> getResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermission_withoutInheritance_ResourceClassName_PermissionName_IsWithGrant_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(CommonGrantResourcePermissionPersister.getResourcePermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
        return hashSet;
    }

    protected static ResourcePermission getResourcePermission(SQLResult resultSet) throws SQLException {
        String permissionName = resultSet.getString("PermissionName");
        if (resultSet.getBoolean("IsWithGrant")) {
            return ResourcePermissions.getInstanceWithGrantOption(permissionName);
        }
        return ResourcePermissions.getInstance(permissionName);
    }

    @Override
    public void addResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantResourcePermission_WITH_AccessorID_GrantorID_AccessedID_IsWithGrant_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceId(3, accessedResource);
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setString(6, resourcePermission.getPermissionName());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void updateResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantResourcePermission_SET_GrantorID_IsWithGrant_BY_AccessorID_AccessedID_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, resourcePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceId(4, accessedResource);
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setString(6, resourcePermission.getPermissionName());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void removeAllResourcePermissionsAsAccessorOrAccessed(SQLConnection connection, Resource resource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermission_BY_AccessorID_OR_AccessedID);
            statement.setResourceId(1, resource);
            statement.setResourceId(2, resource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void removeResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermission_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
    }

    @Override
    public void removeResourcePermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermission_BY_AccessorID_AccessedID_ResourceClassID_PermissionName);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, accessedResource);
                statement.setResourceClassId(3, accessedResourceClassId);
                statement.setString(4, resourcePermission.getPermissionName());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionPersister.closeStatement(statement);
    }
}

