/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.ResourcePermission;
import com.acciente.oacc.ResourcePermissions;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.GrantResourcePermissionSysPersister;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class CommonGrantResourcePermissionSysPersister
extends Persister
implements GrantResourcePermissionSysPersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonGrantResourcePermissionSysPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public abstract Set<Resource> getResourcesByResourceSysPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, ResourcePermission var4);

    @Override
    public abstract Set<Resource> getResourcesByResourceSysPermission(SQLConnection var1, Resource var2, Id<ResourceClassId> var3, Id<DomainId> var4, ResourcePermission var5);

    @Override
    public Set<Resource> getAccessorResourcesByResourceSysPermission(SQLConnection connection, Resource accessedResource, Id<ResourceClassId> resourceClassId, ResourcePermission resourcePermission) {
        HashSet<Resource> hashSet;
        if (!resourcePermission.isSystemPermission()) {
            throw new IllegalArgumentException("Permission: " + resourcePermission + " is not a system permission");
        }
        SQLStatement statement = null;
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_ResourceID_ExternalID_BY_AccessedID_ResourceClassID_SysPermissionID_IsWithGrant);
            statement.setResourceId(1, accessedResource);
            statement.setResourceClassId(2, resourceClassId);
            statement.setResourceSystemPermissionId(3, resourcePermission.getSystemPermissionId());
            statement.setBoolean(4, resourcePermission.isWithGrantOption());
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resources.add(resultSet.getResource("ResourceId", "ExternalId"));
            }
            resultSet.close();
            hashSet = resources;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    @Override
    public abstract Set<ResourcePermission> getResourceSysPermissionsIncludeInherited(SQLConnection var1, Resource var2, Resource var3);

    @Override
    public Set<ResourcePermission> getResourceSysPermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        HashSet<ResourcePermission> hashSet;
        SQLStatement statement = null;
        try {
            HashSet<ResourcePermission> resourcePermissions = new HashSet<ResourcePermission>();
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInGrantResourcePermissionSys_withoutInheritance_ResourceClassName_SysPermissionID_IsWithGrant_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                resourcePermissions.add(CommonGrantResourcePermissionSysPersister.getResourceSysPermission(resultSet));
            }
            resultSet.close();
            hashSet = resourcePermissions;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
        return hashSet;
    }

    protected static ResourcePermission getResourceSysPermission(SQLResult resultSet) throws SQLException {
        String sysPermissionName = resultSet.getResourceSysPermissionName("SysPermissionId");
        if (resultSet.getBoolean("IsWithGrant")) {
            return ResourcePermissions.getInstanceWithGrantOption(sysPermissionName);
        }
        return ResourcePermissions.getInstance(sysPermissionName);
    }

    @Override
    public void addResourceSysPermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInGrantResourcePermissionSys_WITH_AccessorID_GrantorID_AccessedID_IsWithGrant_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, grantorResource);
                statement.setResourceId(3, accessedResource);
                statement.setBoolean(4, resourcePermission.isWithGrantOption());
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceSystemPermissionId(6, resourcePermission.getSystemPermissionId());
                this.assertOneRowInserted(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void updateResourceSysPermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions, Resource grantorResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_updateInGrantResourcePermissionSys_SET_GrantorID_IsWithGrant_BY_AccessorID_AccessedID_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, grantorResource);
                statement.setBoolean(2, resourcePermission.isWithGrantOption());
                statement.setResourceId(3, accessorResource);
                statement.setResourceId(4, accessedResource);
                statement.setResourceClassId(5, accessedResourceClassId);
                statement.setResourceSystemPermissionId(6, resourcePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeAllResourceSysPermissionsAsAccessorOrAccessed(SQLConnection connection, Resource resource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermissionSys_BY_AccessorID_OR_AccessedID);
            statement.setResourceId(1, resource);
            statement.setResourceId(2, resource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeResourceSysPermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermissionSys_BY_AccessorID_AccessedID);
            statement.setResourceId(1, accessorResource);
            statement.setResourceId(2, accessedResource);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
    }

    @Override
    public void removeResourceSysPermissions(SQLConnection connection, Resource accessorResource, Resource accessedResource, Id<ResourceClassId> accessedResourceClassId, Set<ResourcePermission> requestedResourcePermissions) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInGrantResourcePermissionSys_BY_AccessorID_AccessedID_ResourceClassID_SysPermissionID);
            for (ResourcePermission resourcePermission : requestedResourcePermissions) {
                if (!resourcePermission.isSystemPermission()) continue;
                statement.setResourceId(1, accessorResource);
                statement.setResourceId(2, accessedResource);
                statement.setResourceClassId(3, accessedResourceClassId);
                statement.setResourceSystemPermissionId(4, resourcePermission.getSystemPermissionId());
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonGrantResourcePermissionSysPersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonGrantResourcePermissionSysPersister.closeStatement(statement);
    }
}

