/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.Resource;
import com.acciente.oacc.Resources;
import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.Persister;
import com.acciente.oacc.sql.internal.persister.ResourcePersister;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import com.acciente.oacc.sql.internal.persister.id.ResourceClassId;
import com.acciente.oacc.sql.internal.persister.id.ResourceId;
import java.io.Serializable;
import java.sql.SQLException;

public abstract class CommonResourcePersister
extends Persister
implements ResourcePersister,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String[] GENERATED_KEY_COLUMNS = new String[]{"ResourceId"};
    protected final SQLProfile sqlProfile;
    protected final SQLStrings sqlStrings;

    public CommonResourcePersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        this.sqlProfile = sqlProfile;
        this.sqlStrings = sqlStrings;
    }

    @Override
    public void verifyResourceExists(SQLConnection connection, Resource resource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_ResourceId_BY_ResourceID);
            statement.setResourceId(1, resource);
            SQLResult resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new IllegalArgumentException("Resource " + resource + " not found!");
            }
            if (resultSet.next()) {
                throw new IllegalStateException("Resource reference " + resource + " maps to more than one resource!");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
    }

    @Override
    public Resource createResource(SQLConnection connection, Id<ResourceClassId> resourceClassId, Id<DomainId> resourceDomainId, String externalId) {
        Resource resource;
        Id<ResourceId> nextResourceId;
        SQLStatement statement;
        block10: {
            statement = null;
            if (this.sqlProfile.isSequenceEnabled()) {
                nextResourceId = this.getNextResourceId(connection);
                if (nextResourceId == null) {
                    throw new IllegalStateException("could not retrieve next ResourceId from sequence");
                }
                statement = connection.prepareStatement(this.sqlStrings.SQL_createInResource_WITH_ResourceID_ResourceClassID_DomainID);
                statement.setResourceId(1, nextResourceId);
                statement.setResourceClassId(2, resourceClassId);
                statement.setResourceDomainId(3, resourceDomainId);
                this.assertOneRowInserted(statement.executeUpdate());
            } else {
                statement = connection.prepareStatement(this.sqlStrings.SQL_createInResource_WITH_ResourceClassID_DomainID, GENERATED_KEY_COLUMNS);
                statement.setResourceClassId(1, resourceClassId);
                statement.setResourceDomainId(2, resourceDomainId);
                this.assertOneRowInserted(statement.executeUpdate());
                SQLResult generatedKeys = statement.getGeneratedKeys();
                if (!generatedKeys.next()) {
                    throw new IllegalStateException("could not retrieve auto-generated ResourceId");
                }
                nextResourceId = generatedKeys.getNextResourceId(1);
                if (nextResourceId == null) {
                    throw new IllegalStateException("could not retrieve auto-generated ResourceId");
                }
                generatedKeys.close();
            }
            CommonResourcePersister.closeStatement(statement);
            if (externalId == null) break block10;
            resource = this.setExternalId(connection, nextResourceId, externalId);
            CommonResourcePersister.closeStatement(statement);
            return resource;
        }
        try {
            resource = Resources.getInstance(nextResourceId.getValue());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return resource;
    }

    @Override
    public Resource setExternalId(SQLConnection connection, Id<ResourceId> resourceId, String externalId) {
        Resource resource;
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_createInResourceExternalId_WITH_ResourceID_ExternalID);
            statement.setResourceId(1, resourceId);
            statement.setString(2, externalId);
            this.assertOneRowInserted(statement.executeUpdate());
            resource = Resources.getInstance(resourceId.getValue(), externalId);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return resource;
    }

    @Override
    public void deleteResource(SQLConnection connection, Resource resource) {
        SQLStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInResourceExternalId_BY_ResourceID);
            statement.setResourceId(1, resource);
            statement.executeUpdate();
            CommonResourcePersister.closeStatement(statement);
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInResource_BY_ResourceID);
            statement.setResourceId(1, resource);
            this.assertOneRowUpdated(statement.executeUpdate());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
    }

    @Override
    public Id<DomainId> getDomainIdByResource(SQLConnection connection, Resource resource) {
        Id<DomainId> id;
        SQLStatement statement = null;
        try {
            Id<DomainId> domainId = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_DomainID_BY_ResourceID);
            statement.setResourceId(1, resource);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                domainId = resultSet.getResourceDomainId("DomainId");
            }
            if (domainId == null) {
                throw new IllegalArgumentException("Could not determine domain for resource: " + resource);
            }
            id = domainId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return id;
    }

    @Override
    public Id<ResourceId> getNextResourceId(SQLConnection connection) {
        Id<ResourceId> id;
        SQLStatement statement = null;
        Id<ResourceId> newResourceId = null;
        try {
            statement = connection.prepareStatement(this.sqlStrings.SQL_nextResourceID);
            SQLResult resultSet = statement.executeQuery();
            if (resultSet.next()) {
                newResourceId = resultSet.getNextResourceId(1);
            }
            resultSet.close();
            id = newResourceId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return id;
    }

    @Override
    public abstract boolean isDomainEmpty(SQLConnection var1, Id<DomainId> var2);

    @Override
    public Resource resolveResourceByExternalId(SQLConnection connection, String externalId) {
        Resource resource;
        SQLResult resultSet;
        SQLStatement statement;
        block6: {
            statement = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResourceExternalId_ResourceId_ExternalId_BY_ExternalID);
            statement.setString(1, externalId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) break block6;
            Resource resource2 = null;
            CommonResourcePersister.closeStatement(statement);
            return resource2;
        }
        try {
            Resource resolvedResourceId = resultSet.getResource("ResourceId", "ExternalId");
            if (resultSet.next()) {
                throw new IllegalStateException("External id " + externalId + " maps to more than one resource!");
            }
            resource = resolvedResourceId;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return resource;
    }

    @Override
    public Resource resolveResourceByResourceId(SQLConnection connection, Resource resource) {
        Resource resource2;
        SQLResult resultSet;
        SQLStatement statement;
        block6: {
            statement = null;
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInResource_ResourceId_ExternalId_BY_ResourceID);
            statement.setResourceId(1, resource);
            resultSet = statement.executeQuery();
            if (resultSet.next()) break block6;
            Resource resource3 = null;
            CommonResourcePersister.closeStatement(statement);
            return resource3;
        }
        try {
            Resource resolvedResource = resultSet.getResource("ResourceId", "ExternalId");
            if (resultSet.next()) {
                throw new IllegalStateException("Resource " + resource + " maps to more than one resource!");
            }
            resource2 = resolvedResource;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonResourcePersister.closeStatement(statement);
                throw throwable;
            }
        }
        CommonResourcePersister.closeStatement(statement);
        return resource2;
    }
}

