/*
 * Decompiled with CFR 0.152.
 */
package com.acciente.oacc.sql.internal.persister;

import com.acciente.oacc.sql.SQLProfile;
import com.acciente.oacc.sql.internal.persister.CommonDomainPersister;
import com.acciente.oacc.sql.internal.persister.NonRecursivePersisterHelper;
import com.acciente.oacc.sql.internal.persister.SQLConnection;
import com.acciente.oacc.sql.internal.persister.SQLResult;
import com.acciente.oacc.sql.internal.persister.SQLStatement;
import com.acciente.oacc.sql.internal.persister.SQLStrings;
import com.acciente.oacc.sql.internal.persister.id.DomainId;
import com.acciente.oacc.sql.internal.persister.id.Id;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NonRecursiveDomainPersister
extends CommonDomainPersister
implements Serializable {
    private static final long serialVersionUID = 1L;

    public NonRecursiveDomainPersister(SQLProfile sqlProfile, SQLStrings sqlStrings) {
        super(sqlProfile, sqlStrings);
    }

    @Override
    public Set<String> getResourceDomainNameDescendants(SQLConnection connection, String resourceDomainName) {
        SQLStatement statement = null;
        try {
            if (this.getResourceDomainId(connection, resourceDomainName) == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            HashSet<String> allDescendantDomainNames = new HashSet<String>();
            HashSet<Id<DomainId>> previousDescendantDomainIds = new HashSet<Id<DomainId>>();
            allDescendantDomainNames.add(resourceDomainName);
            statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DirectDescendantResourceDomainName_BY_ResourceDomainName);
            statement.setString(1, resourceDomainName);
            SQLResult resultSet = statement.executeQuery();
            while (resultSet.next()) {
                allDescendantDomainNames.add(resultSet.getString("DomainName"));
                previousDescendantDomainIds.add(resultSet.getResourceDomainId("DomainId"));
            }
            statement.close();
            if (allDescendantDomainNames.size() > 1) {
                HashSet<Id<DomainId>> newestDescendantDomainIds = new HashSet<Id<DomainId>>();
                int prevTotalOfDescendantDomains = 1;
                while (allDescendantDomainNames.size() > prevTotalOfDescendantDomains) {
                    prevTotalOfDescendantDomains = allDescendantDomainNames.size();
                    for (Id id : previousDescendantDomainIds) {
                        statement = connection.prepareStatement(this.sqlStrings.SQL_findInDomain_DirectDescendantResourceDomainName_BY_DomainID);
                        statement.setResourceDomainId(1, id);
                        resultSet = statement.executeQuery();
                        while (resultSet.next()) {
                            allDescendantDomainNames.add(resultSet.getString("DomainName"));
                            newestDescendantDomainIds.add(resultSet.getResourceDomainId("DomainId"));
                        }
                        statement.close();
                    }
                    previousDescendantDomainIds = newestDescendantDomainIds;
                }
            }
            HashSet<String> hashSet = allDescendantDomainNames;
            NonRecursiveDomainPersister.closeStatement(statement);
            return hashSet;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            NonRecursiveDomainPersister.closeStatement(statement);
        }
    }

    @Override
    public void deleteDomain(SQLConnection connection, Id<DomainId> domainId) {
        SQLStatement statement = null;
        try {
            ArrayList<Id<DomainId>> descendantDomainIds = new ArrayList<Id<DomainId>>(NonRecursivePersisterHelper.getDescendantDomainIdsOrderedByAscendingLevel(this.sqlStrings, connection, domainId));
            statement = connection.prepareStatement(this.sqlStrings.SQL_removeInDomain_BY_DomainID);
            for (int i = descendantDomainIds.size() - 1; i >= 0; --i) {
                statement.setResourceDomainId(1, (Id)descendantDomainIds.get(i));
                this.assertOneRowUpdated(statement.executeUpdate());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                NonRecursiveDomainPersister.closeStatement(statement);
                throw throwable;
            }
        }
        NonRecursiveDomainPersister.closeStatement(statement);
    }
}

